/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.handler;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.solver.core.handler.AbstractLoopActionHandler;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public class CollectionIteratorActionHandler
extends AbstractLoopActionHandler {
    private static Logger logger = Logger.getLogger((String)CollectionIteratorActionHandler.class.getName());

    public CollectionIteratorActionHandler(SeffVisitor seffVisitor) {
        super(seffVisitor);
    }

    public void handle(CollectionIteratorAction collIterAction) {
        Parameter parameter = collIterAction.getParameter_CollectionIteratorAction();
        String parameterName = parameter.getParameterName();
        String iterCount = this.getIterationExpression(parameterName);
        if (iterCount == null) {
            logger.error((Object)"Skipping execution of loop body!");
            return;
        }
        this.storeToUsageContext((AbstractLoopAction)collIterAction, iterCount);
        this.visitLoopBody((AbstractLoopAction)collIterAction, iterCount);
    }

    private String getIterationExpression(String soughtParameterName) {
        EList vuList = this.visitor.getContextWrapper().getCompUsgCtx().getInput_ComputedUsageContext().getParameterChacterisations_Input();
        for (VariableUsage vu : vuList) {
            String currentParameterName = "";
            AbstractNamedReference ref = vu.getNamedReference__VariableUsage();
            while (ref instanceof NamespaceReference) {
                NamespaceReference nsRef = (NamespaceReference)ref;
                currentParameterName = String.valueOf(currentParameterName) + nsRef.getReferenceName() + ".";
                ref = nsRef.getInnerReference_NamespaceReference();
            }
            if (!(currentParameterName = String.valueOf(currentParameterName) + ref.getReferenceName()).equals(soughtParameterName)) continue;
            EList varChars = vu.getVariableCharacterisation_VariableUsage();
            for (VariableCharacterisation vc : varChars) {
                if (vc.getType() != VariableCharacterisationType.NUMBER_OF_ELEMENTS) continue;
                return vc.getSpecification_VariableCharacterisation().getSpecification();
            }
            logger.error((Object)("Variable Characterisation NUMBER_OF_ELEMENTS missing in Usage Context for parameter " + soughtParameterName + ")! " + "It is needed for a CollectionIteratorAction."));
            return null;
        }
        logger.error((Object)("Variable " + soughtParameterName + " missing " + "in Usage Context!"));
        return null;
    }
}

