/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.visitors;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.AggregatedContextSEFFVisitor;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.core.visitors.UsageModelVisitor;

public class AggregatedContextUsageModelVisitor
extends UsageModelVisitor {
    private double currentFrequency = 1.0;
    private UsageScenario currentScenario = null;

    public AggregatedContextUsageModelVisitor(PCMInstance inst) {
        super(inst);
        logger = Logger.getLogger((String)AggregatedContextUsageModelVisitor.class.getName());
    }

    public Object caseUsageModel(UsageModel object) {
        EList scenarios = object.getUsageScenario_UsageModel();
        Iterator iterator = scenarios.iterator();
        while (iterator.hasNext()) {
            UsageScenario usageScenario;
            this.currentScenario = usageScenario = (UsageScenario)iterator.next();
            this.doSwitch((EObject)usageScenario.getScenarioBehaviour_UsageScenario());
        }
        return null;
    }

    @Override
    public Object caseScenarioBehaviour(ScenarioBehaviour object) {
        double oldProbability = this.currentFrequency;
        EObject container = object.eContainer();
        if (container instanceof BranchTransition) {
            BranchTransition branchTransition = (BranchTransition)container;
            this.currentFrequency *= branchTransition.getBranchProbability();
        } else if (container instanceof Loop) {
            Loop loop = (Loop)container;
            this.currentFrequency *= ExpressionHelper.meanValue(ExpressionHelper.getSolvedExpression(loop.getLoopIteration_Loop().getSpecification(), this.myContextWrapper));
        }
        Object result = super.caseScenarioBehaviour(object);
        this.currentFrequency = oldProbability;
        return result;
    }

    @Override
    public Object caseEntryLevelSystemCall(EntryLevelSystemCall elsc) {
        logger.debug((Object)"VisitEntryLevelSystemCall");
        logger.debug((Object)("Called System Method " + elsc.getOperationSignature__EntryLevelSystemCall().getEntityName()));
        List<ContextWrapper> contextWrapperList = this.myContextWrapper == null ? ContextWrapper.getContextWrapperFor(elsc, this.pcmInstance) : this.myContextWrapper.getContextWrapperFor(elsc);
        for (ContextWrapper contextWrapper : contextWrapperList) {
            ServiceEffectSpecification seff = contextWrapper.getNextSEFF(elsc);
            AggregatedContextSEFFVisitor visitor = new AggregatedContextSEFFVisitor(contextWrapper, this.currentFrequency, seff, this.currentScenario);
            visitor.doSwitch((EObject)seff);
        }
        this.doSwitch((EObject)elsc.getSuccessor());
        return elsc;
    }
}

