/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.visitors;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.parameter.ParameterFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationFactory;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.EMFQueryHelper;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public class UsageModelVisitor
extends UsagemodelSwitch {
    protected static Logger logger = Logger.getLogger((String)UsageModelVisitor.class.getName());
    protected PCMInstance pcmInstance;
    private ComputedUsageFactory compUsageFactory;
    private ComputedAllocationFactory compAllocationFactory;
    private ParameterFactory parameterFactory;
    protected ContextWrapper myContextWrapper = null;

    public UsageModelVisitor(PCMInstance inst) {
        this.pcmInstance = inst;
        this.compUsageFactory = ComputedUsageFactory.eINSTANCE;
        this.compAllocationFactory = ComputedAllocationFactory.eINSTANCE;
        this.parameterFactory = ParameterFactory.eINSTANCE;
    }

    public Object caseScenarioBehaviour(ScenarioBehaviour object) {
        logger.debug((Object)"VisitScenarioBehaviour");
        this.doSwitch((EObject)this.getStartAction(object));
        return object;
    }

    public Object caseStart(Start object) {
        logger.debug((Object)"VisitStart");
        this.doSwitch((EObject)object.getSuccessor());
        return object;
    }

    public Object caseStop(Stop object) {
        logger.debug((Object)"VisitStop");
        return object;
    }

    public Object caseBranch(Branch object) {
        logger.debug((Object)"VisitBranch");
        EList btList = object.getBranchTransitions_Branch();
        for (BranchTransition bt : btList) {
            this.doSwitch((EObject)bt.getBranchedBehaviour_BranchTransition());
        }
        this.doSwitch((EObject)object.getSuccessor());
        return object;
    }

    public Object caseEntryLevelSystemCall(EntryLevelSystemCall elsc) {
        logger.debug((Object)"VisitEntryLevelSystemCall");
        logger.debug((Object)("Called System Method " + elsc.getOperationSignature__EntryLevelSystemCall().getEntityName()));
        List<ContextWrapper> contextWrapperList = this.myContextWrapper == null ? ContextWrapper.getContextWrapperFor(elsc, this.pcmInstance) : this.myContextWrapper.getContextWrapperFor(elsc);
        for (ContextWrapper contextWrapper : contextWrapperList) {
            ServiceEffectSpecification seff = contextWrapper.getNextSEFF(elsc);
            SeffVisitor visitor = new SeffVisitor(contextWrapper);
            visitor.doSwitch((EObject)seff);
        }
        this.doSwitch((EObject)elsc.getSuccessor());
        return elsc;
    }

    public Object caseDelay(Delay object) {
        logger.debug((Object)"VisitDelay");
        this.doSwitch((EObject)object.getSuccessor());
        return object;
    }

    public Object caseLoop(Loop object) {
        logger.debug((Object)"VisitLoop");
        this.doSwitch((EObject)object.getBodyBehaviour_Loop());
        this.doSwitch((EObject)object.getSuccessor());
        return object;
    }

    private Start getStartAction(ScenarioBehaviour object) {
        Start startAction = (Start)EMFQueryHelper.getObjectByType(object.getActions_ScenarioBehaviour(), Start.class);
        return startAction;
    }
}

