/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.visitors;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.Variable;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionSolveVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.parameter.CharacterisedVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.stoex.api.StoExSerialiser;
import org.palladiosimulator.solver.context.computed_usage.ExternalCallOutput;
import org.palladiosimulator.solver.context.computed_usage.Input;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;

public class ExpressionParameterSolverVisitor
extends ExpressionSolveVisitor {
    private static final StoExSerialiser STOEX_SERIALISER = StoExSerialiser.createInstance();
    private ContextWrapper contextWrapper;

    public ExpressionParameterSolverVisitor(HashMap<Expression, TypeEnum> typeAnn, ContextWrapper ctxWrp) {
        super(typeAnn, arg_0 -> ((StoExSerialiser)STOEX_SERIALISER).serialise(arg_0));
        this.contextWrapper = ctxWrp;
    }

    public Object caseVariable(Variable var) {
        AbstractNamedReference anr = var.getId_Variable();
        CharacterisedVariable chVar = (CharacterisedVariable)var;
        BasicEList vuList = new BasicEList();
        Input input = this.contextWrapper.getCompUsgCtx().getInput_ComputedUsageContext();
        if (input != null) {
            vuList.addAll((Collection)input.getParameterChacterisations_Input());
        }
        EList ecoList = this.contextWrapper.getCompUsgCtx().getExternalCallOutput_ComputedUsageContext();
        for (ExternalCallOutput eco : ecoList) {
            EList vuList2 = eco.getParameterCharacterisations_ExternalCallOutput();
            vuList.addAll((Collection)vuList2);
        }
        String soughtParameterName = this.getFullParameterName(anr);
        for (VariableUsage vu : vuList) {
            AbstractNamedReference ref = vu.getNamedReference__VariableUsage();
            String currentParameterName = this.getFullParameterName(ref);
            if (!currentParameterName.equals(soughtParameterName)) continue;
            EList varCharList = vu.getVariableCharacterisation_VariableUsage();
            for (VariableCharacterisation vc : varCharList) {
                if (vc.getType() != chVar.getCharacterisationType()) continue;
                String specification = vc.getSpecification_VariableCharacterisation().getSpecification();
                Expression expr = ExpressionHelper.parseToExpression(specification);
                return expr;
            }
            throw new RuntimeException("Variable Characterisation missing in Usage Context (" + soughtParameterName + ")!");
        }
        throw new RuntimeException("Variable Characterisation missing in Usage Context (" + soughtParameterName + ")!");
    }

    private String getFullParameterName(AbstractNamedReference ref) {
        String name = "";
        while (ref instanceof NamespaceReference) {
            NamespaceReference nsRef = (NamespaceReference)ref;
            name = String.valueOf(name) + nsRef.getReferenceName() + ".";
            ref = nsRef.getInnerReference_NamespaceReference();
        }
        name = String.valueOf(name) + ref.getReferenceName();
        return name;
    }
}

