/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.transformations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;

public class PCMInstanceHelper {
    public static List<AssemblyContext> getHandlingAssemblyContexts(EntryLevelSystemCall call, System system) {
        AssemblyContext topLevelAssCtx = null;
        OperationProvidedRole topLevelAssCtxProvidedRole = null;
        for (Connector conn : system.getConnectors__ComposedStructure()) {
            ProvidedDelegationConnector pdc;
            if (!(conn instanceof ProvidedDelegationConnector) || !(pdc = (ProvidedDelegationConnector)conn).getOuterProvidedRole_ProvidedDelegationConnector().getId().equals(call.getProvidedRole_EntryLevelSystemCall().getId())) continue;
            topLevelAssCtx = pdc.getAssemblyContext_ProvidedDelegationConnector();
            topLevelAssCtxProvidedRole = pdc.getInnerProvidedRole_ProvidedDelegationConnector();
        }
        if (topLevelAssCtx != null) {
            return PCMInstanceHelper.getHandlingAssemblyContexts(topLevelAssCtx, topLevelAssCtxProvidedRole, (List<AssemblyContext>)new BasicEList());
        }
        throw new IllegalArgumentException("No ProvidedDelegationConnector found in system \"" + system.getEntityName() + "\" that matches the EntryLevelSystemCall \"" + call.getEntityName() + "\".");
    }

    public static List<AssemblyContext> getHandlingAssemblyContexts(ExternalCallAction call, List<AssemblyContext> encapsulatingContexts) {
        ArrayList<AssemblyContext> contexts = new ArrayList<AssemblyContext>();
        contexts.addAll(encapsulatingContexts);
        AssemblyConnector connector = PCMInstanceHelper.getAssemblyConnectorForRequiredRole(call.getRole_ExternalService(), (OperationInterface)call.getCalledService_ExternalService().eContainer(), contexts);
        if (connector == null) {
            return new ArrayList<AssemblyContext>();
        }
        return PCMInstanceHelper.getHandlingAssemblyContexts(connector.getProvidingAssemblyContext_AssemblyConnector(), connector.getProvidedRole_AssemblyConnector(), contexts);
    }

    private static AssemblyConnector getAssemblyConnectorForRequiredRole(OperationRequiredRole requiredRole, OperationInterface requiredInterface, List<AssemblyContext> nestedContexts) {
        OperationRequiredRole currentRequiredRole = requiredRole;
        AssemblyContext currentContext = null;
        while (!nestedContexts.isEmpty()) {
            currentContext = nestedContexts.get(nestedContexts.size() - 1);
            nestedContexts.remove(currentContext);
            AssemblyConnector matchingAssConn = PCMInstanceHelper.getAssemblyConnectorForRequiringAssemblyContext(currentRequiredRole, requiredInterface, currentContext);
            if (matchingAssConn != null) {
                return matchingAssConn;
            }
            RequiredDelegationConnector matchingDeleConn = PCMInstanceHelper.getDelegationConnectorForRequiringAssemblyContext(currentRequiredRole, requiredInterface, currentContext);
            if (matchingDeleConn == null) {
                throw new IllegalArgumentException("Neither an AssemblyConnector nor a RequiredDelegationConnector could be found connected to the OperationRequiredRole \"" + currentRequiredRole.getEntityName() + "\" for the OperationInterface \"" + requiredInterface.getEntityName() + "\" of the AssemblyContext \"" + currentContext.getEntityName() + "\".");
            }
            currentRequiredRole = matchingDeleConn.getOuterRequiredRole_RequiredDelegationConnector();
        }
        return null;
    }

    private static AssemblyConnector getAssemblyConnectorForRequiringAssemblyContext(OperationRequiredRole requiredRole, OperationInterface requiredInterface, AssemblyContext requiringContext) {
        EList connList = requiringContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure();
        for (Connector conn : connList) {
            AssemblyConnector assConn;
            if (!(conn instanceof AssemblyConnector) || !(assConn = (AssemblyConnector)conn).getRequiringAssemblyContext_AssemblyConnector().getId().equals(requiringContext.getId()) || !assConn.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole().getId().equals(requiredInterface.getId()) || !assConn.getRequiredRole_AssemblyConnector().getId().equals(requiredRole.getId())) continue;
            return assConn;
        }
        return null;
    }

    private static RequiredDelegationConnector getDelegationConnectorForRequiringAssemblyContext(OperationRequiredRole requiredRole, OperationInterface requiredInterface, AssemblyContext requiringContext) {
        EList connList = requiringContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure();
        for (Connector conn : connList) {
            RequiredDelegationConnector dc;
            if (!(conn instanceof RequiredDelegationConnector) || !(dc = (RequiredDelegationConnector)conn).getAssemblyContext_RequiredDelegationConnector().getId().equals(requiringContext.getId()) || !dc.getInnerRequiredRole_RequiredDelegationConnector().getRequiredInterface__OperationRequiredRole().getId().equals(requiredInterface.getId()) || !dc.getInnerRequiredRole_RequiredDelegationConnector().getId().equals(requiredRole.getId())) continue;
            return dc;
        }
        return null;
    }

    private static List<AssemblyContext> getHandlingAssemblyContexts(AssemblyContext topLevelContexts, OperationProvidedRole topLevelProvidedRole, List<AssemblyContext> existingContexts) {
        existingContexts.add(topLevelContexts);
        RepositoryComponent rc = topLevelContexts.getEncapsulatedComponent__AssemblyContext();
        if (rc instanceof BasicComponent) {
            return existingContexts;
        }
        if (rc instanceof ComposedStructure) {
            ComposedStructure cs = (ComposedStructure)rc;
            for (Connector conn : cs.getConnectors__ComposedStructure()) {
                ProvidedDelegationConnector pdc;
                if (!(conn instanceof ProvidedDelegationConnector) || !(pdc = (ProvidedDelegationConnector)conn).getOuterProvidedRole_ProvidedDelegationConnector().getId().equals(topLevelProvidedRole.getId())) continue;
                AssemblyContext nestedAssCtx = pdc.getAssemblyContext_ProvidedDelegationConnector();
                OperationProvidedRole nestedProvidedRole = pdc.getInnerProvidedRole_ProvidedDelegationConnector();
                return PCMInstanceHelper.getHandlingAssemblyContexts(nestedAssCtx, nestedProvidedRole, existingContexts);
            }
            throw new IllegalArgumentException("No ProvidedDelegationConnector found in ComposedStructure \"" + cs.getEntityName() + "\" that matches the OperationProvidedRole \"" + topLevelProvidedRole.getEntityName() + "\".");
        }
        throw new IllegalArgumentException("Unknown component type \"" + rc.eClass().getName() + "\" encapsulated by AssemblyContext \"" + topLevelContexts.getEntityName() + "\"");
    }
}

