/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.lqn;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XmlDebugType implements Enumerator
{
    TRUE(0, "true", "true"),
    FALSE(1, "false", "false");

    public static final int TRUE_VALUE = 0;
    public static final int FALSE_VALUE = 1;
    private static final XmlDebugType[] VALUES_ARRAY;
    public static final List<XmlDebugType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XmlDebugType[]{TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XmlDebugType get(String literal) {
        XmlDebugType[] xmlDebugTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            XmlDebugType result = xmlDebugTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static XmlDebugType getByName(String name) {
        XmlDebugType[] xmlDebugTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            XmlDebugType result = xmlDebugTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static XmlDebugType get(int value) {
        switch (value) {
            case 0: {
                return TRUE;
            }
            case 1: {
                return FALSE;
            }
        }
        return null;
    }

    private XmlDebugType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

