/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.lqn;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RWLockType implements Enumerator
{
    RUNLOCK(0, "rUnlock", "r-unlock"),
    RLOCK(1, "rLock", "r-lock"),
    WUNLOCK(2, "wUnlock", "w-unlock"),
    WLOCK(3, "wLock", "w-lock");

    public static final int RUNLOCK_VALUE = 0;
    public static final int RLOCK_VALUE = 1;
    public static final int WUNLOCK_VALUE = 2;
    public static final int WLOCK_VALUE = 3;
    private static final RWLockType[] VALUES_ARRAY;
    public static final List<RWLockType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RWLockType[]{RUNLOCK, RLOCK, WUNLOCK, WLOCK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RWLockType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RWLockType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RWLockType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RWLockType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RWLockType get(int value) {
        switch (value) {
            case 0: {
                return RUNLOCK;
            }
            case 1: {
                return RLOCK;
            }
            case 2: {
                return WUNLOCK;
            }
            case 3: {
                return WLOCK;
            }
        }
        return null;
    }

    private RWLockType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

