/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.lqn;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TaskSchedulingType implements Enumerator
{
    REF(0, "ref", "ref"),
    FCFS(1, "fcfs", "fcfs"),
    PRI(2, "pri", "pri"),
    HOL(3, "hol", "hol"),
    BURST(4, "burst", "burst"),
    UNIFORM(5, "uniform", "uniform"),
    POLL(6, "poll", "poll"),
    INF(7, "inf", "inf"),
    SEMAPHORE(8, "semaphore", "semaphore"),
    RWLOCK(9, "rwlock", "rwlock");

    public static final int REF_VALUE = 0;
    public static final int FCFS_VALUE = 1;
    public static final int PRI_VALUE = 2;
    public static final int HOL_VALUE = 3;
    public static final int BURST_VALUE = 4;
    public static final int UNIFORM_VALUE = 5;
    public static final int POLL_VALUE = 6;
    public static final int INF_VALUE = 7;
    public static final int SEMAPHORE_VALUE = 8;
    public static final int RWLOCK_VALUE = 9;
    private static final TaskSchedulingType[] VALUES_ARRAY;
    public static final List<TaskSchedulingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TaskSchedulingType[]{REF, FCFS, PRI, HOL, BURST, UNIFORM, POLL, INF, SEMAPHORE, RWLOCK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TaskSchedulingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TaskSchedulingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TaskSchedulingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TaskSchedulingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TaskSchedulingType get(int value) {
        switch (value) {
            case 0: {
                return REF;
            }
            case 1: {
                return FCFS;
            }
            case 2: {
                return PRI;
            }
            case 3: {
                return HOL;
            }
            case 4: {
                return BURST;
            }
            case 5: {
                return UNIFORM;
            }
            case 6: {
                return POLL;
            }
            case 7: {
                return INF;
            }
            case 8: {
                return SEMAPHORE;
            }
            case 9: {
                return RWLOCK;
            }
        }
        return null;
    }

    private TaskSchedulingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

