/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver.visitor;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInFrequencyDomainException;
import java.util.Hashtable;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.solver.spa.basicsolver.visitor.AlternativeHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.LoopHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.SequenceHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.SymbolHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler.PerformanceAlternativeHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler.PerformanceHandlerFactory;
import org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler.PerformanceLoopHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler.PerformanceSequenceHandler;
import org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler.PerformanceSymbolHandler;
import org.palladiosimulator.solver.spa.expression.Alternative;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.Loop;
import org.palladiosimulator.solver.spa.expression.Sequence;
import org.palladiosimulator.solver.spa.expression.Symbol;
import org.palladiosimulator.solver.spa.expression.util.ExpressionSwitch;

public class PerformanceVisitor {
    private PerformanceAlternativeHandler altHandler;
    private PerformanceLoopHandler loopHandler;
    private PerformanceSequenceHandler seqHandler;
    private PerformanceSymbolHandler symHandler;
    private Hashtable<Expression, IProbabilityDensityFunction> pdfTable;
    private ExpressionSwitch exprswitch = new ExpressionSwitch(){

        public Object caseAlternative(Alternative alternative) {
            this.doSwitch((EObject)alternative.getLeftOption().getRegexp());
            this.doSwitch((EObject)alternative.getRightOption().getRegexp());
            PerformanceVisitor.this.altHandler.handle(alternative);
            return alternative;
        }

        public Object caseLoop(Loop loop) {
            this.doSwitch((EObject)loop.getRegExp());
            PerformanceVisitor.this.loopHandler.handle(loop);
            return loop;
        }

        public Object caseSequence(Sequence sequence) {
            this.doSwitch((EObject)sequence.getLeftRegExp());
            this.doSwitch((EObject)sequence.getRightRegExp());
            PerformanceVisitor.this.seqHandler.handle(sequence);
            return sequence;
        }

        public Object caseSymbol(Symbol symbol) {
            PerformanceVisitor.this.symHandler.handle(symbol);
            return symbol;
        }
    };

    private PerformanceVisitor() {
    }

    public PerformanceVisitor(PerformanceAlternativeHandler altHandler, PerformanceLoopHandler loopHandler, PerformanceSequenceHandler seqHandler, PerformanceSymbolHandler symHandler, Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this();
        this.altHandler = altHandler;
        this.loopHandler = loopHandler;
        this.seqHandler = seqHandler;
        this.symHandler = symHandler;
        this.pdfTable = pdfTable;
    }

    public PerformanceVisitor(PerformanceHandlerFactory factory) {
        this();
        this.altHandler = factory.createAlternativeHandler();
        this.seqHandler = factory.createSequenceHandler();
        this.loopHandler = factory.createLoopHandler();
        this.symHandler = factory.createSymbolHandler();
        this.pdfTable = factory.getPdfTable();
    }

    public IProbabilityDensityFunction getResponseTime(Expression expression) {
        try {
            if (this.pdfTable.get(expression) == null) {
                this.exprswitch.doSwitch((EObject)expression);
            }
            return this.pdfTable.get(expression).getInverseFourierTransform();
        }
        catch (FunctionNotInFrequencyDomainException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public void reset() {
        this.pdfTable.clear();
    }

    public void setPDFTable(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
        this.loopHandler.setPdfTable(pdfTable);
        this.altHandler.setPdfTable(pdfTable);
        this.seqHandler.setPdfTable(pdfTable);
        this.symHandler.setPdfTable(pdfTable);
    }

    public AlternativeHandler getAltHandler() {
        return this.altHandler;
    }

    public void setAltHandler(PerformanceAlternativeHandler altHandler) {
        this.altHandler = altHandler;
    }

    public LoopHandler getLoopHandler() {
        return this.loopHandler;
    }

    public void setLoopHandler(PerformanceLoopHandler loopHandler) {
        this.loopHandler = loopHandler;
    }

    public SequenceHandler getSeqHandler() {
        return this.seqHandler;
    }

    public void setSeqHandler(PerformanceSequenceHandler seqHandler) {
        this.seqHandler = seqHandler;
    }

    public SymbolHandler getSymHandler() {
        return this.symHandler;
    }

    public void setSymHandler(PerformanceSymbolHandler symHandler) {
        this.symHandler = symHandler;
    }
}

