/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import java.util.Hashtable;
import org.palladiosimulator.solver.spa.basicsolver.visitor.AlternativeHandler;
import org.palladiosimulator.solver.spa.expression.Alternative;
import org.palladiosimulator.solver.spa.expression.Expression;

public class PerformanceAlternativeHandler
implements AlternativeHandler {
    private Hashtable<Expression, IProbabilityDensityFunction> pdfTable;

    protected PerformanceAlternativeHandler(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }

    @Override
    public void handle(Alternative alt) {
        try {
            IProbabilityDensityFunction leftDF = this.pdfTable.get(alt.getLeftOption().getRegexp());
            IProbabilityDensityFunction rightDF = this.pdfTable.get(alt.getRightOption().getRegexp());
            double rightProb = alt.getRightOption().getProbability();
            double leftProb = alt.getLeftOption().getProbability();
            IProbabilityDensityFunction altPDF = leftDF.scale(leftProb).add(rightDF.scale(rightProb));
            this.pdfTable.put((Expression)alt, altPDF);
        }
        catch (FunctionsInDifferenDomainsException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IncompatibleUnitsException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Hashtable<Expression, IProbabilityDensityFunction> getPdfTable() {
        return this.pdfTable;
    }

    public void setPdfTable(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }

    public PerformanceAlternativeHandler() {
    }
}

