/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import java.util.Hashtable;
import org.palladiosimulator.solver.spa.basicsolver.visitor.LoopHandler;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.Loop;

public class PerformanceLoopHandler
implements LoopHandler {
    private Hashtable<Expression, IProbabilityDensityFunction> pdfTable;
    private static IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;

    protected PerformanceLoopHandler(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }

    @Override
    public void handle(Loop loop) {
        try {
            ISamplePDF innerPDF = pfFactory.transformToSamplePDF(this.pdfTable.get(loop.getRegExp()));
            IProbabilityMassFunction iterations = pfFactory.transformToPMF(loop.getIterationsPMF());
            ISamplePDF result = PerformanceLoopHandler.solveIterative(iterations, innerPDF);
            this.pdfTable.put((Expression)loop, (IProbabilityDensityFunction)result);
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static ISamplePDF solveIterative(IProbabilityMassFunction iterations, ISamplePDF innerFourier) throws ProbabilityFunctionException {
        int numSamplingPoints = innerFourier.getValuesAsDouble().size();
        double distance = innerFourier.getDistance();
        IUnit unit = innerFourier.getUnit();
        ISamplePDF result = (ISamplePDF)pfFactory.createZeroFunction(numSamplingPoints, distance, unit).getFourierTransform();
        ISamplePDF dirac = pfFactory.createDiracImpulse(numSamplingPoints, distance, unit);
        IProbabilityDensityFunction tmp = dirac.getFourierTransform();
        int pos = 0;
        for (ISample sample : iterations.getSamples()) {
            Integer nextPos = (Integer)sample.getValue();
            while (pos < nextPos) {
                tmp = tmp.mult((IProbabilityDensityFunction)innerFourier);
                ++pos;
            }
            result = (ISamplePDF)result.add(tmp.scale(sample.getProbability()));
        }
        return result;
    }

    public Hashtable<Expression, IProbabilityDensityFunction> getPdfTable() {
        return this.pdfTable;
    }

    public void setPdfTable(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }

    protected PerformanceLoopHandler() {
    }
}

