/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import java.util.Hashtable;
import org.palladiosimulator.solver.spa.basicsolver.visitor.SequenceHandler;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.Sequence;

public class PerformanceSequenceHandler
implements SequenceHandler {
    private Hashtable<Expression, IProbabilityDensityFunction> pdfTable;

    protected PerformanceSequenceHandler(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }

    @Override
    public void handle(Sequence seq) {
        try {
            IProbabilityDensityFunction leftDF = this.pdfTable.get(seq.getLeftRegExp());
            IProbabilityDensityFunction rightDF = this.pdfTable.get(seq.getRightRegExp());
            IProbabilityDensityFunction seqPDF = leftDF.mult(rightDF);
            this.pdfTable.put((Expression)seq, seqPDF);
        }
        catch (FunctionsInDifferenDomainsException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IncompatibleUnitsException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Hashtable<Expression, IProbabilityDensityFunction> getPdfTable() {
        return this.pdfTable;
    }

    public void setPdfTable(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }

    protected PerformanceSequenceHandler() {
    }
}

