/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LineMessageHandler
implements Runnable {
    private BufferedReader in;
    private boolean read = true;
    private boolean running = false;
    private boolean connected = false;
    private Map<String, String> evaluations = new HashMap<String, String>();
    private static final Logger logger = Logger.getLogger(LineMessageHandler.class);
    private static final String SOLVED = "SOLVED";
    private static final String READY = "LINE READY";
    private static final String LISTENING = "Listening on port";
    private static final String STOP = "LINE STOP";
    private static final String ERROR = "ERROR";
    private static final String MODEL = "MODEL";
    private static final String SUBMITTED = "SUBMITTED";
    String prefix = "";

    public LineMessageHandler(BufferedReader in, String prefix) {
        this.in = in;
        if (prefix != null) {
            this.prefix = prefix;
        }
    }

    public synchronized void close() {
        this.read = false;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean isModelEvaluated(String modelPath) {
        return this.evaluations.containsKey(modelPath = Paths.get(modelPath, new String[0]).toString()) && this.evaluations.get(modelPath).equals(SOLVED);
    }

    private synchronized boolean isRead() {
        return this.read;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (this.isRead()) {
            try {
                if (!this.in.ready()) {
                    Thread.sleep(100L);
                }
                if (!this.in.ready()) continue;
                String line = this.in.readLine();
                logger.info((Object)("LINE " + this.prefix + ": " + line));
                if (line.contains(LISTENING)) {
                    this.setRunning(true);
                }
                if (line.contains(READY)) {
                    this.setConnected(true);
                }
                if (line.contains(STOP)) {
                    this.setRunning(false);
                }
                if (line.contains(ERROR)) {
                    this.manageError(line);
                    continue;
                }
                if (!line.contains(MODEL)) continue;
                this.updateModelEvaluation(line);
            }
            catch (IOException e) {
                if (e.getMessage().equals("Stream closed")) {
                    logger.debug((Object)("LINE " + this.prefix + ": " + e.getMessage()));
                    continue;
                }
                logger.error((Object)"Error in reading from LINE output", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error in reading from LINE output", (Throwable)e);
            }
        }
    }

    private void manageError(String line) {
        logger.error((Object)("LINE error:" + line));
    }

    private synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    private synchronized void setRunning(boolean running) {
        this.running = running;
    }

    private synchronized void updateModelEvaluation(String message) {
        message = message.trim().replaceAll(" ", " ");
        String[] tokens = message.split(" ");
        int offset = 0;
        String modelName = tokens[1];
        while (modelName.indexOf("lqxo") == -1) {
            modelName = " " + tokens[2 + offset];
            ++offset;
        }
        modelName = modelName.replace("_line.lqxo", ".lqxo");
        modelName = Paths.get(modelName, new String[0]).toString();
        String status = null;
        status = tokens.length == 4 + offset ? tokens[3 + offset] : tokens[2 + offset];
        this.evaluations.put(modelName, status);
    }

    public synchronized void reset(String modelFilePath) {
        this.evaluations.remove(modelFilePath);
    }

    public void clear() {
        this.evaluations.clear();
    }
}

