/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.visualisation;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.palladiosimulator.solver.visualisation.LQNResultEditorInput;

public class LQNResultEditor
extends EditorPart {
    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        IEditorInput input = this.getEditorInput();
        Browser browser = new Browser(parent, 2048);
        browser.setJavascriptEnabled(true);
        if (input != null) {
            if (input instanceof LQNResultEditorInput) {
                browser.setText(((LQNResultEditorInput)input).getHtmlCode());
            } else {
                String fileContent = this.getFileContent(input);
                if (fileContent.trim().startsWith("<html>")) {
                    browser.setText(fileContent);
                } else {
                    browser.setText("<html><head><title>Markov Results</title></head><body><font color=\"red\">Error: The given editor input could not be handled.</font></body></html>");
                }
            }
        }
    }

    private String getFileContent(IEditorInput input) {
        StringBuilder fileContent = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            try {
                FileReader fileReader = new FileReader(fileEditorInput.getPath().toOSString());
                BufferedReader in = new BufferedReader(fileReader);
                String line = null;
                fileContent = new StringBuilder();
                String newLine = System.getProperty("line.separator");
                try {
                    while ((line = in.readLine()) != null) {
                        fileContent.append(line);
                        fileContent.append(newLine);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    public void setFocus() {
    }
}

