/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.palladiosimulator.solver.handler.LineMessageHandler;

public class LineServerHandler {
    private String host = null;
    private int port = -1;
    private Socket lineSocket = null;
    private PrintWriter out = null;
    private BufferedReader processIn = null;
    private BufferedReader socketIn = null;
    private LineMessageHandler processMessages;
    private LineMessageHandler socketMessages;
    private boolean localInstance = false;
    private Process proc;
    private File directory = null;
    private String MCR_dir = null;
    private String propertyFile = null;
    private static final Logger logger = Logger.getLogger(LineServerHandler.class);
    private static final String LINE_UNIX = "run_LINE.sh";
    private static final String LINE_WINDOWS = "LINE";

    public LineServerHandler(String properyFile) {
        this.propertyFile = properyFile;
    }

    public void closeConnections() {
        if (this.out != null && this.lineSocket != null && !this.lineSocket.isClosed()) {
            String command = "CLOSE";
            this.out.println(command);
            this.out.flush();
        }
        if (this.out != null) {
            this.out.close();
        }
        try {
            if (this.socketMessages != null && this.socketIn != null) {
                this.socketMessages.close();
                this.socketIn.close();
                this.socketIn = null;
                this.socketMessages = null;
            }
            if (this.lineSocket != null) {
                this.lineSocket.close();
                this.socketMessages = null;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error in closing LINE connection");
        }
    }

    private void loadProperties() {
        Properties lineProperties = new Properties();
        try {
            FileInputStream propInput = new FileInputStream(this.propertyFile);
            lineProperties.load(propInput);
            propInput.close();
            if (this.host == null) {
                this.host = lineProperties.getProperty("host", "localhost");
            }
            if (this.port == -1) {
                this.port = Integer.parseInt(lineProperties.getProperty("port", "5463"));
            }
            this.directory = new File(lineProperties.getProperty("directory", null));
            this.MCR_dir = lineProperties.getProperty("MCR_dir", "/usr/local/MATLAB/MATLAB_Compiler_Runtime/v81");
        }
        catch (IOException e) {
            logger.error((Object)"Could not load LINE connection properties", (Throwable)e);
        }
    }

    public void connectToLINEServer() {
        this.loadProperties();
        try {
            logger.info((Object)"connecting to LINE");
            this.initLINEConnection();
        }
        catch (UnknownHostException e) {
            if (this.host != "localhost") {
                this.closeConnections();
                logger.info((Object)("Don't know about host:" + this.host + ". Switching to localhost and trying reconnection."));
                this.host = "localhost";
                this.connectToLINEServer();
            } else {
                logger.error((Object)"Error while connecting to localhost", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.closeConnections();
            logger.info((Object)("Could not connect to LINE on host: " + this.host + " on port: " + this.port + " trying to launch line locally and connect to localhost. This might take a while.."));
            this.host = "localhost";
            this.launchLine();
            try {
                this.initLINEConnection();
            }
            catch (IOException e1) {
                this.closeConnections();
                logger.error((Object)"Could not connect to local instance of LINE", (Throwable)e1);
            }
        }
    }

    private void reConnect() {
        try {
            this.initLINEConnection();
        }
        catch (IOException e) {
            logger.error((Object)"Error in re-connecting to LINE", (Throwable)e);
        }
    }

    private void initLINEConnection() throws IOException {
        this.lineSocket = new Socket(this.host, this.port);
        this.out = new PrintWriter(this.lineSocket.getOutputStream());
        if (this.socketIn == null) {
            this.socketIn = new BufferedReader(new InputStreamReader(this.lineSocket.getInputStream()));
        }
        if (this.socketMessages == null) {
            this.socketMessages = new LineMessageHandler(this.socketIn, "socket");
            new Thread(this.socketMessages).start();
        }
        while (!this.socketMessages.isConnected()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error while waiting for LINE connection", (Throwable)e);
            }
        }
        logger.info((Object)("Connected to LINE on " + this.host + ":" + this.port));
    }

    public boolean isSolved(String modelFile) {
        return this.socketMessages.isModelEvaluated(modelFile);
    }

    public boolean launchLine() {
        try {
            String lineInvocation = " \"" + this.propertyFile.replace('\\', '/') + "\"";
            lineInvocation = System.getProperty("os.name").indexOf("Windows") > -1 ? LINE_WINDOWS + lineInvocation : "run_LINE.sh " + this.MCR_dir + " " + this.propertyFile.replace('\\', '/');
            logger.debug((Object)lineInvocation);
            ProcessBuilder pb = new ProcessBuilder(lineInvocation.split("\\s"));
            pb.directory(this.directory);
            pb.redirectErrorStream(true);
            this.proc = pb.start();
            this.processIn = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            this.processMessages = new LineMessageHandler(this.processIn, "process");
            new Thread(this.processMessages).start();
            while (!this.processMessages.isRunning()) {
                Thread.sleep(100L);
            }
            this.localInstance = true;
            logger.info((Object)"Local instance of LINE launched");
            return true;
        }
        catch (IOException e) {
            logger.error((Object)"Error in launching LINE", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error in launching LINE", (Throwable)e);
            return false;
        }
    }

    public void solve(String modelFilePath, String REfilePath) {
        if (this.out == null || this.out.checkError()) {
            logger.info((Object)"Connection with LINE server has encoutner a problem, trying to reconnect...");
            this.reConnect();
        }
        String command = "SOLVE " + modelFilePath;
        if (REfilePath != null) {
            command = " " + REfilePath;
        }
        logger.debug((Object)("Sending: " + command));
        this.socketMessages.reset(modelFilePath);
        this.out.println(command);
        this.out.flush();
    }

    public void terminateLine() {
        if (this.localInstance) {
            this.out.println("QUIT");
            this.out.flush();
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error in Quitting LINE", (Throwable)e);
            }
            if (this.processMessages != null && this.processIn != null) {
                this.processMessages.close();
                try {
                    this.processIn.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error in closing the process reader of LINE", (Throwable)e);
                }
            }
        }
        this.closeConnections();
    }

    public void clear() {
        this.socketMessages.clear();
    }
}

