/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.exprsolver;

import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.spa.expression.Alternative;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.Loop;
import org.palladiosimulator.solver.spa.expression.Sequence;
import org.palladiosimulator.solver.spa.expression.Symbol;
import org.palladiosimulator.solver.spa.expression.util.ExpressionSwitch;
import org.palladiosimulator.solver.spa.resourcemodel.ResourceUsage;

public class ExpressionSolver {
    private static Logger logger = Logger.getLogger((String)ExpressionSolver.class.getName());
    private IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private ExpressionSwitch exprSwitch = new ExpressionSwitch(){

        public Object caseAlternative(Alternative object) {
            logger.debug((Object)"Visit Alternative");
            ManagedPDF leftManagedPDF = (ManagedPDF)this.doSwitch((EObject)object.getLeftOption().getRegexp());
            ManagedPDF rightManagedPDF = (ManagedPDF)this.doSwitch((EObject)object.getRightOption().getRegexp());
            if (leftManagedPDF == null && rightManagedPDF != null) {
                return rightManagedPDF;
            }
            if (leftManagedPDF != null && rightManagedPDF == null) {
                return leftManagedPDF;
            }
            if (leftManagedPDF == null && rightManagedPDF == null) {
                return null;
            }
            IProbabilityDensityFunction leftPDF = leftManagedPDF.getPdfFrequencyDomain();
            IProbabilityDensityFunction rightPDF = rightManagedPDF.getPdfFrequencyDomain();
            double leftProb = object.getLeftOption().getProbability();
            double rightProb = object.getRightOption().getProbability();
            IProbabilityDensityFunction resultPDF = null;
            try {
                resultPDF = leftPDF.scale(leftProb).add(rightPDF.scale(rightProb));
            }
            catch (FunctionsInDifferenDomainsException e) {
                e.printStackTrace();
            }
            catch (UnknownPDFTypeException e) {
                e.printStackTrace();
            }
            catch (IncompatibleUnitsException e) {
                e.printStackTrace();
            }
            return new ManagedPDF(resultPDF, true);
        }

        public Object caseLoop(Loop object) {
            logger.debug((Object)"Visit Loop");
            ManagedPDF innerManagedPDF = (ManagedPDF)this.doSwitch((EObject)object.getRegExp());
            if (innerManagedPDF == null) {
                return null;
            }
            IProbabilityMassFunction iterations = this.getIterPMF(object);
            this.reconfigureForLoopBody(innerManagedPDF, iterations);
            ISamplePDF innerPDF = innerManagedPDF.getSamplePdfFrequencyDomain();
            ISamplePDF resultPDF = null;
            ISamplePDF tempPDF = null;
            try {
                resultPDF = ManagedPDF.createZeroFunction().getSamplePdfFrequencyDomain();
                tempPDF = ManagedPDF.createDiracImpulse().getSamplePdfFrequencyDomain();
            }
            catch (ConfigurationNotSetException e) {
                e.printStackTrace();
            }
            int pos = 0;
            List samples = iterations.getSamples();
            try {
                for (ISample sample : samples) {
                    Integer nextPos = (Integer)sample.getValue();
                    while (pos < nextPos) {
                        tempPDF = (ISamplePDF)tempPDF.mult((IProbabilityDensityFunction)innerPDF);
                        ++pos;
                    }
                    resultPDF = (ISamplePDF)resultPDF.add(tempPDF.scale(sample.getProbability()));
                }
            }
            catch (FunctionsInDifferenDomainsException e) {
                e.printStackTrace();
            }
            catch (UnknownPDFTypeException e) {
                e.printStackTrace();
            }
            catch (IncompatibleUnitsException e) {
                e.printStackTrace();
            }
            return new ManagedPDF((IProbabilityDensityFunction)resultPDF, true);
        }

        private void reconfigureForLoopBody(ManagedPDF innerManagedPDF, IProbabilityMassFunction iterations) {
            int maxDomainSize = (int)((double)this.getMaxIterations(iterations) * this.getLargestSamplingValue(innerManagedPDF));
            try {
                PDFConfiguration config = PDFConfiguration.getCurrentConfiguration();
                int currentDomainSize = config.getNumSamplingPoints();
                if (currentDomainSize < maxDomainSize) {
                    double distance = config.getDistance();
                    IUnit unit = config.getUnit();
                    logger.debug((Object)("Adjusting MaxDomainSize from " + currentDomainSize + " to " + maxDomainSize));
                    PDFConfiguration.setCurrentConfiguration((int)maxDomainSize, (double)distance, (IUnit)unit);
                }
            }
            catch (ConfigurationNotSetException e1) {
                e1.printStackTrace();
            }
        }

        private double getLargestSamplingValue(ManagedPDF innerManagedPDF) {
            ISamplePDF innerSamplePDF = innerManagedPDF.getSamplePdfTimeDomain();
            double largestValue = 0.0;
            List list = innerSamplePDF.getValues();
            int i = list.size() - 1;
            while (i >= 0) {
                Complex z = (Complex)list.get(i);
                double prob = (double)Math.round(z.getReal() * 10000.0) / 10000.0;
                if (prob > 0.0) {
                    largestValue = i;
                    break;
                }
                --i;
            }
            return largestValue;
        }

        private int getMaxIterations(IProbabilityMassFunction iterations) {
            List sampleList = iterations.getSamples();
            int maxIterations = 0;
            int i = sampleList.size() - 1;
            while (i >= 0) {
                ISample sample = (ISample)sampleList.get(i);
                if (sample.getProbability() != 0.0) {
                    maxIterations = (Integer)sample.getValue();
                    break;
                }
                --i;
            }
            return maxIterations;
        }

        private IProbabilityMassFunction getIterPMF(Loop object) {
            String iter = object.getIterationsString();
            try {
                int iterInt = Integer.parseInt(iter);
                ISample sample = ExpressionSolver.this.pfFactory.createSample((Object)iterInt, 1.0);
                ArrayList<ISample> sampleList = new ArrayList<ISample>();
                sampleList.add(sample);
                IUnit unit = ExpressionSolver.this.pfFactory.createDefaultUnit();
                return ExpressionSolver.this.pfFactory.createProbabilityMassFunction(sampleList, unit, true);
            }
            catch (NumberFormatException e) {
                ProbabilityFunctionLiteral loopLiteral = (ProbabilityFunctionLiteral)ExpressionHelper.parseToExpression((String)object.getIterationsString());
                ProbabilityMassFunction loopPMF = (ProbabilityMassFunction)loopLiteral.getFunction_ProbabilityFunctionLiteral();
                return ExpressionSolver.this.pfFactory.transformToPMF(loopPMF);
            }
        }

        public Object caseSequence(Sequence object) {
            logger.debug((Object)"Visit Sequence");
            ManagedPDF leftManagedPDF = (ManagedPDF)this.doSwitch((EObject)object.getLeftRegExp());
            ManagedPDF rightManagedPDF = (ManagedPDF)this.doSwitch((EObject)object.getRightRegExp());
            if (leftManagedPDF == null && rightManagedPDF != null) {
                return rightManagedPDF;
            }
            if (leftManagedPDF != null && rightManagedPDF == null) {
                return leftManagedPDF;
            }
            if (leftManagedPDF == null && rightManagedPDF == null) {
                return null;
            }
            IProbabilityDensityFunction leftPDF = leftManagedPDF.getPdfFrequencyDomain();
            IProbabilityDensityFunction rightPDF = rightManagedPDF.getPdfFrequencyDomain();
            IProbabilityDensityFunction resultPDF = null;
            try {
                resultPDF = leftPDF.mult(rightPDF);
            }
            catch (FunctionsInDifferenDomainsException e) {
                e.printStackTrace();
            }
            catch (UnknownPDFTypeException e) {
                e.printStackTrace();
            }
            catch (IncompatibleUnitsException e) {
                e.printStackTrace();
            }
            return new ManagedPDF(resultPDF, true);
        }

        public Object caseSymbol(Symbol object) {
            logger.debug((Object)("Visit Symbol: " + object.getName()));
            EList resourceUsageList = object.getResourceUsages();
            IProbabilityDensityFunction resultPDF = null;
            for (ResourceUsage resourceUsage : resourceUsageList) {
                ManagedPDF managedPDF = new ManagedPDF(resourceUsage.getUsageTime(), true);
                IProbabilityDensityFunction iPDF = managedPDF.getPdfFrequencyDomain();
                if (resultPDF == null) {
                    resultPDF = iPDF;
                    continue;
                }
                try {
                    resultPDF = resultPDF.mult(iPDF);
                }
                catch (FunctionsInDifferenDomainsException e) {
                    e.printStackTrace();
                }
                catch (UnknownPDFTypeException e) {
                    e.printStackTrace();
                }
                catch (IncompatibleUnitsException e) {
                    e.printStackTrace();
                }
            }
            if (resultPDF == null) {
                return null;
            }
            return new ManagedPDF(resultPDF, true);
        }
    };

    public ManagedPDF getResponseTime(Expression expr) {
        return (ManagedPDF)this.exprSwitch.doSwitch((EObject)expr);
    }
}

