/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2regex;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.EMFQueryHelper;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.ExpressionFactory;
import org.palladiosimulator.solver.spa.expression.Option;
import org.palladiosimulator.solver.spa.expression.Sequence;
import org.palladiosimulator.solver.spa.expression.Symbol;
import org.palladiosimulator.solver.transformations.pcm2regex.Pcm2RegexHelper;
import org.palladiosimulator.solver.transformations.pcm2regex.TransformSeffVisitor;

public class TransformUsageModelVisitor
extends UsagemodelSwitch {
    private static Logger logger = Logger.getLogger((String)TransformUsageModelVisitor.class.getName());
    private ExpressionFactory expFactory = ExpressionFactory.eINSTANCE;
    private IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private PCMInstance pcmInstance;
    private ContextWrapper myContextWrapper = null;

    public TransformUsageModelVisitor(PCMInstance pcm) {
        this.pcmInstance = pcm;
    }

    public Object caseStart(Start object) {
        Symbol sym = this.expFactory.createSymbol();
        sym.setName("Start");
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp((Expression)sym);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor()));
        return seq;
    }

    public Object caseStop(Stop object) {
        Symbol sym = this.expFactory.createSymbol();
        sym.setName("Stop");
        return sym;
    }

    public Object caseEntryLevelSystemCall(EntryLevelSystemCall object) {
        List contextWrapperList = this.myContextWrapper == null ? ContextWrapper.getContextWrapperFor((EntryLevelSystemCall)object, (PCMInstance)this.pcmInstance) : this.myContextWrapper.getContextWrapperFor(object);
        LinkedList<Option> optionsPerContextWrapperList = new LinkedList<Option>();
        Iterator iterator = contextWrapperList.iterator();
        while (iterator.hasNext()) {
            ContextWrapper contextWrapper;
            this.myContextWrapper = contextWrapper = (ContextWrapper)iterator.next();
            Option option = this.expFactory.createOption();
            option.setRegexp(this.getEntryExpression(object));
            option.setProbability((double)(1 / contextWrapperList.size()));
            optionsPerContextWrapperList.add(option);
        }
        Expression exp = null;
        exp = optionsPerContextWrapperList.size() == 1 ? ((Option)optionsPerContextWrapperList.get(0)).getRegexp() : Pcm2RegexHelper.createAlternativesForExpressions(optionsPerContextWrapperList);
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp(exp);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor()));
        return seq;
    }

    private Expression getEntryExpression(EntryLevelSystemCall object) {
        OperationProvidedRole role = object.getProvidedRole_EntryLevelSystemCall();
        ProvidedDelegationConnector delegationConnector = this.getDelegationConnector(role);
        RepositoryComponent offeringComponent = delegationConnector.getAssemblyContext_ProvidedDelegationConnector().getEncapsulatedComponent__AssemblyContext();
        Expression expr = null;
        ServiceEffectSpecification seff = this.myContextWrapper.getNextSEFF(object);
        TransformSeffVisitor seffVisitor = new TransformSeffVisitor(this.myContextWrapper);
        try {
            expr = (Expression)seffVisitor.doSwitch((EObject)((ResourceDemandingSEFF)seff));
        }
        catch (Exception e) {
            logger.error((Object)"Error while visiting RDSEFF");
            e.printStackTrace();
        }
        return expr;
    }

    public Object caseBranch(Branch object) {
        LinkedList<Option> optionsForBranches = new LinkedList<Option>();
        for (BranchTransition branch : object.getBranchTransitions_Branch()) {
            Option option = this.expFactory.createOption();
            option.setProbability(branch.getBranchProbability());
            Expression branchExpression = (Expression)this.doSwitch((EObject)branch.getBranchedBehaviour_BranchTransition());
            option.setRegexp(branchExpression);
            optionsForBranches.add(option);
        }
        Expression alt = Pcm2RegexHelper.createAlternativesForExpressions(optionsForBranches);
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp(alt);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor()));
        return seq;
    }

    public Object caseLoop(Loop object) {
        org.palladiosimulator.solver.spa.expression.Loop loop = this.expFactory.createLoop();
        PCMRandomVariable iterations = object.getLoopIteration_Loop();
        loop.setIterationsString(iterations.getSpecification());
        loop.setRegExp((Expression)this.doSwitch((EObject)object.getBodyBehaviour_Loop()));
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp((Expression)loop);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor()));
        return seq;
    }

    public Object caseScenarioBehaviour(ScenarioBehaviour object) {
        return this.doSwitch((EObject)this.getStartAction(object));
    }

    private Start getStartAction(ScenarioBehaviour object) {
        Start startAction = (Start)EMFQueryHelper.getObjectByType((EList)object.getActions_ScenarioBehaviour(), Start.class);
        return startAction;
    }

    private ProvidedDelegationConnector getDelegationConnector(OperationProvidedRole role) {
        ProvidedDelegationConnector delegationConnector = (ProvidedDelegationConnector)EMFQueryHelper.executeOCLQuery((EObject)this.pcmInstance.getSystem(), (String)("self.connectors__ComposedStructure->select(dc|dc.oclIsTypeOf(composition::ProvidedDelegationConnector) and dc.oclAsType(composition::ProvidedDelegationConnector).outerProvidedRole_ProvidedDelegationConnector.providedInterface__OperationProvidedRole.id = '" + role.getProvidedInterface__OperationProvidedRole().getId() + "')->asOrderedSet()->first()"));
        return delegationConnector;
    }

    private ServiceEffectSpecification getSeff(Signature method, BasicComponent basicComponent) {
        ServiceEffectSpecification seff = (ServiceEffectSpecification)EMFQueryHelper.executeOCLQuery((EObject)basicComponent, (String)("self.serviceEffectSpecifications__BasicComponent->select(seff|seff.describedService__SEFF.serviceName = '" + method.getEntityName() + "')->asOrderedSet()->first()"));
        return seff;
    }
}

