/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.visualisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.solver.lqn.ActivityDefType;
import org.palladiosimulator.solver.lqn.EntryType;
import org.palladiosimulator.solver.lqn.LqnModelType;
import org.palladiosimulator.solver.lqn.OutputResultType;
import org.palladiosimulator.solver.lqn.ProcessorType;
import org.palladiosimulator.solver.lqn.TaskType;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnXmlHandler;
import org.palladiosimulator.solver.visualisation.LQNResultEditorInput;

public class LQNHtmlResultGenerator {
    private LqnModelType lqnResultModel;
    private StringBuilder htmlText = new StringBuilder("");

    public LQNHtmlResultGenerator(String fileName) {
        LqnModelType loadedModel;
        this.lqnResultModel = loadedModel = LqnXmlHandler.loadModelFromXMI(fileName);
        if (this.lqnResultModel != null) {
            this.generateHtml();
        } else {
            this.generateErrorMsg(fileName);
        }
    }

    private void generateErrorMsg(String fileName) {
        this.appendHtmlHeader();
        this.htmlText.append("<h2>LQN Results</h2>");
        this.htmlText.append("Error retrieving results from: " + fileName + "<br>");
        this.htmlText.append("Check console output for error messages.");
        this.htmlText.append("</body></html>");
    }

    private String getInputStreamContents(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private void generateHtml() {
        this.appendHtmlHeader();
        this.htmlText.append("<h2>LQN Results</h2>");
        this.htmlText.append(this.lqnResultModel.getName());
        this.htmlText.append("<table border=\"0\" style=\"margin-top: 1mm; border: 1px solid black;\">");
        this.htmlText.append("<thead><tr>");
        this.htmlText.append("<th class=\"SortString\" onselectstart=\"return false;\">Processor</th>");
        this.htmlText.append("<th class=\"SortString\" onselectstart=\"return false;\">Utilization</th>");
        this.htmlText.append("<th class=\"SortString\" onselectstart=\"return false;\">Util / #Cores</th>");
        this.htmlText.append("</tr></thead><tbody>");
        DecimalFormat format = new DecimalFormat("0.000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        EList procList = this.lqnResultModel.getProcessor();
        for (ProcessorType pt : procList) {
            EList outputResults = pt.getResultProcessor();
            if (outputResults.size() <= 0) continue;
            OutputResultType singleResult = (OutputResultType)outputResults.get(0);
            this.htmlText.append("<tr>");
            String procName = pt.getName();
            this.htmlText.append("<td>" + procName + "</td>");
            double utilDouble = singleResult.getUtilization();
            this.htmlText.append("<td>" + format.format(utilDouble) + "</td>");
            String multiplicity = pt.getMultiplicity().toString();
            int multInt = Integer.parseInt(multiplicity);
            if (multInt != 0) {
                double utilPerCore = utilDouble / (double)multInt;
                this.htmlText.append("<td>" + format.format(utilPerCore) + "</td>");
            } else {
                this.htmlText.append("<td>n/a</td>");
            }
            this.htmlText.append("</tr>");
        }
        this.htmlText.append("</tbody></table>");
        this.htmlText.append("<br>");
        this.htmlText.append("<table border=\"0\" style=\"margin-top: 1mm; border: 1px solid black;\">");
        this.htmlText.append("<thead><tr>");
        this.htmlText.append("<th class=\"SortString\" onselectstart=\"return false;\">UsageScenario</th>");
        this.htmlText.append("<th class=\"SortString\" onselectstart=\"return false;\">ServiceTime*</th>");
        this.htmlText.append("<th class=\"SortString\" onselectstart=\"return false;\">Throughput</th>");
        this.htmlText.append("</tr></thead><tbody>");
        for (ProcessorType pt : procList) {
            String name = pt.getName();
            if (!name.contains("UsageScenario") || name.contains("Loop")) continue;
            this.htmlText.append("<tr>");
            TaskType tt = (TaskType)pt.getTask().get(0);
            String entryName = ((EntryType)tt.getEntry().get(0)).getName();
            this.htmlText.append("<td>" + entryName + "</td>");
            double serviceTime = this.getResponseTimeOfSubActivities(tt);
            this.htmlText.append("<td>" + format.format(serviceTime) + "</td>");
            double tpDouble = ((OutputResultType)tt.getResultTask().get(0)).getThroughput();
            this.htmlText.append("<td>" + format.format(tpDouble) + "</td>");
            this.htmlText.append("</tr>");
        }
        this.htmlText.append("</tbody></table>");
        this.htmlText.append("* Does not yet support Branches in UsageScenarios");
        this.htmlText.append("</body></html>");
    }

    private void appendHtmlHeader() {
        String cssCode = "";
        String jsCode = "";
        try {
            cssCode = this.getInputStreamContents(this.getClass().getResourceAsStream("/jsComponents.css"));
            jsCode = this.getInputStreamContents(this.getClass().getResourceAsStream("/jsComponents.js"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.htmlText = new StringBuilder("<html><head><title>LQN Results</title><script type=\"text/javascript\">" + jsCode + "</script>" + "<style type=\"text/css\">" + cssCode + "\t\tbody { font-family: Lucida Grande, Arial, Tahoma, Verdana; font-size: 12px; }" + "\t\ttd, th { font-size: 11px; }" + "\t\tth { background-color: c0c0c0; margin: 1px; padding: 3px 5px 3px 5px; border: 1px solid black; }" + "\t\ttd { background-color: dfdfdf; margin: 1px; padding: 3px 5px 3px 5px; }" + "</style>" + "</head><body>");
    }

    private double convertStringToDouble(String toConvert) {
        double ret = Double.NaN;
        toConvert = toConvert.replaceAll("e", "E");
        toConvert = toConvert.replaceAll("\\+", "");
        DecimalFormat format = new DecimalFormat("0.0E000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        try {
            ret = format.parse(toConvert).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private double getResponseTimeOfSubActivities(TaskType task) {
        double time = 0.0;
        EList activities = task.getTaskActivities().getActivity();
        for (ActivityDefType activity : activities) {
            EList results = activity.getResultActivity();
            for (OutputResultType outputResultType : results) {
                double serviceTime = outputResultType.getServiceTime();
                time += serviceTime;
            }
        }
        return time;
    }

    public void display() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        page.openEditor((IEditorInput)new LQNResultEditorInput(LQNHtmlResultGenerator.this.htmlText.toString()), "org.palladiosimulator.solver.LQNResultEditor");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

