/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver.operations;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import org.palladiosimulator.solver.spa.basicsolver.operations.BinaryOperation;

public class PDFPerformanceOps {
    public ManagedPDF computeIteration(ManagedPDF usage, IProbabilityMassFunction iterations) throws ProbabilityFunctionException, ConfigurationNotSetException {
        ISamplePDF innerPDF = usage.getSamplePdfFrequencyDomain();
        ISamplePDF resultPDF = ManagedPDF.createZeroFunction().getSamplePdfFrequencyDomain();
        ISamplePDF tempPDF = ManagedPDF.createDiracImpulse().getSamplePdfFrequencyDomain();
        int pos = 0;
        for (ISample sample : iterations.getSamples()) {
            Integer nextPos = (Integer)sample.getValue();
            while (pos < nextPos) {
                tempPDF = (ISamplePDF)tempPDF.mult((IProbabilityDensityFunction)innerPDF);
                ++pos;
            }
            resultPDF = (ISamplePDF)resultPDF.add(tempPDF.scale(sample.getProbability()));
        }
        return new ManagedPDF((IProbabilityDensityFunction)resultPDF, true);
    }

    public ManagedPDF computeAlternative(ManagedPDF leftRU, double leftProbability, ManagedPDF rightRU, double rightProbability) throws ProbabilityFunctionException {
        return this.performOperation(BinaryOperation.ALTERNATIVE, leftRU, leftProbability, rightRU, rightProbability);
    }

    public ManagedPDF computeSequence(ManagedPDF leftRU, ManagedPDF rightRU) throws ProbabilityFunctionException {
        return this.performOperation(BinaryOperation.SEQUENCE, leftRU, 0.0, rightRU, 0.0);
    }

    public ManagedPDF computeParallel(ManagedPDF leftRU, ManagedPDF rightRU) throws ProbabilityFunctionException {
        return this.performOperation(BinaryOperation.PARALLEL, leftRU, 0.0, rightRU, 0.0);
    }

    protected ManagedPDF performOperation(BinaryOperation op, ManagedPDF leftRU, double leftProbability, ManagedPDF rightRU, double rightProbability) throws ProbabilityFunctionException {
        IProbabilityDensityFunction resultPDF = null;
        IProbabilityDensityFunction leftPDF = leftRU.getPdfFrequencyDomain();
        IProbabilityDensityFunction rightPDF = rightRU.getPdfFrequencyDomain();
        switch (op) {
            case SEQUENCE: {
                resultPDF = leftPDF.mult(rightPDF);
                break;
            }
            case ALTERNATIVE: {
                resultPDF = leftPDF.scale(leftProbability).add(rightPDF.scale(rightProbability));
                break;
            }
            case PARALLEL: {
                resultPDF = leftPDF.mult(rightPDF);
                break;
            }
        }
        return new ManagedPDF(resultPDF, true);
    }
}

