/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.handler;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.solver.context.computed_usage.BranchProbability;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public abstract class AbstractBranchTransitionHandler {
    private static Logger logger = Logger.getLogger((String)AbstractBranchTransitionHandler.class.getName());
    protected ComputedUsageFactory usageFactory = ComputedUsageFactory.eINSTANCE;
    protected SeffVisitor visitor;

    public AbstractBranchTransitionHandler(SeffVisitor seffVisitor) {
        this.visitor = seffVisitor;
    }

    protected void visitChildBehaviour(AbstractBranchTransition bt) {
        ResourceDemandingBehaviour rdb = bt.getBranchBehaviour_BranchTransition();
        if (rdb != null) {
            this.visitor.doSwitch((EObject)rdb);
        }
    }

    protected void storeToUsageContext(AbstractBranchTransition bt, double solvedBranchProb) {
        BranchProbability prob = this.usageFactory.createBranchProbability();
        prob.setBranchtransition_BranchProbability(bt);
        prob.setProbability(solvedBranchProb);
        this.visitor.getContextWrapper().getCompUsgCtx().getBranchProbabilities_ComputedUsageContext().add((Object)prob);
    }
}

