/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.visitors;

import de.uka.ipd.sdq.probfunction.BoolSample;
import de.uka.ipd.sdq.probfunction.DoubleSample;
import de.uka.ipd.sdq.probfunction.IntSample;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.ProbfunctionFactory;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.StringSample;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.io.NotSerializableException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.stoex.api.StoExParser;
import org.palladiosimulator.pcm.stoex.api.StoExSerialiser;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.transformations.ExpressionToPDFWrapper;
import org.palladiosimulator.solver.core.visitors.ExpressionParameterSolverVisitor;

public class ExpressionHelper {
    private static final Logger LOGGER = Logger.getLogger((String)ExpressionHelper.class.getName());
    private static final StoExParser STOEX_PARSER = StoExParser.createInstance();
    private static final StoExSerialiser STOEX_SERIALISER = StoExSerialiser.createInstance();

    public static Expression parseToExpression(String specification) {
        Expression expression = null;
        try {
            expression = STOEX_PARSER.parse(specification);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return expression;
    }

    public static String getSolvedExpressionAsString(String specification, ContextWrapper ctxWrp) {
        Expression solvedExpression = ExpressionHelper.getSolvedExpression(specification, ctxWrp);
        try {
            Expression typedExpression = ExpressionHelper.transformExpressionToTypedExpression(solvedExpression);
            return STOEX_SERIALISER.serialise(typedExpression);
        }
        catch (NotSerializableException e) {
            throw new RuntimeException("Could not print solved expression " + specification, e);
        }
    }

    protected static Expression transformExpressionToTypedExpression(Expression expression) {
        Expression expressionCopy = (Expression)EcoreUtil.copy((EObject)expression);
        TreeIterator iter = expressionCopy.eAllContents();
        while (iter.hasNext()) {
            EObject currentEObject = (EObject)iter.next();
            if (!(currentEObject instanceof ProbabilityMassFunction)) continue;
            iter.prune();
            ProbabilityMassFunction pmf = (ProbabilityMassFunction)currentEObject;
            ExpressionHelper.transformPMFToTypedPMF((ProbabilityMassFunction<Object>)pmf);
        }
        return expressionCopy;
    }

    protected static void transformPMFToTypedPMF(ProbabilityMassFunction<Object> pmf) {
        EList genericSamples = pmf.getSamples();
        if (!ExpressionHelper.allSamplesHaveSameValueType((Collection<Sample<Object>>)genericSamples)) {
            return;
        }
        if (ExpressionHelper.allSamplesHaveBooleanStringLiterals((Collection<Sample<Object>>)genericSamples)) {
            genericSamples.stream().forEach(s -> s.setValue((Object)Boolean.parseBoolean((String)s.getValue())));
        }
        List typedSamples = genericSamples.stream().map(ExpressionHelper::transformToNonGenericModelSample).collect(Collectors.toList());
        pmf.getSamples().clear();
        pmf.getSamples().addAll(typedSamples);
    }

    protected static boolean allSamplesHaveBooleanStringLiterals(Collection<Sample<Object>> samples) {
        return samples.stream().map(Sample::getValue).collect(Collectors.toSet()).equals(Set.of("true", "false"));
    }

    protected static boolean allSamplesHaveSameValueType(Collection<Sample<Object>> samples) {
        return samples.stream().map(Sample::getValue).map(Object::getClass).collect(Collectors.toSet()).size() == 1;
    }

    protected static Sample<Object> transformToNonGenericModelSample(Sample<? extends Object> sample) {
        ProbfunctionFactory eFactory = ProbfunctionFactory.eINSTANCE;
        Object value = sample.getValue();
        if (value instanceof Integer) {
            IntSample newSample = eFactory.createIntSample();
            newSample.setProbability(sample.getProbability());
            newSample.setValue((Object)((Integer)value));
            return newSample;
        }
        if (value instanceof Double) {
            DoubleSample newSample = eFactory.createDoubleSample();
            newSample.setProbability(sample.getProbability());
            newSample.setValue((Object)((Double)value));
            return newSample;
        }
        if (value instanceof Boolean) {
            BoolSample newSample = eFactory.createBoolSample();
            newSample.setProbability(sample.getProbability());
            newSample.setValue((Object)((Boolean)value));
            return newSample;
        }
        if (value instanceof String) {
            StringSample newSample = eFactory.createStringSample();
            newSample.setProbability(sample.getProbability());
            newSample.setValue((Object)((String)value));
            return newSample;
        }
        throw new IllegalArgumentException("Value type contained in sample is not supported.");
    }

    public static Expression getSolvedExpression(String specification, ContextWrapper ctxWrp) {
        Expression expr = ExpressionHelper.parseToExpression(specification);
        return ExpressionHelper.getSolvedExpression(expr, ctxWrp);
    }

    public static Expression getSolvedExpression(Expression expr, ContextWrapper ctxWrp) {
        ExpressionInferTypeVisitor inferTypeVisitor = new ExpressionInferTypeVisitor();
        try {
            inferTypeVisitor.doSwitch((EObject)expr);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error((Object)("Infering the type failed with an " + e.getClass().getName() + ". I will try to ignore this and continue. Details:\n" + e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())));
            e.printStackTrace();
        }
        HashMap typeAnnotation = inferTypeVisitor.getTypeAnnotation();
        ExpressionParameterSolverVisitor solveVisitor = new ExpressionParameterSolverVisitor(typeAnnotation, ctxWrp);
        return (Expression)solveVisitor.doSwitch((EObject)expr);
    }

    public static HashMap<Expression, TypeEnum> getTypeAnnotation(Expression expr) {
        ExpressionInferTypeVisitor inferTypeVisitor = new ExpressionInferTypeVisitor();
        inferTypeVisitor.doSwitch((EObject)expr);
        return inferTypeVisitor.getTypeAnnotation();
    }

    public static double meanValue(Expression expression) throws IllegalArgumentException {
        ExpressionToPDFWrapper wrapper = ExpressionToPDFWrapper.createExpressionToPDFWrapper(expression);
        return wrapper.getMeanValue();
    }

    public static double getMeanValue(PCMRandomVariable variable) {
        ExpressionToPDFWrapper expToPDF = ExpressionToPDFWrapper.createExpressionToPDFWrapper(variable.getExpression());
        return expToPDF.getMeanValue();
    }
}

