/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import de.uka.ipd.sdq.featureinstance.FeatureConfigWidget;
import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.core.ConstantsContainer;

public class FeatureOptionsTab
extends AbstractLaunchConfigurationTab {
    public static final String PLUGIN_ID = "de.uka.ipd.sdq.codegen.simucontroller";
    private static final String FEATURE_OPTIONS_TAB_IMAGE_PATH = "icons/feature_tab.gif";
    private static final String TITLE_FEATURE_CONFIG_SECTION = "PCM2EJB Feature Configuration File";
    private static final String LABEL_SIMULATE_NETWORK = "Simulate full middleware marshalling / demarshalling of remote calls.";
    private static final String LABEL_SIMULATE_THROUGHPUT_OF_LINKING_RESOURCE = "Simulate throughput of remote calls.";
    private static final String LABEL_SIMULATE_NO_THROUGHPUT_OF_LINKING_RESOURCE = "Do not simulate throughput of remote calls.";
    private static final String[] COMBO_SIMULATE_ITEMS = new String[]{"Simulate full middleware marshalling / demarshalling of remote calls.", "Simulate throughput of remote calls.", "Do not simulate throughput of remote calls."};
    private static final String SIMULATE_NETWORK_EXPLANATION = "Latency is always simulated if linking resources connect containers. The linking resource is treated as a FCFS resource.";
    private static final Boolean DEFAULT_SIMULATE_FAILURES = false;
    private static final Boolean DEFAULT_SIMULATE_LINKING_RESOURCES = false;
    private static final Boolean DEFAULT_SIMULATE_THROUGHPUT_OF_LINKING_RESOURCES = true;
    private static final String DEFAULT_FEATURE_CONFIGURATION_FILE_LABEL = "Feature Configuration File";
    private Combo simulateLinkingResourceCombo;
    private Button simulateFailuresButton;
    private Text textFeatureConfig;
    private Text textTargetConfig;
    private FeatureConfigWidget editorWidget;
    private String sourceFile;
    private String targetFile;
    private Button modelSaveButton;
    private boolean editorValid = true;

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource().equals(FeatureOptionsTab.this.textFeatureConfig)) {
                    if (FeatureOptionsTab.this.sourceFile == null || !FeatureOptionsTab.this.sourceFile.equals(FeatureOptionsTab.this.textFeatureConfig.getText())) {
                        FeatureOptionsTab.this.sourceFile = FeatureOptionsTab.this.textFeatureConfig.getText();
                        if (FeatureOptionsTab.this.sourceFile != null && FeatureOptionsTab.this.targetFile != null) {
                            FeatureOptionsTab.this.editorWidget.setSourceInput(FeatureOptionsTab.this.sourceFile);
                            FeatureOptionsTab.this.editorWidget.setTargetInput(FeatureOptionsTab.this.targetFile);
                            FeatureOptionsTab.this.editorValid = FeatureOptionsTab.this.editorWidget.createPages();
                        }
                    }
                } else if (e.getSource().equals(FeatureOptionsTab.this.textTargetConfig) && (FeatureOptionsTab.this.targetFile == null || !FeatureOptionsTab.this.targetFile.equals(FeatureOptionsTab.this.textTargetConfig.getText()))) {
                    FeatureOptionsTab.this.targetFile = FeatureOptionsTab.this.textTargetConfig.getText();
                    if (FeatureOptionsTab.this.sourceFile != null && FeatureOptionsTab.this.targetFile != null) {
                        FeatureOptionsTab.this.editorWidget.setSourceInput(FeatureOptionsTab.this.sourceFile);
                        FeatureOptionsTab.this.editorWidget.setTargetInput(FeatureOptionsTab.this.targetFile);
                        FeatureOptionsTab.this.editorValid = FeatureOptionsTab.this.editorWidget.createPages();
                    }
                }
                FeatureOptionsTab.this.setDirty(true);
                FeatureOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FeatureOptionsTab.this.setDirty(true);
                FeatureOptionsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.setDirty(true);
                FeatureOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (FeatureOptionsTab.this.modelSaveButton != null) {
                    FeatureOptionsTab.this.modelSaveButton.setEnabled(true);
                }
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group networkingGroup = new Group(container, 0);
        networkingGroup.setText("Networking");
        GridData gd_networkingGroup = new GridData(4, 0x1000000, true, false);
        networkingGroup.setLayoutData((Object)gd_networkingGroup);
        networkingGroup.setLayout((Layout)new GridLayout());
        this.simulateLinkingResourceCombo = new Combo((Composite)networkingGroup, 8);
        GridData gd_simulateLinkingResourcesButton = new GridData(4, 0x1000000, true, false);
        this.simulateLinkingResourceCombo.setLayoutData((Object)gd_simulateLinkingResourcesButton);
        this.simulateLinkingResourceCombo.setItems(COMBO_SIMULATE_ITEMS);
        this.simulateLinkingResourceCombo.addSelectionListener(selectionListener);
        Label simulateLinkingResourceLabel = new Label((Composite)networkingGroup, 0);
        simulateLinkingResourceLabel.setText(SIMULATE_NETWORK_EXPLANATION);
        simulateLinkingResourceLabel.setEnabled(true);
        Group reliabilityGroup = new Group(container, 0);
        reliabilityGroup.setText("Reliability");
        GridData gd_reliabilityGroup = new GridData(4, 0x1000000, true, false);
        reliabilityGroup.setLayoutData((Object)gd_reliabilityGroup);
        reliabilityGroup.setLayout((Layout)new GridLayout());
        this.simulateFailuresButton = new Button((Composite)reliabilityGroup, 32);
        GridData gd_simulateFailuresButton = new GridData(4, 0x1000000, true, false);
        this.simulateFailuresButton.setLayoutData((Object)gd_simulateFailuresButton);
        this.simulateFailuresButton.setText("Simulate failures");
        this.simulateFailuresButton.addSelectionListener(selectionListener);
        Group featureConfigGroup = new Group(container, 0);
        GridLayout glReposetoryTypeGroup = new GridLayout();
        glReposetoryTypeGroup.numColumns = 3;
        featureConfigGroup.setLayout((Layout)glReposetoryTypeGroup);
        featureConfigGroup.setText(TITLE_FEATURE_CONFIG_SECTION);
        featureConfigGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textFeatureConfig = new Text((Composite)featureConfigGroup, 2052);
        GridData gd_textResourceTypeRepository = new GridData(4, 0x1000000, true, false);
        gd_textResourceTypeRepository.widthHint = 200;
        this.textFeatureConfig.setLayoutData((Object)gd_textResourceTypeRepository);
        this.textFeatureConfig.addModifyListener(modifyListener);
        TabHelper.createFileInputSection((Composite)featureConfigGroup, (ModifyListener)modifyListener, (String)DEFAULT_FEATURE_CONFIGURATION_FILE_LABEL, (String[])ConstantsContainer.FEATURECONFIG_EXTENSION, (Text)this.textFeatureConfig, (Shell)this.getShell(), (String)"pathmap://PCM_MODELS/ConnectorConfig.featureconfig");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!TabHelper.validateFilenameExtension((String)this.textFeatureConfig.getText(), (String[])ConstantsContainer.FEATURECONFIG_EXTENSION)) {
            this.setErrorMessage("Source model file is missing!");
            return false;
        }
        return true;
    }

    public String getName() {
        return "Feature Settings";
    }

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)FEATURE_OPTIONS_TAB_IMAGE_PATH);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String selectedItem = LABEL_SIMULATE_NO_THROUGHPUT_OF_LINKING_RESOURCE;
            Boolean simulateLinkingResourceChoice = configuration.getAttribute("simulateLinkingResources", DEFAULT_SIMULATE_LINKING_RESOURCES.booleanValue());
            if (simulateLinkingResourceChoice.booleanValue()) {
                selectedItem = LABEL_SIMULATE_NETWORK;
            } else {
                Boolean simulateThroughputOfLinkingResource = configuration.getAttribute("simulateThroughputOfLinkingResources", DEFAULT_SIMULATE_THROUGHPUT_OF_LINKING_RESOURCES.booleanValue());
                if (simulateThroughputOfLinkingResource.booleanValue()) {
                    selectedItem = LABEL_SIMULATE_THROUGHPUT_OF_LINKING_RESOURCE;
                }
            }
            String[] items = this.simulateLinkingResourceCombo.getItems();
            int i = 0;
            while (i < items.length) {
                String str = items[i];
                if (str.equals(selectedItem)) {
                    this.simulateLinkingResourceCombo.select(i);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            this.simulateLinkingResourceCombo.select(1);
        }
        try {
            this.simulateFailuresButton.setSelection(configuration.getAttribute("simulateFailures", true));
        }
        catch (CoreException coreException) {
            this.simulateFailuresButton.setSelection(false);
        }
        try {
            this.textFeatureConfig.setText(configuration.getAttribute("featureConfig", "pathmap://PCM_MODELS/ConnectorConfig.featureconfig"));
        }
        catch (CoreException coreException) {
            this.textFeatureConfig.setText("pathmap://PCM_MODELS/ConnectorConfig.featureconfig");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (LABEL_SIMULATE_NO_THROUGHPUT_OF_LINKING_RESOURCE.equals(this.simulateLinkingResourceCombo.getText())) {
            configuration.setAttribute("simulateLinkingResources", false);
            configuration.setAttribute("simulateThroughputOfLinkingResources", false);
        } else if (LABEL_SIMULATE_THROUGHPUT_OF_LINKING_RESOURCE.equals(this.simulateLinkingResourceCombo.getText())) {
            configuration.setAttribute("simulateLinkingResources", false);
            configuration.setAttribute("simulateThroughputOfLinkingResources", true);
        } else if (LABEL_SIMULATE_NETWORK.equals(this.simulateLinkingResourceCombo.getText())) {
            configuration.setAttribute("simulateLinkingResources", true);
            configuration.setAttribute("simulateThroughputOfLinkingResources", true);
        }
        configuration.setAttribute("simulateFailures", this.simulateFailuresButton.getSelection());
        configuration.setAttribute("featureConfig", this.textFeatureConfig.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("simulateLinkingResources", (Object)DEFAULT_SIMULATE_LINKING_RESOURCES);
        configuration.setAttribute("simulateThroughputOfLinkingResources", (Object)DEFAULT_SIMULATE_THROUGHPUT_OF_LINKING_RESOURCES);
        configuration.setAttribute("simulateFailures", (Object)DEFAULT_SIMULATE_FAILURES);
        configuration.setAttribute("featureConfig", "pathmap://PCM_MODELS/ConnectorConfig.featureconfig");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public String getId() {
        return "de.uka.ipd.sdq.codegen.runconfig.tabs.FileNamesInputTab";
    }
}

