/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.ConfigurationTab;
import org.palladiosimulator.editors.commons.dialogs.selection.PalladioSelectEObjectDialog;

public class SimuConfigurationTab
extends ConfigurationTab {
    private Text variableText;
    private Text minimumText;
    private Text maximumText;
    private Text stepWidthText;
    private ArrayList<String> modelFiles = new ArrayList();

    protected void createFurtherSections(Composite container) {
        Group sensitivityAnalysisParametersGroup = new Group(container, 0);
        sensitivityAnalysisParametersGroup.setText("Sensitivity Analysis Parameters");
        GridData gd_sensitivityAnalysisParametersGroup = new GridData(4, 0x1000000, true, false);
        sensitivityAnalysisParametersGroup.setLayoutData((Object)gd_sensitivityAnalysisParametersGroup);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        sensitivityAnalysisParametersGroup.setLayout((Layout)gridLayout_1);
        Label variableToAdaptLabel = new Label((Composite)sensitivityAnalysisParametersGroup, 0);
        GridData gd_variableToAdaptLabel = new GridData(131072, 0x1000000, false, false);
        variableToAdaptLabel.setLayoutData((Object)gd_variableToAdaptLabel);
        variableToAdaptLabel.setText("Variable:");
        this.variableText = new Text((Composite)sensitivityAnalysisParametersGroup, 2048);
        this.variableText.setEnabled(true);
        this.variableText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableText.addModifyListener(this.modifyListener);
        Button selectVariableButton = new Button((Composite)sensitivityAnalysisParametersGroup, 0);
        selectVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimuConfigurationTab.this.selectVariable();
            }
        });
        selectVariableButton.setText("Select Variable...");
        Composite composite = new Composite((Composite)sensitivityAnalysisParametersGroup, 0);
        GridData gd_composite = new GridData(4, 0x1000000, false, false, 3, 1);
        composite.setLayoutData((Object)gd_composite);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 6;
        composite.setLayout((Layout)gridLayout_2);
        Label minimumLabel = new Label(composite, 0);
        minimumLabel.setText("Minimum:");
        this.minimumText = new Text(composite, 2048);
        this.minimumText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumText.addModifyListener(this.modifyListener);
        Label maximumLabel = new Label(composite, 0);
        maximumLabel.setText("Maximum:");
        this.maximumText = new Text(composite, 2048);
        this.maximumText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maximumText.addModifyListener(this.modifyListener);
        Label stepWidthLabel = new Label(composite, 0);
        stepWidthLabel.setText("Step Width:");
        this.stepWidthText = new Text(composite, 2048);
        this.stepWidthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stepWidthText.addModifyListener(this.modifyListener);
    }

    protected void selectVariable() {
        ResourceSetImpl rs = new ResourceSetImpl();
        ArrayList<Class<EObject>> filter = new ArrayList<Class<EObject>>();
        filter.add(EObject.class);
        for (String file : this.modelFiles) {
            try {
                rs.getResource(URI.createURI((String)file), true);
            }
            catch (Exception exception) {
                rs.getResource(URI.createFileURI((String)file), true);
            }
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(this.getShell(), filter, (Object)rs);
        if (dialog.open() == 0) {
            this.variableText.setText(EcoreUtil.getURI((EObject)dialog.getResult()).toString());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.clearButton.setSelection(configuration.getAttribute("clear", true));
        }
        catch (CoreException coreException) {
            this.clearButton.setSelection(true);
        }
        try {
            this.variableText.setText(configuration.getAttribute("variable", ""));
        }
        catch (CoreException coreException) {
            this.variableText.setText("");
        }
        try {
            this.minimumText.setText(configuration.getAttribute("minimum", ""));
        }
        catch (CoreException coreException) {
            this.minimumText.setText("");
        }
        try {
            this.maximumText.setText(configuration.getAttribute("maximum", ""));
        }
        catch (CoreException coreException) {
            this.maximumText.setText("");
        }
        try {
            this.stepWidthText.setText(configuration.getAttribute("stepwidth", ""));
        }
        catch (CoreException coreException) {
            this.stepWidthText.setText("");
        }
        try {
            this.modelFiles.clear();
            this.modelFiles.add(configuration.getAttribute("repositoryFile", ""));
            this.modelFiles.add(configuration.getAttribute("systemFile", ""));
            this.modelFiles.add(configuration.getAttribute("allocationFile", ""));
            this.modelFiles.add(configuration.getAttribute("usageFile", ""));
        }
        catch (CoreException coreException) {
            this.stepWidthText.setText("");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("clear", this.clearButton.getSelection());
        configuration.setAttribute("variable", this.variableText.getText());
        configuration.setAttribute("minimum", this.minimumText.getText());
        configuration.setAttribute("maximum", this.maximumText.getText());
        configuration.setAttribute("stepwidth", this.stepWidthText.getText());
    }
}

