/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations.builder.seff;

import de.uka.ipd.sdq.pcm.transformations.builder.seff.AbstractActionDescriptor;
import org.palladiosimulator.analyzer.completions.CompletionsFactory;
import org.palladiosimulator.analyzer.completions.NetworkDemandParametricResourceDemand;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformanceFactory;

public abstract class AbstractInternalActionDescriptor
extends AbstractActionDescriptor {
    private ResourceType resourceType;

    public AbstractInternalActionDescriptor(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public abstract String getResourceDemand();

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public AbstractAction createAction() {
        ResourceType myResourceType = this.getResourceType();
        if (myResourceType instanceof ProcessingResourceType) {
            return this.createInternalAction((ProcessingResourceType)myResourceType, this.getResourceDemand());
        }
        if (myResourceType instanceof CommunicationLinkResourceType) {
            return this.createInternalAction((CommunicationLinkResourceType)myResourceType, this.getResourceDemand());
        }
        throw new RuntimeException("SimuCom Completion Builder does not support resource type " + myResourceType.getClass().getSimpleName());
    }

    private InternalAction createInternalAction(ProcessingResourceType type, String resourceDemandSpec) {
        InternalAction action = SeffFactory.eINSTANCE.createInternalAction();
        ParametricResourceDemand d = SeffPerformanceFactory.eINSTANCE.createParametricResourceDemand();
        d.setRequiredResource_ParametricResourceDemand(type);
        PCMRandomVariable specification = CoreFactory.eINSTANCE.createPCMRandomVariable();
        specification.setSpecification(this.getSaveResourceDemand(resourceDemandSpec));
        d.setSpecification_ParametericResourceDemand(specification);
        action.getResourceDemand_Action().add((Object)d);
        return action;
    }

    private InternalAction createInternalAction(CommunicationLinkResourceType type, String resourceDemandSpec) {
        InternalAction action = SeffFactory.eINSTANCE.createInternalAction();
        NetworkDemandParametricResourceDemand d = CompletionsFactory.eINSTANCE.createNetworkDemandParametricResourceDemand();
        d.setRequiredCommunicationLinkResource_ParametricResourceDemand(type);
        ProcessingResourceType cpuResourceType = this.getCpuResourceType(type.getResourceRepository_ResourceType());
        if (cpuResourceType == null) {
            throw new RuntimeException("No CPU resource is available for SimuCom Completion Builder!");
        }
        d.setRequiredResource_ParametricResourceDemand(cpuResourceType);
        PCMRandomVariable specification = CoreFactory.eINSTANCE.createPCMRandomVariable();
        specification.setSpecification(this.getSaveResourceDemand(resourceDemandSpec));
        d.setSpecification_ParametericResourceDemand(specification);
        action.getResourceDemand_Action().add((Object)d);
        return action;
    }

    private ProcessingResourceType getCpuResourceType(ResourceRepository resourceRepository) {
        for (ResourceType availableResourceType : resourceRepository.getAvailableResourceTypes_ResourceRepository()) {
            if (!availableResourceType.getEntityName().equals("CPU")) continue;
            return (ProcessingResourceType)availableResourceType;
        }
        return null;
    }

    private String getSaveResourceDemand(String resourceDemandSpec) {
        if (resourceDemandSpec == null) {
            return "0";
        }
        if (resourceDemandSpec.equals("")) {
            return "0";
        }
        return resourceDemandSpec;
    }
}

