/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.debug;

import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.DockModel;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockPerformedDebugStepEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockResumedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSimTimeChangedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSimulationTerminatedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockStartedDebugStepEvent;
import de.uka.ipd.sdq.codegen.simucontroller.core.dockmodel.events.DockSuspendedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.debug.SimulationDebugElement;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.notify.Notification;

public class SimulationDebugThread
extends SimulationDebugElement
implements IThread,
Observer {
    private DockModel myDock;
    private boolean isTerminated;

    public SimulationDebugThread(IDebugTarget myDebugTarget, ILaunch launch, DockModel dock) {
        super(myDebugTarget, launch);
        if (this.myDebugTarget == null) {
            throw new IllegalArgumentException("Debug target has to be set");
        }
        this.myDock = dock;
        this.myDock.addObserver((Observer)this);
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public String getName() throws DebugException {
        return "Simulation Event Processor - SimTime: " + this.myDock.getSimTime();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return new IStackFrame[0];
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return false;
    }

    public boolean canResume() {
        return true;
    }

    public boolean canSuspend() {
        return true;
    }

    public boolean isSuspended() {
        return this.myDock.isSuspended();
    }

    public void resume() throws DebugException {
        this.myDock.getService().resume();
    }

    public void suspend() throws DebugException {
        this.myDock.getService().suspend();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return this.myDebugTarget == null ? false : this.myDebugTarget.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.myDock.isStepping();
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
        this.myDock.getService().step();
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return true;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.myDock.getService().stopSimulation();
    }

    public void setSimControl(SimulationDockService service) {
    }

    @Override
    public void update(Observable o, Object arg) {
        DockEvent dockEvent;
        if (arg instanceof DockEvent && (dockEvent = (DockEvent)arg).comesFrom(this.myDock)) {
            if (dockEvent instanceof DockResumedEvent) {
                this.fireEvent(this, 1);
            }
            if (dockEvent instanceof DockSuspendedEvent) {
                this.fireEvent(this, 2);
            }
            if (dockEvent instanceof DockPerformedDebugStepEvent) {
                this.fireEvent(this, 8);
            }
            if (dockEvent instanceof DockStartedDebugStepEvent) {
                this.fireEvent(this, 2);
            }
            if (dockEvent instanceof DockSimTimeChangedEvent && this.getDebugTarget().isSuspended()) {
                this.fireEvent(this, 16);
            }
            if (dockEvent instanceof DockSimulationTerminatedEvent) {
                this.isTerminated = true;
                this.fireEvent(this, 8);
            }
        }
    }

    public void dispose() {
        this.myDock.deleteObserver((Observer)this);
        this.myDock = null;
        this.myDebugTarget = null;
    }

    @Override
    public void notifyChanged(Notification notification) {
    }
}

