/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.runconfig;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class SimulatorExtensionHelper {
    public static final String EXTENSION_POINT_ID = "de.uka.ipd.sdq.codegen.simucontroller.simulator";

    public static String[] getSimulatorNames() throws CoreException {
        ArrayList<String> names = new ArrayList<String>();
        for (IExtension extension : SimulatorExtensionHelper.loadSimulatorExtensions()) {
            IConfigurationElement e = SimulatorExtensionHelper.obtainConfigurationElement("simulator", extension);
            if (e == null) continue;
            names.add(e.getAttribute("name"));
        }
        return names.toArray(new String[names.size()]);
    }

    public static String getSimulatorNameForId(String simulatorId) throws CoreException {
        for (IExtension extension : SimulatorExtensionHelper.loadSimulatorExtensions()) {
            IConfigurationElement e = SimulatorExtensionHelper.obtainConfigurationElement("simulator", extension);
            if (e == null || !e.getAttribute("id").equals(simulatorId)) continue;
            return e.getAttribute("name");
        }
        return "";
    }

    public static String getSimulatorIdForName(String simulatorName) throws CoreException {
        for (IExtension extension : SimulatorExtensionHelper.loadSimulatorExtensions()) {
            IConfigurationElement e = SimulatorExtensionHelper.obtainConfigurationElement("simulator", extension);
            if (e == null || !e.getAttribute("name").equals(simulatorName)) continue;
            return e.getAttribute("id");
        }
        return "";
    }

    private static IConfigurationElement obtainConfigurationElement(String elementName, IExtension extension) throws CoreException {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(elementName)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static List<IExtension> loadSimulatorExtensions() {
        IExtension[] exts = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID).getExtensions();
        ArrayList<IExtension> results = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            results.add(extension);
            ++n2;
        }
        return results;
    }
}

