/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import edu.rice.cs.util.jar.JarBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;

public class BuildPluginJarJob
implements IJob {
    private byte[] result = null;
    private AbstractCodeGenerationWorkflowRunConfiguration configuration;

    public BuildPluginJarJob(AbstractCodeGenerationWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public byte[] getResult() {
        return this.result;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        URI location = null;
        try {
            location = CreatePluginProjectJob.getProject((String)this.configuration.getStoragePluginID()).getLocationURI();
            String jarLocation = String.valueOf(new File(location).getAbsolutePath()) + File.separator + "simucominstance.jar";
            JarBuilder builder = new JarBuilder(new File(jarLocation));
            this.addCompiledClasses(location, builder);
            this.addMetadataFiles(location, builder);
            this.addModelFiles(location, builder);
            builder.close();
            this.result = this.loadBundle(String.valueOf(new File(location).getAbsolutePath()) + File.separator + "simucominstance.jar");
        }
        catch (IOException e) {
            throw new JobFailedException("Compile Plugin failed. Error creating JAR archive.", (Throwable)e);
        }
    }

    private void addMetadataFiles(URI location, JarBuilder builder) {
        builder.addDirectoryRecursive(new File(location), "", new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toUpperCase().contains("META-INF") || pathname.getName().toUpperCase().contains("MANIFEST") || pathname.getName().contains("plugin.xml");
            }
        });
    }

    private void addModelFiles(URI location, JarBuilder builder) {
        builder.addDirectoryRecursive(new File(location).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("model");
            }
        })[0], "model");
    }

    private void addCompiledClasses(URI location, JarBuilder builder) {
        builder.addDirectoryRecursive(new File(location).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("bin");
            }
        })[0], "");
    }

    public String getName() {
        return "Building simulation plugin JAR archive";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    private byte[] loadBundle(String location) throws IOException {
        byte[] result = null;
        File bundleFile = new File(location);
        result = new byte[(int)bundleFile.length()];
        FileInputStream fis = new FileInputStream(bundleFile);
        fis.read(result);
        fis.close();
        return result;
    }
}

