/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.PieEntity;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public abstract class AbstractPie {
    protected ArrayList<PieEntity> entities = new ArrayList();
    private final String label;

    public AbstractPie(String string) {
        this.label = string;
    }

    public void addEntity(PieEntity e) {
        this.entities.add(e);
    }

    public Collection<PieEntity> getEntities(int maxCount) {
        Collections.sort(this.entities);
        if (this.entities.size() > maxCount && maxCount > 0) {
            return this.getAggregatedPie(maxCount);
        }
        return this.entities;
    }

    private Collection<PieEntity> getAggregatedPie(int maxCount) {
        ArrayList<PieEntity> newEntities = new ArrayList<PieEntity>();
        double sum = 0.0;
        int i = this.entities.size() - 1;
        while (i >= this.entities.size() - maxCount) {
            newEntities.add(this.entities.get(i));
            sum += this.entities.get(i).getValue();
            --i;
        }
        double remaining = 0.0;
        while (i >= 0) {
            remaining += this.entities.get(i).getValue();
            --i;
        }
        DecimalFormat df = new DecimalFormat("#0.0", new DecimalFormatSymbols(Locale.US));
        newEntities.add(new PieEntity(remaining, "Other (" + df.format(remaining * 100.0 / (sum += remaining)) + "%)"));
        Collections.sort(newEntities);
        return newEntities;
    }

    public String getLabel() {
        return this.label;
    }
}

