/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simucom;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.IStatisticAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.AssemblyContextContext;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.ResultdecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ActiveResourceUtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.PassiveResourceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ResourceenvironmentdecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.solver.core.models.PCMInstance;

public abstract class SimuComAnalysisResult
extends AbstractPerformanceAnalysisResult
implements IStatisticAnalysisResult,
IPerformanceAnalysisResult {
    protected double meanValue;
    protected double medianValue;
    protected double throughput;
    protected double maxUtilization;
    protected double stdDeviation;
    protected ConfidenceInterval confidenceInterval;
    protected double alpha = 0.95;
    protected long observations = 0L;
    protected String pcmEntityIdentifier;
    protected Map<Criterion, EvaluationAspectWithContext> objectiveToAspects;
    protected SimuComQualityAttributeDeclaration qualityAttributeInfo;
    protected static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");

    protected SimuComAnalysisResult(PCMInstance pcm) {
        super(pcm);
    }

    protected double calculateMaxUtil(String resourceType) {
        double maxUtil = 0.0;
        for (UtilisationResult utilResult : this.results.getUtilisationResults_ResultDecoratorRepository()) {
            if (!utilResult.getEntityName().contains(resourceType) || !(maxUtil < utilResult.getResourceUtilisation())) continue;
            maxUtil = utilResult.getResourceUtilisation();
        }
        return maxUtil;
    }

    protected ResultDecoratorRepository retrieveResults(PCMInstance pcmInstance) throws AnalysisFailedException {
        ResultDecoratorRepository repo = ResultdecoratorFactory.eINSTANCE.createResultDecoratorRepository();
        this.retrieveResourceUtilisation(pcmInstance, repo);
        this.retrieveServiceResults(pcmInstance, repo);
        this.retrievePassiveResourceUtil(repo, pcmInstance);
        return repo;
    }

    protected abstract void retrieveServiceResultsFinish(PCMInstance var1, ResultDecoratorRepository var2, HashMap<String, ExternalCallAction> var3, Map<String, AssemblyContextContext> var4, List<String> var5);

    private void retrieveServiceResults(PCMInstance pcmInstance, ResultDecoratorRepository repo) throws AnalysisFailedException {
        ExternalCallAction sampleExternalCall = SeffFactory.eINSTANCE.createExternalCallAction();
        org.palladiosimulator.solver.core.transformations.EMFHelper helper = new org.palladiosimulator.solver.core.transformations.EMFHelper();
        List respositories = pcmInstance.getRepositories();
        HashMap<String, ExternalCallAction> idToExternalCallMap = new HashMap<String, ExternalCallAction>(100);
        for (Repository repository : respositories) {
            EList allExternalCallsList = helper.getElements((EObject)repository, sampleExternalCall.eClass());
            for (EObject eObject : allExternalCallsList) {
                if (!(eObject instanceof ExternalCallAction)) continue;
                ExternalCallAction externalCall = (ExternalCallAction)eObject;
                String id = externalCall.getId();
                idToExternalCallMap.put(id, externalCall);
            }
        }
        AssemblyContext sampleAssemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
        EList eObjectAssemblyContexts = helper.getElements((EObject)pcmInstance.getSystem(), sampleAssemblyContext.eClass());
        for (Repository repository : respositories) {
            EList assemblyContextsInRepo = helper.getElements((EObject)repository, sampleAssemblyContext.eClass());
            eObjectAssemblyContexts.addAll((Collection)assemblyContextsInRepo);
        }
        HashMap<String, AssemblyContextContext> idToAssemblyContextMap = new HashMap<String, AssemblyContextContext>(eObjectAssemblyContexts.size());
        ArrayList<String> completionComponentIdsToIgnore = new ArrayList<String>();
        for (EObject eObjectAssemblyContext : eObjectAssemblyContexts) {
            if (!(eObjectAssemblyContext instanceof AssemblyContext)) continue;
            AssemblyContext assemblyContext = (AssemblyContext)eObjectAssemblyContext;
            idToAssemblyContextMap.put(assemblyContext.getId(), new AssemblyContextContext(assemblyContext));
        }
        HashMap<String, AssemblyContextContext> temporaryIdToAssemblyContextMap = new HashMap<String, AssemblyContextContext>(eObjectAssemblyContexts.size());
        for (AssemblyContextContext assemblyContextContext : idToAssemblyContextMap.values()) {
            RepositoryComponent component = assemblyContextContext.getAssemblyContext().getEncapsulatedComponent__AssemblyContext();
            if (component instanceof ComposedStructure && !(component instanceof Completion)) {
                EList innerAssemblyContexts = ((ComposedStructure)component).getAssemblyContexts__ComposedStructure();
                for (AssemblyContext assemblyContext : innerAssemblyContexts) {
                    String id = assemblyContext.getId();
                    AssemblyContextContext innerContext = (AssemblyContextContext)idToAssemblyContextMap.get(id);
                    innerContext.setParent(assemblyContextContext);
                    temporaryIdToAssemblyContextMap.put(innerContext.getComposedId(), innerContext);
                }
                continue;
            }
            if (!(component instanceof Completion)) continue;
            completionComponentIdsToIgnore.add(component.getEntityName());
        }
        idToAssemblyContextMap.putAll(temporaryIdToAssemblyContextMap);
        this.retrieveServiceResultsFinish(pcmInstance, repo, idToExternalCallMap, idToAssemblyContextMap, completionComponentIdsToIgnore);
    }

    private ResultDecoratorRepository retrieveResourceUtilisation(PCMInstance pcmInstance, ResultDecoratorRepository repo) throws AnalysisFailedException {
        EList resourceContainerList = pcmInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        for (ResourceContainer resourceContainer : resourceContainerList) {
            EList resources = resourceContainer.getActiveResourceSpecifications_ResourceContainer();
            for (ProcessingResourceSpecification resource : resources) {
                ProcessingResourceSpecificationResult result = ResourceenvironmentdecoratorFactory.eINSTANCE.createProcessingResourceSpecificationResult();
                this.getUtilisationOfResource((ActiveResourceUtilisationResult)result, (Entity)resourceContainer, (ResourceType)resource.getActiveResourceType_ActiveResourceSpecification());
                if (result == null || result.getResourceUtilisation() == Double.NaN) continue;
                result.setEntityName("Util of " + resourceContainer.getEntityName() + "_" + resource.getActiveResourceType_ActiveResourceSpecification().getEntityName());
                result.setProcessingResourceSpecification_ProcessingResourceSpecificationResult(resource);
                repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
            }
        }
        EList linkList = pcmInstance.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
        for (LinkingResource linkingResource : linkList) {
            CommunicationLinkResourceType type = linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification();
            LinkingResourceResults result = ResourceenvironmentdecoratorFactory.eINSTANCE.createLinkingResourceResults();
            result.setLinkingResource_LinkingResourceResults(linkingResource);
            this.getUtilisationOfResource((ActiveResourceUtilisationResult)result, (Entity)linkingResource, (ResourceType)type);
            if (result == null || result.getResourceUtilisation() == Double.NaN) continue;
            result.setEntityName("Util of " + linkingResource.getEntityName() + "_" + type);
            repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
        }
        return repo;
    }

    protected abstract Map<String, PassiveResourceResult> retrievePassiveResourceUtilFinish(Map<String, PassiveResourceResult> var1);

    private Map<String, PassiveResourceResult> retrievePassiveResourceUtil(ResultDecoratorRepository repo, PCMInstance pcm) throws AnalysisFailedException {
        HashMap<String, PassiveResourceResult> idsToPassiveResourceResult = new HashMap<String, PassiveResourceResult>();
        List allAssemblyContexts = EMFHelper.getAllUsedAssemblyContexts((ComposedProvidingRequiringEntity)pcm.getSystem());
        for (AssemblyContext assemblyContext : allAssemblyContexts) {
            RepositoryComponent innerComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
            if (!(innerComponent instanceof BasicComponent)) continue;
            BasicComponent basicComponent = (BasicComponent)innerComponent;
            EList passiveResourceOfComponentList = basicComponent.getPassiveResource_BasicComponent();
            for (PassiveResource passiveResource : passiveResourceOfComponentList) {
                String passiveResourceAndAssemblyContextId = String.valueOf(passiveResource.getId()) + ":" + assemblyContext.getId();
                PassiveResourceResult result = ResourceenvironmentdecoratorFactory.eINSTANCE.createPassiveResourceResult();
                result.setPassiveResource_PassiveResourceResult(passiveResource);
                result.setAssemblyContext_PassiveResourceResult(assemblyContext);
                result.setEntityName("Utilisation of " + passiveResource.getEntityName() + " id: " + passiveResourceAndAssemblyContextId);
                repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
                idsToPassiveResourceResult.put(passiveResourceAndAssemblyContextId, result);
            }
        }
        return this.retrievePassiveResourceUtilFinish(idsToPassiveResourceResult);
    }

    public double getValueFor(Criterion criterion) {
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getResponseTime())) {
            return this.meanValue;
        }
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getThroughput())) {
            return this.throughput;
        }
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getMaxUtilization())) {
            return this.maxUtilization;
        }
        logger.warn((Object)"Unknown aspect for simu com result, adding NaN.");
        return Double.NaN;
    }

    private Dimension getDimensionForCriterion(Criterion criterion) {
        EvaluationAspectWithContext aspect = this.objectiveToAspects.get(criterion);
        if (aspect != null) {
            return aspect.getDimension();
        }
        return null;
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public double getStandardDeviation() {
        return this.stdDeviation;
    }

    public double getVariance() throws AnalysisFailedException {
        double std = this.getStandardDeviation();
        return std * std;
    }

    public double getCoefficientOfVariance() {
        double std = this.getStandardDeviation();
        double mean = this.getMeanValue();
        return std / mean;
    }

    public ConfidenceInterval getConfidenceInterval(Criterion criterion) {
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getResponseTime())) {
            return this.confidenceInterval;
        }
        return null;
    }

    public double getMedianValue() {
        return this.medianValue;
    }

    protected abstract void getUtilisationOfResource(ActiveResourceUtilisationResult var1, Entity var2, ResourceType var3) throws AnalysisFailedException;

    public long getNumberOfObservations() {
        return this.observations;
    }

    protected static enum TimeseriesData {
        TIMESPAN,
        EVENTTIME,
        BOTH;

    }
}

