/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simulizar;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.IStatisticAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.simulizar.SimulizarQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.measure.Measure;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math.stat.descriptive.rank.Median;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.ResultdecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ActiveResourceUtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ResourceenvironmentdecoratorFactory;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class SimulizarAnalysisResult
extends AbstractPerformanceAnalysisResult
implements IStatisticAnalysisResult,
IPerformanceAnalysisResult {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    private long observations;
    private final Map<Criterion, EvaluationAspectWithContext> objectiveToAspects;
    private final SimulizarQualityAttributeDeclaration qualityAttributeInfo;
    private final ExperimentRun run;
    private double meanValue;
    private double stdDeviation;
    private double medianValue;
    private double throughput;
    private double maxUtilization;
    private ConfidenceInterval confidenceInterval;

    protected SimulizarAnalysisResult(ExperimentRun run, PCMInstance pcmInstance, Entity pcmEntity, Map<Criterion, EvaluationAspectWithContext> objectiveToAspect, SimulizarQualityAttributeDeclaration qualityAttributeInfo) throws AnalysisFailedException {
        super(pcmInstance);
        this.run = run;
        this.objectiveToAspects = objectiveToAspect;
        this.qualityAttributeInfo = qualityAttributeInfo;
        this.results = this.retrieveResults(pcmInstance);
        this.calculateResults();
        logger.debug((Object)"Initialised Simulizar EDP2 result");
    }

    private void calculateResults() {
        this.observations = 0L;
        this.meanValue = Double.NaN;
        this.stdDeviation = Double.NaN;
        this.medianValue = Double.NaN;
        this.throughput = Double.NaN;
        this.maxUtilization = Double.NaN;
        double[] values = this.getResponseTimesOfScenario();
        if (values == null) {
            return;
        }
        this.observations = values.length;
        this.meanValue = new Mean().evaluate(values);
        this.stdDeviation = new StandardDeviation().evaluate(values);
        this.medianValue = new Median().evaluate(values);
    }

    private List<Measurement> findMeasurement(MetricSetDescription id, Class<? extends MeasuringPoint> type) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        EList measurements = this.run.getMeasurement();
        for (Measurement measurement : measurements) {
            MeasuringType mType = measurement.getMeasuringType();
            MetricDescription mdsc = mType.getMetric();
            if (!mdsc.getId().equals(id.getId())) continue;
            MeasuringPoint mp = measurement.getMeasuringType().getMeasuringPoint();
            if (type != null && !type.isInstance(mp)) continue;
            result.add(measurement);
        }
        return result;
    }

    private double[] getResponseTimesOfScenario() {
        double[] values = null;
        List<Measurement> measurements = this.findMeasurement(MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE, UsageScenarioMeasuringPoint.class);
        if (measurements.size() != 1) {
            logger.error((Object)"Invalid amount of measurement points for scenario have been found!");
            return null;
        }
        Measurement measurement = measurements.get(0);
        MeasurementRange range = (MeasurementRange)measurement.getMeasurementRanges().get(0);
        DataSeries series = (DataSeries)range.getRawMeasurements().getDataSeries().get(1);
        MeasurementsDao qa = MeasurementsUtility.getMeasurementsDao((DataSeries)series);
        List q = qa.getMeasurements();
        values = new double[q.size()];
        int i = 0;
        for (Measure m : q) {
            values[i++] = (Double)m.getValue();
        }
        return values;
    }

    private ResultDecoratorRepository retrieveResults(PCMInstance pcmInstance) throws AnalysisFailedException {
        ResultDecoratorRepository repo = ResultdecoratorFactory.eINSTANCE.createResultDecoratorRepository();
        this.retrieveActiveResourceUtil(pcmInstance, repo);
        this.retrieveServiceResults(pcmInstance, repo);
        this.retrievePassiveResourceUtil(repo, pcmInstance);
        return repo;
    }

    private void retrievePassiveResourceUtil(ResultDecoratorRepository repo, PCMInstance pcmInstance) {
        logger.warn((Object)"Passive Resources will not monitored so far");
    }

    private void retrieveServiceResults(PCMInstance pcmInstance, ResultDecoratorRepository repo) {
        logger.warn((Object)"Services will not monitored so far");
    }

    private void retrieveActiveResourceUtil(PCMInstance pcmInstance, ResultDecoratorRepository repo) {
        EList resourceContainerList = pcmInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        for (ResourceContainer resourceContainer : resourceContainerList) {
            EList resources = resourceContainer.getActiveResourceSpecifications_ResourceContainer();
            for (ProcessingResourceSpecification resource : resources) {
                ProcessingResourceSpecificationResult result = ResourceenvironmentdecoratorFactory.eINSTANCE.createProcessingResourceSpecificationResult();
                this.getUtilisationOfResource((ActiveResourceUtilisationResult)result, (Entity)resourceContainer, (ResourceType)resource.getActiveResourceType_ActiveResourceSpecification());
                if (result == null || result.getResourceUtilisation() == Double.NaN) continue;
                result.setEntityName("Util of " + resourceContainer.getEntityName() + "_" + resource.getActiveResourceType_ActiveResourceSpecification().getEntityName());
                result.setProcessingResourceSpecification_ProcessingResourceSpecificationResult(resource);
                repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
            }
        }
        EList linkList = pcmInstance.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
        for (LinkingResource linkingResource : linkList) {
            CommunicationLinkResourceType type = linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification();
            LinkingResourceResults result = ResourceenvironmentdecoratorFactory.eINSTANCE.createLinkingResourceResults();
            result.setLinkingResource_LinkingResourceResults(linkingResource);
            this.getUtilisationOfResource((ActiveResourceUtilisationResult)result, (Entity)linkingResource, (ResourceType)type);
            if (result == null || result.getResourceUtilisation() == Double.NaN) continue;
            result.setEntityName("Util of " + linkingResource.getEntityName() + "_" + type);
            repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
        }
    }

    private void getUtilisationOfResource(ActiveResourceUtilisationResult resultToFill, Entity container, ResourceType resourceType) {
        List<Measurement> measurements = this.findMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, ActiveResourceMeasuringPoint.class);
        if (measurements.isEmpty()) {
            resultToFill.setResourceUtilisation(Double.NaN);
            return;
        }
        if (!(resourceType instanceof ProcessingResourceType)) {
            logger.warn((Object)"Only CPU measurements are currently supported ..");
            resultToFill.setResourceUtilisation(Double.NaN);
            return;
        }
        String cpuId = ((ProcessingResourceSpecification)((ResourceContainer)container).getActiveResourceSpecifications_ResourceContainer().get(0)).getId();
        for (Measurement measurement : measurements) {
            MeasuringType type = measurement.getMeasuringType();
            MeasuringPoint mp = type.getMeasuringPoint();
            if (!mp.getResourceURIRepresentation().endsWith(cpuId)) continue;
            MeasurementRange range = (MeasurementRange)measurement.getMeasurementRanges().get(0);
            DataSeries series = (DataSeries)range.getRawMeasurements().getDataSeries().get(1);
            MeasurementsDao qa = MeasurementsUtility.getMeasurementsDao((DataSeries)series);
            List q = qa.getMeasurements();
            double[] values = new double[q.size()];
            int i = 0;
            for (Measure m : q) {
                values[i++] = (Double)m.getValue();
            }
            resultToFill.setResourceUtilisation(new Mean().evaluate(values));
        }
        resultToFill.setResourceUtilisation(Double.NaN);
    }

    public double getValueFor(Criterion criterion) {
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getResponseTime())) {
            return this.meanValue;
        }
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getThroughput())) {
            return this.throughput;
        }
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getMaxUtilization())) {
            return this.maxUtilization;
        }
        logger.warn((Object)"Unknown aspect for simu com result, adding NaN.");
        return Double.NaN;
    }

    private Dimension getDimensionForCriterion(Criterion criterion) {
        EvaluationAspectWithContext aspect = this.objectiveToAspects.get(criterion);
        if (aspect != null) {
            return aspect.getDimension();
        }
        return null;
    }

    public double getMedianValue() {
        return this.medianValue;
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public double getStandardDeviation() {
        return this.stdDeviation;
    }

    public double getCoefficientOfVariance() {
        double std = this.getStandardDeviation();
        double mean = this.getMeanValue();
        return std / mean;
    }

    public ConfidenceInterval getConfidenceInterval(Criterion criterion) {
        if (EcoreUtil.equals((EObject)this.getDimensionForCriterion(criterion), (EObject)this.qualityAttributeInfo.getResponseTime())) {
            return this.confidenceInterval;
        }
        return null;
    }

    public long getNumberOfObservations() {
        return this.observations;
    }

    public static boolean isExperimentRunExisting(String experimentName, String experimentSettingName, Repository repo) {
        return SimulizarAnalysisResult.findExperimentRun(experimentName, experimentSettingName, repo) != null;
    }

    public static IStatisticAnalysisResult findExperimentRunAndCreateResult(Entity entity, String experimentName, String experimentSettingName, PCMInstance pcmInstance, Repository repo, Map<Criterion, EvaluationAspectWithContext> criterionToAspect, SimulizarQualityAttributeDeclaration qualityAttribute) throws AnalysisFailedException {
        ExperimentSetting mySetting = SimulizarAnalysisResult.findExperimentRun(experimentName, experimentSettingName, repo);
        if (mySetting != null) {
            EList expRuns = mySetting.getExperimentRuns();
            ECollections.sort((EList)expRuns, (Comparator)new ExperimentRunComparator());
            ExperimentRun reqRun = null;
            for (ExperimentRun experimentRun : expRuns) {
                if (experimentRun.getMeasurement().size() <= 0) continue;
                reqRun = experimentRun;
                break;
            }
            return new SimulizarAnalysisResult(reqRun, pcmInstance, entity, criterionToAspect, qualityAttribute);
        }
        return null;
    }

    private static ExperimentSetting findExperimentRun(String experimentName, String experimentSettingName, Repository repo) {
        EList currentExperimentGroups = repo.getExperimentGroups();
        for (ExperimentGroup curr : currentExperimentGroups) {
            if (!experimentName.equals(curr.getPurpose())) continue;
            EList settings = curr.getExperimentSettings();
            for (ExperimentSetting experimentSetting : settings) {
                EList expRuns;
                if (!experimentSettingName.equals(experimentSetting.getDescription()) || (expRuns = experimentSetting.getExperimentRuns()).size() <= 0) continue;
                for (ExperimentRun experimentRun : expRuns) {
                    if (experimentRun.getMeasurement().size() <= 0) continue;
                    return experimentSetting;
                }
            }
        }
        return null;
    }

    protected static Repository findSelectedEDP2Repository(ILaunchConfiguration config) throws CoreException {
        String selectedDataSourceID = config.getAttribute("EDP2RepositoryID", "");
        EList repos = RepositoryManager.getCentralRepository().getAvailableRepositories();
        for (Repository repo : repos) {
            if (!repo.getId().equals(selectedDataSourceID)) continue;
            return repo;
        }
        return null;
    }

    private static class ExperimentRunComparator
    implements Comparator<ExperimentRun> {
        private ExperimentRunComparator() {
        }

        @Override
        public int compare(ExperimentRun first, ExperimentRun second) {
            return second.getStartTime().compareTo(first.getStartTime());
        }
    }
}

