/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simulizar;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.IStatisticAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.analysis.simulizar.SimulizarAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.simulizar.SimulizarJob;
import de.uka.ipd.sdq.dsexplore.analysis.simulizar.SimulizarQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.exception.ExceptionHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EntryLevelSystemCallCriterion;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.UsageScenarioBasedCriterion;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.launchconfig.core.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.configurations.PCMWorkflowConfigurationBuilder;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.runconfig.SimuLizarLaunchConfigurationBasedConfigBuilder;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class SimulizarAnalysis
extends AbstractAnalysis
implements IAnalysis {
    private static int COUNTER = 0;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    private ILaunchConfiguration config;
    private String initialExperimentName;
    private final Map<Integer, String> previousExperimentNames = new HashMap<Integer, String>();
    private SimuLizarWorkflowConfiguration workflowConfig;

    public SimulizarAnalysis() {
        super((IAnalysisQualityAttributeDeclaration)new SimulizarQualityAttributeDeclaration());
    }

    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) throws AnalysisFailedException, CoreException, UserCanceledException {
        String experimentName = this.getExperimentName(pheno);
        String experimentSettingName = this.getExperimentSettingName(pheno);
        this.previousExperimentNames.put(pheno.getGenotypeID().hashCode(), experimentSettingName);
        ILaunchConfigurationWorkingCopy launchWorkingCopy = this.config.getWorkingCopy();
        launchWorkingCopy.setAttribute("experimentRun", experimentName);
        launchWorkingCopy.setAttribute("variationId", experimentSettingName);
        this.workflowConfig = this.deriveConfiguration((ILaunchConfiguration)launchWorkingCopy, "run");
        this.workflowConfig.setOverwriteWithoutAsking(true);
        System.gc();
        if (this.isExperimentRunDoesNotExist(experimentName, experimentSettingName)) {
            this.launchSimulizar(monitor);
        }
    }

    private void launchSimulizar(IProgressMonitor monitor) throws CoreException, AnalysisFailedException {
        this.workflowConfig.setInteractive(false);
        SimulizarJob job = new SimulizarJob(this.workflowConfig, ++COUNTER);
        job.setBlackboard((Blackboard)this.blackboard);
        try {
            job.execute(monitor);
            logger.debug((Object)"Finished Simulizar analysis");
            job.cleanup(monitor);
        }
        catch (CleanupFailedException | JobFailedException | UserCanceledException e) {
            logger.error((Object)"Error during simulation.");
            e.printStackTrace();
            throw new AnalysisFailedException(e);
        }
    }

    public void initialise(DSEWorkflowConfiguration configuration) throws CoreException {
        this.previousExperimentNames.clear();
        this.config = configuration.getRawConfiguration();
        if (!this.config.getAttribute("persistenceFramework", "").contains("EDP2")) {
            throw ExceptionHelper.createNewCoreException((String)"Only EDP2 is supported");
        }
        if (this.blackboard == null) {
            throw ExceptionHelper.createNewCoreException((String)"Error in initialisation: No Blackboard was set when initialising the SimuLizar Analysis. Contact the developers.");
        }
        this.initialExperimentName = this.config.getAttribute("experimentRun", "");
        this.initialiseCriteria(configuration);
    }

    public IStatisticAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws CoreException, AnalysisFailedException {
        Entity entity = this.getPCMEntityForCriterion(criterion);
        return this.retrieveSimulizarResults(pheno, entity);
    }

    private IStatisticAnalysisResult retrieveSimulizarResults(PCMPhenotype pheno, Entity entity) throws AnalysisFailedException, CoreException {
        SimulizarQualityAttributeDeclaration sq;
        Repository repo;
        PCMResourceSetPartition pcmPartition;
        PCMInstance pcmInstance;
        String experimentSettingName;
        String experimentName = this.getExperimentName(pheno);
        IStatisticAnalysisResult result = SimulizarAnalysisResult.findExperimentRunAndCreateResult(entity, experimentName, experimentSettingName = this.getExperimentSettingName(pheno), pcmInstance = new PCMInstance(pcmPartition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition")), repo = SimulizarAnalysisResult.findSelectedEDP2Repository(this.config), this.criterionToAspect, sq = (SimulizarQualityAttributeDeclaration)this.qualityAttribute);
        if (result == null) {
            String errormessage = "There was no experiment named \"" + experimentName + "\" with an experiment setting \"" + experimentSettingName + "\"" + " in the selected data source after analysing the PCM instance \"" + experimentName + "\" of candidate " + pheno.getNumericID() + " " + pheno.getGenotypeID();
            logger.error((Object)errormessage);
            throw new AnalysisFailedException(errormessage);
        }
        return result;
    }

    private Entity getPCMEntityForCriterion(Criterion criterion) throws CoreException {
        if (criterion instanceof UsageScenarioBasedCriterion) {
            return ((UsageScenarioBasedCriterion)criterion).getUsageScenario();
        }
        if (criterion instanceof EntryLevelSystemCallCriterion) {
            return ((EntryLevelSystemCallCriterion)criterion).getEntryLevelSystemCall();
        }
        throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore.analysis.simulizar", "Cannot handle Criterion of type " + criterion.getClass() + ". Required is UsageScenarioBasedCriterion or EntryLevelSystemCallCriterion."));
    }

    public boolean hasObjectivePerUsageScenario() throws CoreException {
        return true;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    private boolean isExperimentRunDoesNotExist(String experimentName, String experimentSettingName) throws CoreException {
        return !SimulizarAnalysisResult.isExperimentRunExisting(experimentName, experimentSettingName, SimulizarAnalysisResult.findSelectedEDP2Repository(this.config));
    }

    protected SimuLizarWorkflowConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        SimuLizarWorkflowConfiguration config = new SimuLizarWorkflowConfiguration(configuration.getAttributes());
        PCMWorkflowConfigurationBuilder builder = new PCMWorkflowConfigurationBuilder(configuration, mode);
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)config);
        builder = new SimuLizarLaunchConfigurationBasedConfigBuilder(configuration, mode);
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)config);
        return config;
    }

    private String getExperimentName(PCMPhenotype pheno) throws CoreException {
        return String.valueOf(this.initialExperimentName) + " " + pheno.getGenotypeID();
    }

    private String getExperimentSettingName(PCMPhenotype pheno) throws CoreException {
        return pheno.getGenotypeID();
    }
}

