/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.qml.reader;

import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.declarations.QMLDeclarations.QMLDeclarationsPackage;
import de.uka.ipd.sdq.dsexplore.qml.reader.QMLDeclarationsReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class QMLDimensionReader {
    public List<Dimension> getDimensions(String[] dimensionPaths) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        String[] stringArray = dimensionPaths;
        int n = dimensionPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String dimensionPath = stringArray[n2];
            dimensions.add(this.getDimension(dimensionPath));
            ++n2;
        }
        return dimensions;
    }

    public Dimension getDimension(String dimensionPath) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http:///QMLDeclarations.ecore", (Object)QMLDeclarationsPackage.eINSTANCE);
        File file = new File(dimensionPath);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)dimensionPath);
        Resource resource = resourceSet.getResource(uri, true);
        Dimension dimension = null;
        Iterator iterator = resource.getContents().iterator();
        if (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() != 0) {
                new QMLDeclarationsReader().printDiagnostic(diagnostic, "");
                throw new RuntimeException("QML validation failed!");
            }
            if (!(eObject instanceof Dimension)) {
                throw new RuntimeException("Check QML definition! Dimension expected!");
            }
            dimension = (Dimension)eObject;
        }
        return dimension;
    }
}

