/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.tools.repository;

import FeatureCompletionModel.CompletionComponent;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import de.uka.ipd.sdq.pcm.cost.CostRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.ComponentType;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public final class MergedRepository
extends EObjectImpl
implements Iterable<Repository> {
    private final Set<Repository> repositories = new HashSet<Repository>();
    private Repository repoWithoutAnnotations;

    public MergedRepository(Repository ... repositories) {
        this.repositories.addAll(Arrays.asList(repositories));
        this.createRepo();
    }

    public MergedRepository(List<Repository> repositories) {
        this.repositories.addAll(repositories);
        this.createRepo();
    }

    public MergedRepository(Set<Repository> repositories) {
        this.repositories.addAll(repositories);
        this.createRepo();
    }

    private void createRepo() {
        Repository repo = RepositoryFactory.eINSTANCE.createRepository();
        repo.setEntityName("MergedRepo");
        repo.setId("MergedRepo" + this.hashCode());
        for (Repository r : this.repositories) {
            Repository copy = this.copyOf(r);
            repo.getComponents__Repository().addAll((Collection)copy.getComponents__Repository());
        }
        this.repoWithoutAnnotations = repo;
    }

    private Repository copyOf(Repository repo) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Repository newRepo = (Repository)copier.copy((EObject)repo);
        copier.copyReferences();
        return newRepo;
    }

    public List<CostRepository> getCostRepos() {
        HashSet<CostRepository> repos = new HashSet<CostRepository>();
        for (Repository repo : this.repositories) {
            repos.addAll(StereotypeAPIHelper.getViaStereoTypeFrom(repo, CostRepository.class));
        }
        return new ArrayList<CostRepository>(repos);
    }

    public List<RepositoryComponent> getAffectedComponentsByFCCList(List<CompletionComponent> fccs) {
        HashSet<RepositoryComponent> affectedComponents = new HashSet<RepositoryComponent>();
        for (Repository repo : this.repositories) {
            for (RepositoryComponent rcs : repo.getComponents__Repository()) {
                List<CompletionComponent> realizedCCs = StereotypeAPIHelper.getViaStereoTypeFrom(rcs, CompletionComponent.class);
                if (!this.anyContainedInList(realizedCCs, fccs)) continue;
                affectedComponents.add(rcs);
            }
        }
        return new ArrayList<RepositoryComponent>(affectedComponents);
    }

    private boolean anyContainedInList(List<CompletionComponent> realizedCCs, List<CompletionComponent> listToContainedIn) {
        for (CompletionComponent completionComponent : realizedCCs) {
            if (!listToContainedIn.contains(completionComponent)) continue;
            return true;
        }
        return false;
    }

    public RepositoryComponent createAndAddAdapter(String name, Repository repo) {
        BasicComponent adapter = this.createAdapter(name);
        repo.getComponents__Repository().add((Object)adapter);
        return adapter;
    }

    private BasicComponent createAdapter(String name) {
        BasicComponent adapter = RepositoryFactory.eINSTANCE.createBasicComponent();
        adapter.setComponentType(ComponentType.BUSINESS_COMPONENT);
        adapter.setEntityName(name);
        return adapter;
    }

    public Repository getAsRepoWithoutStereotypes() {
        return this.repoWithoutAnnotations;
    }

    public List<ProvidedRole> getAllProvidedRoles() {
        ArrayList<ProvidedRole> prs = new ArrayList<ProvidedRole>();
        for (Repository repo : this.repositories) {
            for (RepositoryComponent c : repo.getComponents__Repository()) {
                EList role = c.getProvidedRoles_InterfaceProvidingEntity();
                prs.addAll((Collection<ProvidedRole>)role);
            }
        }
        return prs;
    }

    @Override
    public Iterator<Repository> iterator() {
        return this.repositories.iterator();
    }
}

