/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.helper.GenotypeReader;
import de.uka.ipd.sdq.dsexplore.launch.DSELaunch;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class OptimisationJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.launch.OptimisationJob");
    private PCMInstance pcmInstance;
    private List<IAnalysis> evaluators;
    private Long startTimestampMillis;
    private MDSDBlackboard blackboard;
    private DSEWorkflowConfiguration dseConfig;

    public OptimisationJob(DSEWorkflowConfiguration config, DSELaunch launch) {
        this.dseConfig = config;
        this.evaluators = config.getEvaluators();
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.startTimestampMillis = System.currentTimeMillis();
        logger.debug((Object)"Starting...");
        try {
            try {
                logger.debug((Object)("\n Launching optimization with \nmaximal number of iterations: " + this.dseConfig.getMaxIterations() + "\n" + "individuals per generation:" + this.dseConfig.getIndividualsPerGeneration() + "\n" + "offspring per generation: individuals per generation / 2 rounded up."));
                this.pcmInstance = this.getPCMInstance();
                ArrayList<PCMInstance> instances = new ArrayList<PCMInstance>();
                instances.add(this.pcmInstance);
                Opt4JStarter.init(this.evaluators, this.dseConfig, this.getPCMInstance(), monitor, this.blackboard);
                if (this.dseConfig.hasCacheInstances()) {
                    this.fillCacheWithValues(this.dseConfig.getCacheInstancesFileName());
                }
                if (this.dseConfig.isOptimise()) {
                    List<DesignDecisionGenotype> genotypes = GenotypeReader.getGenotypes(this.dseConfig.getPredefinedInstancesFileName(), this.blackboard);
                    List<DesignDecisionGenotype> allCandidates = GenotypeReader.getGenotypes(this.dseConfig.getPredefinedAllCandidatesFileName(), this.blackboard);
                    List<DesignDecisionGenotype> archiveCandidates = GenotypeReader.getGenotypes(this.dseConfig.getArchiveCandidateFileName(), this.blackboard);
                    Opt4JStarter.runOpt4JWithPopulation(this.dseConfig, monitor, genotypes, allCandidates, archiveCandidates);
                }
            }
            catch (CoreException e) {
                throw new JobFailedException(e);
            }
        }
        finally {
            logger.warn((Object)("DSE launch done. It took " + (System.currentTimeMillis() - this.startTimestampMillis) / 1000L + " seconds."));
            if (Opt4JStarter.getProblem() != null) {
                Opt4JStarter.getProblem().cleanup();
            }
            try {
                Runtime.getRuntime().gc();
                Opt4JStarter.closeTask();
                Opt4JStarter.tearDown();
                Runtime.getRuntime().gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<DSEIndividual> fillCacheWithValues(URI cacheInstancesFileName) throws CoreException {
        return GenotypeReader.getIndividuals(cacheInstancesFileName, this.blackboard);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    private PCMInstance getPCMInstance() {
        if (this.blackboard != null) {
            return new PCMInstance((PCMResourceSetPartition)this.blackboard.getPartition("initialPCModelPartitionID"));
        }
        String message = "Internal error: Cannot retrieve PCM model if blackboard is not set. ";
        logger.error((Object)message);
        throw new UnsupportedOperationException(message);
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

