/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.helper.FilterParetoOptimalIndividuals;
import de.uka.ipd.sdq.dsexplore.helper.ResultsWriter;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticOperatorsManager;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSECreator;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.eclipse.core.runtime.CoreException;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.Iteration;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.operator.copy.Copy;
import org.opt4j.start.Constant;

public class RuleBasedSearch
extends AbstractOptimizer {
    private TacticOperatorsManager tacticsManager;
    private IndividualFactory individualFactory;
    private boolean fullSearch;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.optimizer.RuleBasedSearch");

    @Inject
    public RuleBasedSearch(Population population, Archive archive, IndividualFactory individualFactory, IndividualCompleter completer, Control control, Copy<Genotype> copy, Iteration iteration, @Constant(value="fullSearch", namespace=RuleBasedSearch.class) @Constant(value="fullSearch", namespace=RuleBasedSearch.class) boolean fullSearch) {
        super(population, archive, completer, control, iteration);
        this.tacticsManager = new TacticOperatorsManager(copy, (DSEIndividualFactory)individualFactory);
        this.fullSearch = fullSearch;
        this.individualFactory = individualFactory;
    }

    public void optimize() throws StopException, TerminationException {
        Individual ind = this.individualFactory.create();
        this.population.add(ind);
        try {
            DSECreator creator = Opt4JStarter.getDSECreator();
            int numberOfPredefinedOnes = creator.getNumberOfNotEvaluatedPredefinedOnes();
            int i = 1;
            while (i <= numberOfPredefinedOnes) {
                Individual ind2 = this.individualFactory.create();
                this.population.add(ind2);
                ++i;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.nextIteration();
        int i = 0;
        while (this.iteration.value() < this.iteration.max()) {
            LinkedList<TacticsResultCandidate> nextGeneration = new LinkedList<TacticsResultCandidate>();
            for (Individual individual : this.population) {
                if (individual instanceof DSEIndividual) {
                    DSEIndividual dseIndividual = (DSEIndividual)individual;
                    List<TacticsResultCandidate> candidateResults = this.tacticsManager.getAllCandidates(dseIndividual);
                    nextGeneration.addAll(candidateResults);
                    continue;
                }
                throw new RuntimeException("Encountered a non-DSEIndividual in rule based search that I cannot handle. Aborting.");
            }
            int nextGenerationSize = nextGeneration.size();
            nextGeneration.removeAll((Collection<?>)this.population);
            nextGeneration.removeAll((Collection<?>)this.archive);
            logger.info((Object)("Removed " + (nextGeneration.size() - nextGenerationSize) + " duplicate candidate (that were in the previous population or in the archive)."));
            this.completer.complete(nextGeneration);
            this.population.clear();
            this.population.addAll(nextGeneration);
            if (!this.fullSearch) {
                ArrayList<TacticsResultCandidate> archiveAndNewUnion = new ArrayList<TacticsResultCandidate>(this.archive.size() + nextGeneration.size());
                archiveAndNewUnion.addAll(nextGeneration);
                archiveAndNewUnion.addAll((Collection<TacticsResultCandidate>)this.archive);
                List optimalCandidates = FilterParetoOptimalIndividuals.filterPareto(archiveAndNewUnion);
                this.population.retainAll(optimalCandidates);
            }
            if (this.population.size() == 0) {
                logger.warn((Object)("No more individuals in population, aborting after iteration " + i));
                break;
            }
            this.nextIteration();
        }
        logger.warn((Object)("Finished rule-based search after " + i + " iterations."));
        if (this.iteration.value() == this.iteration.max()) {
            logger.warn((Object)("Stop condition was the configured maximum number of iterations, more rule applications may be possible. There were " + this.population.size() + " candidates in the final population."));
        }
        ResultsWriter writer = new ResultsWriter(Opt4JStarter.getDSEWorkflowConfig().getResultFolder(), "rule-based search results");
        for (Individual individual : this.archive) {
            if (individual instanceof DSEIndividual) {
                DSEIndividual dseIndiv = (DSEIndividual)individual;
                writer.writeIndividual(dseIndiv);
                continue;
            }
            logger.warn((Object)"Encountered a non DSE-Individual in the rule based search, aborting to write results.");
        }
        writer.flush();
        RuleBasedSearch.flushAllLogs();
    }

    public static void flushAllLogs() {
        try {
            HashSet<WriterAppender> flushedFileAppenders = new HashSet<WriterAppender>();
            Enumeration currentLoggers = LogManager.getLoggerRepository().getCurrentLoggers();
            while (currentLoggers.hasMoreElements()) {
                Object nextLogger = currentLoggers.nextElement();
                if (!(nextLogger instanceof Logger)) continue;
                Logger currentLogger = (Logger)nextLogger;
                Enumeration allAppenders = currentLogger.getAllAppenders();
                while (allAppenders.hasMoreElements()) {
                    WriterAppender fileAppender;
                    Object nextElement = allAppenders.nextElement();
                    if (!(nextElement instanceof WriterAppender) || flushedFileAppenders.contains(fileAppender = (WriterAppender)nextElement) || fileAppender.getImmediateFlush()) continue;
                    flushedFileAppenders.add(fileAppender);
                    fileAppender.setImmediateFlush(true);
                    currentLogger.info((Object)"FLUSH");
                    fileAppender.setImmediateFlush(false);
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"Failed flushing logs", (Throwable)e);
        }
    }
}

