/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.ResourceContainerWithDoubleValue;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.AllocationServiceResult;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedCommunication;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ServiceExecutionContext;

class ComponentAndServiceResult {
    private AllocationContext allocationContextOfComponent;
    private List<AllocationServiceResult> allocationServiceResultList = new ArrayList<AllocationServiceResult>();
    private List<ServiceExecutionContext> serviceExecutionContextList = new ArrayList<ServiceExecutionContext>();
    private double frequencyLocalCalls = 0.0;
    private List<ResourceContainerWithDoubleValue> frequencyRemoteCalls = new ArrayList<ResourceContainerWithDoubleValue>();
    private List<ResourceContainerWithDoubleValue> ratioRemoteCalls = new ArrayList<ResourceContainerWithDoubleValue>();
    private AllocationDegree allocationDoF;
    private ClassChoice allocationChoice;

    public ComponentAndServiceResult(AllocationContext component, DSEIndividual individual) {
        this.allocationContextOfComponent = component;
        this.allocationDoF = this.determineAllocationDoF();
        this.allocationChoice = this.determineAllocationChoice(individual);
    }

    public AllocationContext getComponent() {
        return this.allocationContextOfComponent;
    }

    public AllocationDegree getAllocationDegree() {
        return this.allocationDoF;
    }

    public ResourceContainerWithDoubleValue getMostPromisingContainerToReallocateTo(List<ResourceContainer> candidateContainers) {
        ArrayList<ResourceContainer> filteredCandidateContainers = new ArrayList<ResourceContainer>(candidateContainers.size());
        filteredCandidateContainers.addAll(candidateContainers);
        EMFHelper.retainAll(filteredCandidateContainers, (Collection<? extends EObject>)this.allocationDoF.getClassDesignOptions());
        ResourceContainerWithDoubleValue maxRatioContainer = null;
        for (ResourceContainerWithDoubleValue resourceContainer : this.ratioRemoteCalls) {
            if (!EMFHelper.contains(filteredCandidateContainers, (EObject)resourceContainer.getFirst()) || maxRatioContainer != null && !((Double)resourceContainer.getSecond() > (Double)maxRatioContainer.getSecond())) continue;
            maxRatioContainer = resourceContainer;
        }
        return maxRatioContainer;
    }

    public void addServiceExecutionContext(ServiceExecutionContext serviceExecutionContext) {
        this.serviceExecutionContextList.add(serviceExecutionContext);
    }

    public void countCalls() {
        for (ServiceExecutionContext serviceExecutionContext : this.serviceExecutionContextList) {
            EList senderCommunication = serviceExecutionContext.getSentAggregatedCommunications_ServiceExecutionContext();
            EList receiverCommunication = serviceExecutionContext.getReceivedAggregatedCommunication_AggregatedCommunication();
            this.countCallsOfCommunications((List<AggregatedCommunication>)senderCommunication);
            this.countCallsOfCommunications((List<AggregatedCommunication>)receiverCommunication);
        }
        for (ResourceContainerWithDoubleValue rcv : this.frequencyRemoteCalls) {
            ResourceContainerWithDoubleValue rcRatio = new ResourceContainerWithDoubleValue((ResourceContainer)rcv.getFirst(), new Double((Double)rcv.getSecond() / ((Double)rcv.getSecond() + this.frequencyLocalCalls)));
            this.ratioRemoteCalls.add(rcRatio);
        }
    }

    private void countCallsOfCommunications(List<AggregatedCommunication> senderCommunication) {
        for (AggregatedCommunication aggregatedCommunication : senderCommunication) {
            ResourceContainer receivingContainer = aggregatedCommunication.getReceiver_AggregatedCommunication().getAllocationContext_ServiceExecutionContext().getResourceContainer_AllocationContext();
            if (!EMFHelper.checkIdentity((EObject)receivingContainer, this.allocationChoice.getChosenValue())) {
                ResourceContainerWithDoubleValue remoteContainer = this.createOrReuseResourceContainerEntryInList(receivingContainer);
                remoteContainer.setSecond((Double)remoteContainer.getSecond() + aggregatedCommunication.getAverageMessageFrequency());
                continue;
            }
            this.frequencyLocalCalls += aggregatedCommunication.getAverageMessageFrequency();
        }
    }

    private ResourceContainerWithDoubleValue createOrReuseResourceContainerEntryInList(ResourceContainer receivingContainer) {
        for (ResourceContainerWithDoubleValue resourceContainerEntry : this.frequencyRemoteCalls) {
            if (!EMFHelper.checkIdentity((EObject)resourceContainerEntry.getFirst(), (EObject)receivingContainer)) continue;
            return resourceContainerEntry;
        }
        ResourceContainerWithDoubleValue rcf = new ResourceContainerWithDoubleValue(receivingContainer, new Double(0.0));
        this.frequencyRemoteCalls.add(rcf);
        return rcf;
    }

    public List<AllocationServiceResult> getResult() {
        return this.allocationServiceResultList;
    }

    private AllocationDegree determineAllocationDoF() {
        List<DegreeOfFreedomInstance> dof = Opt4JStarter.getProblem().getDesignDecisions();
        for (DegreeOfFreedomInstance DegreeOfFreedomInstance2 : dof) {
            AllocationDegree allocDof;
            if (!(DegreeOfFreedomInstance2 instanceof AllocationDegree) || !EMFHelper.checkIdentity((allocDof = (AllocationDegree)DegreeOfFreedomInstance2).getPrimaryChanged(), (EObject)this.allocationContextOfComponent)) continue;
            return allocDof;
        }
        return null;
    }

    private ClassChoice determineAllocationChoice(DSEIndividual individual) {
        Iterator<Choice> iterator = individual.getGenotype().iterator();
        while (iterator.hasNext()) {
            Choice choice = iterator.next();
            if (!EcoreUtil.equals((EObject)choice.getDegreeOfFreedomInstance(), (EObject)this.allocationDoF)) continue;
            return (ClassChoice)choice;
        }
        return null;
    }

    public void addAllocationServiceResult(AllocationServiceResult result) {
        this.allocationServiceResultList.add(result);
    }

    public boolean equals(Object o) {
        if (o instanceof ComponentAndServiceResult) {
            return EMFHelper.checkIdentity((EObject)this.allocationContextOfComponent, (EObject)((ComponentAndServiceResult)o).getComponent());
        }
        return false;
    }

    public int hashCode() {
        return this.allocationContextOfComponent.getId().hashCode();
    }
}

