/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.helper.Pair;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.AbstractTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.ActiveResInfo;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.CompInfoResDemand;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.PassiveResInfo;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.ServiceInfo;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.Thresholds;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.CapacityDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.SchedulingPolicyDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Criterion;
import org.opt4j.core.Genotype;
import org.opt4j.core.Objective;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.ServiceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.PassiveResourceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedCommunication;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedResourceDemand;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ComputedAggregatedUsage;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ServiceExecutionContext;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class ConcurrentProcessingSystemImplCatia
extends AbstractTactic {
    private Objective performance;
    protected static Logger logger = Logger.getLogger((String)ConcurrentProcessingSystemImplCatia.class.getName());

    public ConcurrentProcessingSystemImplCatia(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype"});
        try {
            Collection<Objective> objectives = Opt4JStarter.getDSEEvaluator().getObjectives();
            for (Objective objective : objectives) {
                if (!objective.getName().contains(DSEConstantsContainer.QualityAttribute.PERFORMANCE_QUALITY.getName())) continue;
                this.performance = objective;
                break;
            }
        }
        catch (Exception exception) {}
    }

    public int getMaxUtilisedCpu(List<ActiveResInfo> list) {
        int position = 0;
        int temp = 0;
        for (ActiveResInfo el : list) {
            if (el.type.getEntityName().equals("CPU") && el.utilisation > list.get((int)position).utilisation) {
                position = temp;
            }
            ++temp;
        }
        return position;
    }

    public int getMaxUtilisedHdd(List<ActiveResInfo> list) {
        int position = 0;
        int temp = 0;
        for (ActiveResInfo el : list) {
            if (el.type.getEntityName().equals("HDD") && el.utilisation > list.get((int)position).utilisation) {
                position = temp;
            }
            ++temp;
        }
        return position;
    }

    public int getMaxUtilisedActiveRes(List<ActiveResInfo> list) {
        int position = 0;
        int temp = 0;
        for (ActiveResInfo el : list) {
            if (el.utilisation > list.get((int)position).utilisation) {
                position = temp;
            }
            ++temp;
        }
        return position;
    }

    public List<ActiveResInfo> getOverUsedCpu(List<ActiveResInfo> list) {
        ArrayList<ActiveResInfo> result = new ArrayList<ActiveResInfo>(0);
        double thresholdMaxCpu = new Thresholds().thresholdMaxCpu;
        double thresholdCpuQL = new Thresholds().thresholdCpuQL;
        for (ActiveResInfo el : list) {
            if (!el.type.getEntityName().equals("CPU") || !(el.utilisation > thresholdMaxCpu) || !(el.queueLength > thresholdCpuQL)) continue;
            result.add(el);
        }
        return result;
    }

    public List<ActiveResInfo> getUnderUsedCpu(List<ActiveResInfo> list) {
        ArrayList<ActiveResInfo> result = new ArrayList<ActiveResInfo>(0);
        double thresholdMinCpu = new Thresholds().thresholdMinCpu;
        for (ActiveResInfo el : list) {
            if (!el.type.getEntityName().equals("CPU") || !(el.utilisation < thresholdMinCpu)) continue;
            result.add(el);
        }
        return result;
    }

    public List<ActiveResInfo> getOverUsedHDD(List<ActiveResInfo> list) {
        ArrayList<ActiveResInfo> result = new ArrayList<ActiveResInfo>(0);
        double thresholdMaxHdd = new Thresholds().thresholdMaxHdd;
        double thresholdHddQL = new Thresholds().thresholdHddQL;
        for (ActiveResInfo el : list) {
            if (!el.type.getEntityName().equals("HDD") || !(el.utilisation > thresholdMaxHdd) || !(el.queueLength > thresholdHddQL)) continue;
            result.add(el);
        }
        return result;
    }

    public List<ActiveResInfo> getUnderUsedHDD(List<ActiveResInfo> list) {
        ArrayList<ActiveResInfo> result = new ArrayList<ActiveResInfo>(0);
        double thresholdMinHdd = new Thresholds().thresholdMinHdd;
        for (ActiveResInfo el : list) {
            if (!el.type.getEntityName().equals("HDD") || !(el.utilisation < thresholdMinHdd)) continue;
            result.add(el);
        }
        return result;
    }

    public List<PassiveResInfo> getCriticalPassiveRes(List<PassiveResInfo> list) {
        ArrayList<PassiveResInfo> result = new ArrayList<PassiveResInfo>(0);
        double thresholdPrQL = new Thresholds().thresholdPrQL;
        for (PassiveResInfo el : list) {
            if (!(el.queueLength > thresholdPrQL) || !(el.waitingTime > el.holdingTime * 2.0)) continue;
            result.add(el);
        }
        return result;
    }

    public boolean compOccurrence(List<CompInfoResDemand> list, AllocationContext a) {
        boolean value = false;
        for (CompInfoResDemand compInfoResDemand : list) {
            if (compInfoResDemand.ac != a) continue;
            value = true;
        }
        return value;
    }

    public void incrementComputation(List<CompInfoResDemand> list, AllocationContext b, double value) {
        for (CompInfoResDemand compInfoResDemand : list) {
            if (compInfoResDemand.ac != b) continue;
            compInfoResDemand.computation += value;
        }
    }

    public void incrementStorage(List<CompInfoResDemand> list, AllocationContext b, double value) {
        for (CompInfoResDemand compInfoResDemand : list) {
            if (compInfoResDemand.ac != b) continue;
            compInfoResDemand.storage += value;
        }
    }

    public void updateFrequency(List<ServiceInfo> list, String seffName, String compName, double f) {
        for (ServiceInfo el : list) {
            if (!el.serviceName.equals(seffName) || !el.compName.equals(compName)) continue;
            el.frequency = f;
        }
    }

    public boolean unbalancedSeffs(List<ServiceInfo> list) {
        boolean result = false;
        double gapRT = 0.5;
        if (this.getMaxRT(list) - this.getMinRT(list) > gapRT) {
            result = true;
            logger.info((Object)("The list of seffs is unbalanced, the maximum resp. time is " + this.getMaxRT(list) + " and the minimum one is " + this.getMinRT(list)));
        }
        return result;
    }

    public boolean cps(List<ActiveResInfo> list) {
        boolean result = false;
        if (this.getOverUsedCpu(list).size() != 0 && this.getUnderUsedCpu(list).size() != 0 || this.getOverUsedHDD(list).size() != 0 && this.getUnderUsedHDD(list).size() != 0) {
            logger.info((Object)"The antipattern CONCURRENT PROCESSING SYSTEMS has been detected");
            result = true;
        }
        return result;
    }

    public boolean olb(List<ServiceInfo> list, PassiveResInfo criticPassiveRes) {
        boolean result = false;
        for (ServiceInfo el : list) {
            if (!el.compName.equals(criticPassiveRes.component) || !(el.respT > el.userReq)) continue;
            result = true;
        }
        if (result) {
            logger.info((Object)"The antipattern ONE-LANE BRIDGE has been detected");
        }
        return result;
    }

    public boolean ep(ActiveResInfo activeRes, List<ServiceInfo> list) {
        boolean result = false;
        if (activeRes.schedulingPolicy.equals("FCFS") && this.unbalancedSeffs(list)) {
            result = true;
            logger.info((Object)"The antipattern EXTENSIVE PROCESSING has been detected");
        }
        return result;
    }

    public int getCompMaxCPUdemand(List<CompInfoResDemand> list) {
        int position = 0;
        int temp = 0;
        for (CompInfoResDemand compInfoResDemand : list) {
            if (compInfoResDemand != null && list.get((int)position).computation < compInfoResDemand.computation) {
                position = temp;
            }
            ++temp;
        }
        return position;
    }

    public int getCompMaxHDDdemand(List<CompInfoResDemand> list) {
        int position = 0;
        int temp = 0;
        for (CompInfoResDemand compInfoResDemand : list) {
            if (compInfoResDemand != null && list.get((int)position).storage < compInfoResDemand.storage) {
                position = temp;
            }
            ++temp;
        }
        return position;
    }

    public List<CompInfoResDemand> deployedComponents(List<CompInfoResDemand> comp, ResourceContainer node) {
        ArrayList<CompInfoResDemand> result = new ArrayList<CompInfoResDemand>(0);
        for (CompInfoResDemand compInfoResDemand : comp) {
            if (compInfoResDemand.rc != node) continue;
            result.add(compInfoResDemand);
        }
        return result;
    }

    public List<ServiceInfo> getSeffsOfComp(List<ServiceInfo> list, String comp) {
        ArrayList<ServiceInfo> result = new ArrayList<ServiceInfo>(0);
        for (ServiceInfo el : list) {
            if (!el.compName.equals(comp)) continue;
            result.add(el);
        }
        return result;
    }

    public double getMaxRT(List<ServiceInfo> list) {
        double temp = 0.0;
        for (ServiceInfo el : list) {
            if (!(el.respT > temp)) continue;
            temp = el.respT;
        }
        return temp;
    }

    public double getMinRT(List<ServiceInfo> list) {
        double temp = this.getMaxRT(list);
        for (ServiceInfo el : list) {
            if (!(el.respT < temp)) continue;
            temp = el.respT;
        }
        return temp;
    }

    public boolean doesMatchPrecondition(DSEIndividual i) {
        return this.getSolution(i) != null;
    }

    public List<TacticsResultCandidate> getSolution(DSEIndividual i) {
        if (this.performance != null && i.getObjectives().getResultDecoratorFor((Criterion)this.performance) != null) {
            ResourceType resourceType;
            Object seffName;
            ResultDecoratorRepository resultRepo = i.getObjectives().getResultDecoratorFor((Criterion)this.performance);
            logger.info((Object)"---------------------------------------------------------------------");
            logger.info((Object)("System response time: " + i.getObjectives().get(this.performance).getDouble()));
            logger.info((Object)"---------------------------------------------------------------------");
            EList serviceResultList = resultRepo.getServiceResult_ResultDecoratorRepository();
            ArrayList<ServiceInfo> serviceInfoList = new ArrayList<ServiceInfo>(serviceResultList.size());
            for (ServiceResult serviceResult : serviceResultList) {
                serviceInfoList.add(new ServiceInfo(serviceResult.getServiceEffectSpecification_ServiceResult().getDescribedService__SEFF().getEntityName(), serviceResult.getServiceEffectSpecification_ServiceResult().getBasicComponent_ServiceEffectSpecification().getEntityName(), 0.001, serviceResult.getMeanResponseTime(), 0.0));
            }
            EList allUtilResults = resultRepo.getUtilisationResults_ResultDecoratorRepository();
            ArrayList<ProcessingResourceSpecificationResult> utilResults = new ArrayList<ProcessingResourceSpecificationResult>(allUtilResults.size());
            ArrayList<PassiveResourceResult> passiveResourceUtilResults = new ArrayList<PassiveResourceResult>(5);
            for (UtilisationResult anyUtilResult : allUtilResults) {
                if (anyUtilResult instanceof ProcessingResourceSpecificationResult) {
                    utilResults.add((ProcessingResourceSpecificationResult)anyUtilResult);
                    continue;
                }
                if (!(anyUtilResult instanceof PassiveResourceResult)) continue;
                passiveResourceUtilResults.add((PassiveResourceResult)anyUtilResult);
                ((PassiveResourceResult)anyUtilResult).getAverageQueueLength();
                ((PassiveResourceResult)anyUtilResult).getAverageWaitTime();
            }
            ArrayList<ActiveResInfo> activeResInfoList = new ArrayList<ActiveResInfo>(utilResults.size());
            for (UtilisationResult utilisationResult : utilResults) {
                if (!(utilisationResult instanceof ProcessingResourceSpecificationResult)) continue;
                ProcessingResourceSpecificationResult activeProcUtilResult = (ProcessingResourceSpecificationResult)utilisationResult;
                ProcessingResourceSpecification resource = activeProcUtilResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult();
                activeResInfoList.add(new ActiveResInfo(resource.getResourceContainer_ProcessingResourceSpecification(), resource.getActiveResourceType_ActiveResourceSpecification(), activeProcUtilResult.getResourceUtilisation(), activeProcUtilResult.getAverageQueueLength(), resource.getSchedulingPolicy().getId()));
            }
            logger.info((Object)"List of Active Resources: ");
            for (ActiveResInfo activeResInfo : activeResInfoList) {
                activeResInfo.print();
            }
            logger.info((Object)"---------------------------------------------------------------------");
            logger.info((Object)"Max utilised hardware resources: ");
            logger.info((Object)"Max utilised active resource: ");
            ActiveResInfo activeResInfo = new ActiveResInfo((ActiveResInfo)activeResInfoList.get(this.getMaxUtilisedActiveRes(activeResInfoList)));
            activeResInfo.print();
            logger.info((Object)"Max utilised cpu resource: ");
            ActiveResInfo maxUtilisedCpu = new ActiveResInfo((ActiveResInfo)activeResInfoList.get(this.getMaxUtilisedCpu(activeResInfoList)));
            maxUtilisedCpu.print();
            logger.info((Object)"Max utilised hdd resource: ");
            ActiveResInfo maxUtilisedHdd = new ActiveResInfo((ActiveResInfo)activeResInfoList.get(this.getMaxUtilisedHdd(activeResInfoList)));
            maxUtilisedHdd.print();
            logger.info((Object)"---------------------------------------------------------------------");
            ComputedAggregatedUsage computedUsage = i.getObjectives().getComputedAggregatedUsageFor((Criterion)this.performance);
            EList serviceContexts = computedUsage.getServiceExecutionContexts_ComputedAggregatedUsage();
            ArrayList<CompInfoResDemand> listCompIDs = new ArrayList<CompInfoResDemand>(serviceContexts.size());
            for (ServiceExecutionContext serviceExecutionContext : serviceContexts) {
                UsageScenario usageScenario = serviceExecutionContext.getUsageScenario_ServiceExecutionContext();
                AllocationContext allocationContext = serviceExecutionContext.getAllocationContext_ServiceExecutionContext();
                double frequency = serviceExecutionContext.getGlobalExecutionFrequency();
                BasicComponent currentBasicComp = serviceExecutionContext.getDescribedSEFF_ServiceExecutionContext().getBasicComponent_ServiceEffectSpecification();
                AllocationContext currentCompAllCont = serviceExecutionContext.getAllocationContext_ServiceExecutionContext();
                if (!this.compOccurrence(listCompIDs, currentCompAllCont)) {
                    listCompIDs.add(new CompInfoResDemand(currentBasicComp, currentCompAllCont, allocationContext.getResourceContainer_AllocationContext(), 0.0, 0.0));
                }
                seffName = serviceExecutionContext.getDescribedSEFF_ServiceExecutionContext().getDescribedService__SEFF().getEntityName();
                this.updateFrequency(serviceInfoList, (String)seffName, currentBasicComp.getEntityName(), frequency);
                logger.info((Object)" ");
                logger.info((Object)("Service " + serviceExecutionContext.getDescribedSEFF_ServiceExecutionContext().getDescribedService__SEFF().getEntityName() + " of component " + serviceExecutionContext.getDescribedSEFF_ServiceExecutionContext().getBasicComponent_ServiceEffectSpecification().getEntityName() + " in allocation context " + allocationContext.getEntityName() + " on server " + allocationContext.getResourceContainer_AllocationContext().getEntityName() + " has frequency " + frequency + " in usage scenario " + usageScenario.getEntityName()));
                EList eList = serviceExecutionContext.getAggregatedResourceDemands_ServiceExecutionContext();
                for (AggregatedResourceDemand aggregatedResourceDemand : eList) {
                    resourceType = aggregatedResourceDemand.getResourceType_AggregatedResourceDemand();
                    double demand = aggregatedResourceDemand.getAggregatedResourceDemand();
                    if (resourceType.getEntityName().equals("CPU")) {
                        this.incrementComputation(listCompIDs, currentCompAllCont, demand);
                    }
                    if (!resourceType.getEntityName().equals("HDD")) continue;
                    this.incrementStorage(listCompIDs, currentCompAllCont, demand);
                }
                EList communicationInfoList = serviceExecutionContext.getSentAggregatedCommunications_ServiceExecutionContext();
                for (AggregatedCommunication aggregatedCommunication : communicationInfoList) {
                    CommunicationLinkResourceSpecification demand = aggregatedCommunication.getUsedCommunicationLinkResourceSpecification_AggregatedCommunication();
                }
            }
            logger.info((Object)"List of all SEFFs with the frequency value: ");
            for (ServiceInfo el : serviceInfoList) {
                el.print();
            }
            logger.info((Object)"---------------------------------------------------------------------");
            ArrayList<TacticsResultCandidate> listPairs = new ArrayList<TacticsResultCandidate>();
            PCMInstance pcm = Opt4JStarter.getProblem().getInitialInstance();
            List repositoryList = pcm.getRepositories();
            ArrayList<PassiveResInfo> passiveResInfoList = new ArrayList<PassiveResInfo>(repositoryList.size());
            for (Repository repository : repositoryList) {
                EList repoComponents = repository.getComponents__Repository();
                seffName = repoComponents.iterator();
                while (seffName.hasNext()) {
                    RepositoryComponent repositoryComponent = (RepositoryComponent)seffName.next();
                    if (!(repositoryComponent instanceof BasicComponent)) continue;
                    BasicComponent basicComponent = (BasicComponent)repositoryComponent;
                    EList passiveResourceList = basicComponent.getPassiveResource_BasicComponent();
                    resourceType = passiveResourceList.iterator();
                    while (resourceType.hasNext()) {
                        PassiveResource passiveResource = (PassiveResource)resourceType.next();
                        passiveResInfoList.add(new PassiveResInfo(passiveResource, basicComponent.getEntityName(), Integer.parseInt(passiveResource.getCapacity_PassiveResource().getSpecification()), 0.8, 1.0, 0.4));
                    }
                }
            }
            logger.info((Object)"List of Passive Resources: ");
            for (PassiveResInfo el : passiveResInfoList) {
                el.print();
            }
            logger.info((Object)"---------------------------------------------------------------------");
            List<PassiveResInfo> criticalPassiveResInfoList = this.getCriticalPassiveRes(passiveResInfoList);
            if (criticalPassiveResInfoList.size() != 0) {
                for (PassiveResInfo criticalPassiveResInfo : criticalPassiveResInfoList) {
                    if (!this.olb(serviceInfoList, criticalPassiveResInfo)) continue;
                    TacticsResultCandidate candidate = this.createIncreasedCapacityCandidate(i, criticalPassiveResInfo.pr, criticalPassiveResInfo.capacity + 5);
                    listPairs.add(candidate);
                    logger.info((Object)("The capacity of the passive resource " + criticalPassiveResInfo.pr.getEntityName() + " must be increased"));
                }
            }
            logger.info((Object)"---------------------------------------------------------------------");
            logger.info((Object)"List of components involved in services specified in the usage model: ");
            for (CompInfoResDemand el : listCompIDs) {
                el.print();
            }
            List<CompInfoResDemand> depCompCpu = this.deployedComponents(listCompIDs, maxUtilisedCpu.rc);
            List<CompInfoResDemand> depCompHdd = this.deployedComponents(listCompIDs, maxUtilisedHdd.rc);
            List<CompInfoResDemand> depComp = this.deployedComponents(listCompIDs, activeResInfo.rc);
            logger.info((Object)"---------------------------------------------------------------------");
            logger.info((Object)("List of seffs provided in the max utilised Active Resource : " + activeResInfo.rc.getEntityName()));
            ArrayList<ServiceInfo> seffsOfMaxUtilised = new ArrayList<ServiceInfo>(0);
            for (CompInfoResDemand compInfoResDemand : depComp) {
                List<ServiceInfo> seffsTempList = this.getSeffsOfComp(serviceInfoList, compInfoResDemand.bc.getEntityName());
                for (ServiceInfo elseff : seffsTempList) {
                    seffsOfMaxUtilised.add(elseff);
                }
            }
            for (ServiceInfo serviceInfo : seffsOfMaxUtilised) {
                serviceInfo.print();
            }
            logger.info((Object)"---------------------------------------------------------------------");
            if (this.ep(activeResInfo, seffsOfMaxUtilised)) {
                listPairs.add(this.createUpdatedSchedulingCandidate(i, activeResInfo, true));
                logger.info((Object)("The scheduling policy of the active resource " + activeResInfo.rc.getEntityName() + " must be changed"));
            }
            logger.info((Object)"---------------------------------------------------------------------");
            logger.info((Object)"List of the most critical components: ");
            if (depCompCpu.size() != 0) {
                CompInfoResDemand compInfoResDemand = depCompCpu.get(this.getCompMaxCPUdemand(depCompCpu));
                logger.info((Object)"Most CPU critical");
                compInfoResDemand.print();
            }
            if (depCompHdd.size() != 0) {
                CompInfoResDemand compInfoResDemand = depCompHdd.get(this.getCompMaxHDDdemand(depCompCpu));
                logger.info((Object)"Most HDD critical");
                compInfoResDemand.print();
            }
            logger.info((Object)"---------------------------------------------------------------------");
            if (this.cps(activeResInfoList)) {
                List<ActiveResInfo> list = this.getUnderUsedCpu(activeResInfoList);
                List<ActiveResInfo> getUnderUsedHDDList = this.getUnderUsedHDD(activeResInfoList);
                if (list.size() != 0 && depCompCpu.size() != 0) {
                    logger.info((Object)("Redeploy component " + depCompCpu.get((int)this.getCompMaxCPUdemand(depCompCpu)).bc.getEntityName() + " in the following servers: "));
                    for (ActiveResInfo el : list) {
                        logger.info((Object)el.rc.getEntityName());
                        Pair<CompInfoResDemand, ResourceContainer> p = new Pair<CompInfoResDemand, ResourceContainer>(depCompCpu.get(this.getCompMaxCPUdemand(depCompCpu)), el.rc);
                        listPairs.add(this.createCPSCandidate(i, p));
                    }
                }
                if (getUnderUsedHDDList.size() != 0 && depCompHdd.size() != 0) {
                    logger.info((Object)("Redeploy component " + depCompHdd.get((int)this.getCompMaxHDDdemand(depCompHdd)).bc.getEntityName() + " in the following servers: "));
                    for (ActiveResInfo el : getUnderUsedHDDList) {
                        logger.info((Object)el.rc.getEntityName());
                        Pair<CompInfoResDemand, ResourceContainer> p = new Pair<CompInfoResDemand, ResourceContainer>(depCompHdd.get(this.getCompMaxHDDdemand(depCompHdd)), el.rc);
                        listPairs.add(this.createCPSCandidate(i, p));
                    }
                }
            }
            logger.info((Object)"---------------------------------------------------------------------");
            return listPairs;
        }
        logger.warn((Object)("No performance objective or no result decorator for it found. Skipping " + this.getClass().getName()));
        return null;
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual i, UtilisationResultCacheAndHelper resultsCache) {
        List<TacticsResultCandidate> resultsTRC;
        if (this.performance != null && (resultsTRC = this.getSolution(i)) != null) {
            return resultsTRC;
        }
        return Collections.emptyList();
    }

    private TacticsResultCandidate createCPSCandidate(DSEIndividual i, Pair<CompInfoResDemand, ResourceContainer> result) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)i.getGenotype()), i);
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            ClassChoice classChoice;
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice) || !((classChoice = (ClassChoice)choice).getDegreeOfFreedomInstance() instanceof AllocationDegree) || !EMFHelper.checkIdentity(classChoice.getDegreeOfFreedomInstance().getPrimaryChanged(), (EObject)result.getFirst().ac)) continue;
            classChoice.setChosenValue((EObject)EMFHelper.retrieveEntityByID((List<? extends EObject>)((ClassDegree)classChoice.getDegreeOfFreedomInstance()).getClassDesignOptions(), (EObject)result.getSecond()));
            candidate.setCandidateWeight(1.0);
            candidate.setHeuristic(this);
            this.increaseCounterOfGeneratedCandidates();
            logger.info((Object)"Applied CPS solution");
            return candidate;
        }
        throw new RuntimeException("Changing the allocation of " + result.getFirst().ac.getEntityName() + " is not allowed with the current designdecision model.");
    }

    private TacticsResultCandidate createIncreasedCapacityCandidate(DSEIndividual i, PassiveResource pr, int newCapacity) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)i.getGenotype()), i);
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            DiscreteRangeChoice schedChoice;
            Choice choice = iterator.next();
            if (!(choice instanceof DiscreteRangeChoice) || !((schedChoice = (DiscreteRangeChoice)choice).getDegreeOfFreedomInstance() instanceof CapacityDegree) || !EMFHelper.checkIdentity(schedChoice.getDegreeOfFreedomInstance().getPrimaryChanged(), (EObject)pr)) continue;
            schedChoice.setChosenValue(newCapacity);
            candidate.setCandidateWeight(1.0);
            candidate.setHeuristic(this);
            this.increaseCounterOfGeneratedCandidates();
            logger.info((Object)("Increased capacity of " + pr.getEntityName() + " to " + newCapacity));
            return candidate;
        }
        throw new RuntimeException("Increasing the capacity of passive resource " + pr.getEntityName() + " is not allowed with the current designdecision model.");
    }

    private TacticsResultCandidate createUpdatedSchedulingCandidate(DSEIndividual i, ActiveResInfo resourceToChange, boolean useProcessorSharing) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)i.getGenotype()), i);
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            SchedulingPolicyDegree schedDegree;
            ClassChoice classChoice;
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice) || !((classChoice = (ClassChoice)choice).getDegreeOfFreedomInstance() instanceof SchedulingPolicyDegree) || !EMFHelper.checkIdentity((schedDegree = (SchedulingPolicyDegree)classChoice.getDegreeOfFreedomInstance()).getPrimaryChanged(), (EObject)resourceToChange.rc) || !EMFHelper.checkIdentity((EObject)schedDegree.getProcessingresourcetype(), (EObject)resourceToChange.type)) continue;
            SchedulingPolicy selectedStrategy = null;
            EList options = schedDegree.getClassDesignOptions();
            for (EObject eObject : options) {
                if (!(eObject instanceof SchedulingPolicy)) continue;
                SchedulingPolicy policy = (SchedulingPolicy)eObject;
                if ((useProcessorSharing || !policy.getId().equals("FCFS")) && (!useProcessorSharing || !policy.getId().equals("ProcessorSharing"))) continue;
                selectedStrategy = policy;
                break;
            }
            classChoice.setChosenValue(selectedStrategy);
            candidate.setCandidateWeight(1.0);
            candidate.setHeuristic(this);
            this.increaseCounterOfGeneratedCandidates();
            logger.info((Object)("Changed scheduling policy of " + resourceToChange.type.getEntityName() + " of " + resourceToChange.rc.getEntityName() + " to " + useProcessorSharing));
            return candidate;
        }
        throw new RuntimeException("Changing the scheduling of " + resourceToChange.type.getEntityName() + " of " + resourceToChange.rc.getEntityName() + " is not allowed with the current designdecision model.");
    }
}

