/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEDecoder;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEObjectives;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import java.util.Set;
import org.apache.log4j.Logger;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objectives;

public class DSEIndividual
extends Individual {
    private DecisionSpace problem;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual");

    public DSEIndividual(DecisionSpace problem) {
        this.problem = problem;
    }

    protected DSEIndividual() {
        this.problem = Opt4JStarter.getProblem().getEMFProblem();
    }

    public DesignDecisionGenotype getGenotype() {
        return (DesignDecisionGenotype)super.getGenotype();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DSEIndividual)) {
            return false;
        }
        DSEIndividual other = (DSEIndividual)((Object)o);
        String otherGenotypeString = other.getGenotypeString();
        String myGenotypeString = this.getGenotypeString();
        if (otherGenotypeString == null && myGenotypeString == null) {
            return super.equals((Object)other);
        }
        if (otherGenotypeString == null || myGenotypeString == null) {
            return false;
        }
        return otherGenotypeString.equals(myGenotypeString);
    }

    public String getGenotypeString() {
        if (this.genotype instanceof DesignDecisionGenotype) {
            String genotypeString = DSEDecoder.getGenotypeString((DesignDecisionGenotype)this.genotype);
            return genotypeString;
        }
        throw new RuntimeException("DSEIndividual cannot handle arbitrary genotypes yet, fix the code");
    }

    public void setIndividualStatusListeners(Set<IndividualStateListener> individualStateListeners) {
        super.setIndividualStatusListeners(individualStateListeners);
    }

    public int hashCode() {
        if (this.genotype != null) {
            return this.getGenotypeString().hashCode();
        }
        return super.hashCode();
    }

    public DSEObjectives getObjectives() {
        return (DSEObjectives)super.getObjectives();
    }

    public void setObjectives(Objectives objectives) {
        if (!(objectives instanceof DSEObjectives)) {
            String error = "DSEIndividual only supports DSEObjectives to contain the analysis results. Contact developers.";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        super.setObjectives(objectives);
    }

    public String getID() {
        return this.getGenotypeString();
    }

    public long getNumericID() {
        return this.getGenotype().getNumericID();
    }

    public DecisionSpace getProblem() {
        return this.problem;
    }
}

