/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.exception.ExceptionHelper;
import org.eclipse.core.runtime.CoreException;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ActiveResourceUtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ResourceenvironmentdecoratorFactory;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

class ResourcesWithUtilisationDescriptor {
    Entity resource;
    ResourceType resourceType;

    public ResourcesWithUtilisationDescriptor(Entity resource, ResourceType resourceType) {
        this.resource = resource;
        this.resourceType = resourceType;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Entity getEntity() {
        return this.resource;
    }

    public ActiveResourceUtilisationResult createUtilisationResult() throws CoreException {
        if (this.resource instanceof ResourceContainer) {
            if (this.resourceType != null) {
                ResourceContainer rc = (ResourceContainer)this.resource;
                for (ProcessingResourceSpecification procRes : rc.getActiveResourceSpecifications_ResourceContainer()) {
                    if (!procRes.getActiveResourceType_ActiveResourceSpecification().getId().equals(this.resourceType.getId())) continue;
                    ProcessingResourceSpecificationResult result = ResourceenvironmentdecoratorFactory.eINSTANCE.createProcessingResourceSpecificationResult();
                    result.setProcessingResourceSpecification_ProcessingResourceSpecificationResult(procRes);
                    result.setEntityName("Util of " + this.resource.getEntityName() + "_" + this.resourceType.getEntityName());
                    return result;
                }
                throw ExceptionHelper.createNewCoreException("No processing resource of type " + this.resourceType + " found for ResourceContainer " + this.resource.getEntityName());
            }
            throw ExceptionHelper.createNewCoreException("Aggregated utilisation results for resource containers are not yet supported, define a resource type.");
        }
        if (this.resource instanceof LinkingResource) {
            LinkingResourceResults result = ResourceenvironmentdecoratorFactory.eINSTANCE.createLinkingResourceResults();
            result.setEntityName("Util of " + this.resource.getEntityName() + "_" + this.resourceType.getEntityName());
            result.setLinkingResource_LinkingResourceResults((LinkingResource)this.resource);
            return result;
        }
        throw ExceptionHelper.createNewCoreException("Unknown entity to create utilisation results for: " + this.resource.getClass().getName());
    }
}

