/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis;

import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.Constraint;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EvaluationAspect;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.EntryLevelSystemCallInfeasibilityConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.EntryLevelSystemCallObjectiveBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.EntryLevelSystemCallSatisfactionConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.InfeasibilityConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.ObjectiveBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.SatisfactionConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.UsageScenarioBasedInfeasibilityConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.UsageScenarioBasedObjectiveBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.UsageScenarioBasedSatisfactionConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.reader.PCMDeclarationsReader;
import de.uka.ipd.sdq.dsexplore.qml.profile.QMLProfile.EntryLevelSystemCallRequirement;
import de.uka.ipd.sdq.dsexplore.qml.profile.QMLProfile.UsageScenarioRequirement;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.opt4j.core.Criterion;
import org.opt4j.core.InfeasibilityConstraint;
import org.opt4j.core.Objective;
import org.opt4j.core.SatisfactionConstraint;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.core.models.PCMInstance;

public abstract class AbstractAnalysis
implements IAnalysis {
    protected MDSDBlackboard blackboard;
    protected IAnalysisQualityAttributeDeclaration qualityAttribute;
    protected List<Criterion> criteriaList = new ArrayList<Criterion>();
    protected Map<Criterion, EvaluationAspectWithContext> criterionToAspect = new HashMap<Criterion, EvaluationAspectWithContext>();

    public AbstractAnalysis(IAnalysisQualityAttributeDeclaration qualityAttribute) {
        this.qualityAttribute = qualityAttribute;
    }

    @Override
    public DSEConstantsContainer.QualityAttribute getQualityAttribute() throws CoreException {
        return this.qualityAttribute.getQualityAttribute();
    }

    protected void initialiseCriteria(DSEWorkflowConfiguration configuration) throws CoreException {
        PCMInstance pcmInstance = this.getPCMInstance();
        EList scenarios = pcmInstance.getUsageModel().getUsageScenario_UsageModel();
        UsageModel usageModel = pcmInstance.getUsageModel();
        PCMDeclarationsReader reader = new PCMDeclarationsReader(configuration.getRawConfiguration().getAttribute("qmlDefinitionFile", ""));
        List<Dimension> dimensions = this.qualityAttribute.getDimensions();
        ArrayList qualityAttributeAspects = new ArrayList(6);
        for (Dimension dimension : dimensions) {
            qualityAttributeAspects.addAll(reader.getDimensionConstraintContextsForUsageModel(usageModel, dimension.getId()));
            qualityAttributeAspects.addAll(reader.getDimensionObjectiveContextsForUsageModel(usageModel, dimension.getId()));
        }
        for (EvaluationAspectWithContext aspectContext : qualityAttributeAspects) {
            if (this.canEvaluateAspect(aspectContext.getEvaluationAspect(), aspectContext.getDimension())) {
                InfeasibilityConstraint c;
                EntryLevelSystemCallInfeasibilityConstraintBuilder builder;
                if (aspectContext.getRequirement() instanceof UsageScenarioRequirement) {
                    InfeasibilityConstraint c2;
                    UsageScenarioBasedInfeasibilityConstraintBuilder builder2;
                    if (((UsageScenarioRequirement)aspectContext.getRequirement()).getUsageScenario() == null) {
                        for (UsageScenario usageScenario : scenarios) {
                            if (aspectContext.getCriterion() instanceof Constraint) {
                                builder2 = new UsageScenarioBasedInfeasibilityConstraintBuilder(usageScenario);
                                c2 = reader.translateEvalAspectToInfeasibilityConstraint(aspectContext, (InfeasibilityConstraintBuilder)builder2);
                                this.criteriaList.add((Criterion)c2);
                                this.criterionToAspect.put((Criterion)c2, aspectContext);
                                continue;
                            }
                            UsageScenarioBasedObjectiveBuilder objectiveBuilder = new UsageScenarioBasedObjectiveBuilder(usageScenario);
                            Objective o = reader.translateEvalAspectToObjective(this.getQualityAttribute().getName(), aspectContext, (ObjectiveBuilder)objectiveBuilder);
                            this.criteriaList.add((Criterion)o);
                            this.criterionToAspect.put((Criterion)o, aspectContext);
                            UsageScenarioBasedSatisfactionConstraintBuilder builder3 = new UsageScenarioBasedSatisfactionConstraintBuilder(usageScenario);
                            SatisfactionConstraint c3 = reader.translateEvalAspectToSatisfactionConstraint(aspectContext, o, (SatisfactionConstraintBuilder)builder3);
                            this.criteriaList.add((Criterion)c3);
                            this.criterionToAspect.put((Criterion)c3, aspectContext);
                        }
                        continue;
                    }
                    if (aspectContext.getCriterion() instanceof Constraint) {
                        builder = new UsageScenarioBasedInfeasibilityConstraintBuilder(((UsageScenarioRequirement)aspectContext.getRequirement()).getUsageScenario());
                        c = reader.translateEvalAspectToInfeasibilityConstraint(aspectContext, (InfeasibilityConstraintBuilder)builder);
                        this.criteriaList.add((Criterion)c);
                        this.criterionToAspect.put((Criterion)c, aspectContext);
                        continue;
                    }
                    UsageScenarioBasedObjectiveBuilder objectiveBuilder = new UsageScenarioBasedObjectiveBuilder(((UsageScenarioRequirement)aspectContext.getRequirement()).getUsageScenario());
                    Objective o = reader.translateEvalAspectToObjective(this.getQualityAttribute().getName(), aspectContext, (ObjectiveBuilder)objectiveBuilder);
                    this.criteriaList.add((Criterion)o);
                    this.criterionToAspect.put((Criterion)o, aspectContext);
                    builder2 = new UsageScenarioBasedSatisfactionConstraintBuilder(((UsageScenarioRequirement)aspectContext.getRequirement()).getUsageScenario());
                    c2 = reader.translateEvalAspectToSatisfactionConstraint(aspectContext, o, (SatisfactionConstraintBuilder)builder2);
                    this.criteriaList.add((Criterion)c2);
                    this.criterionToAspect.put((Criterion)c2, aspectContext);
                    continue;
                }
                if (aspectContext.getRequirement() instanceof EntryLevelSystemCallRequirement) {
                    if (aspectContext.getCriterion() instanceof Constraint) {
                        builder = new EntryLevelSystemCallInfeasibilityConstraintBuilder(((EntryLevelSystemCallRequirement)aspectContext.getRequirement()).getEntryLevelSystemCall());
                        c = reader.translateEvalAspectToInfeasibilityConstraint(aspectContext, (InfeasibilityConstraintBuilder)builder);
                        this.criteriaList.add((Criterion)c);
                        this.criterionToAspect.put((Criterion)c, aspectContext);
                        continue;
                    }
                    EntryLevelSystemCall entryLevelSystemCall = ((EntryLevelSystemCallRequirement)aspectContext.getRequirement()).getEntryLevelSystemCall();
                    EntryLevelSystemCallObjectiveBuilder builder4 = new EntryLevelSystemCallObjectiveBuilder(entryLevelSystemCall);
                    Objective o = reader.translateEvalAspectToObjective(this.getQualityAttribute().getName(), aspectContext, (ObjectiveBuilder)builder4);
                    this.criteriaList.add((Criterion)o);
                    this.criterionToAspect.put((Criterion)o, aspectContext);
                    EntryLevelSystemCallSatisfactionConstraintBuilder satisBuilder = new EntryLevelSystemCallSatisfactionConstraintBuilder(entryLevelSystemCall);
                    SatisfactionConstraint c4 = reader.translateEvalAspectToSatisfactionConstraint(aspectContext, o, (SatisfactionConstraintBuilder)satisBuilder);
                    this.criteriaList.add((Criterion)c4);
                    this.criterionToAspect.put((Criterion)c4, aspectContext);
                    continue;
                }
                throw new RuntimeException("Unsupported Requirement!");
            }
            throw new RuntimeException("Evaluation aspect not supported(" + aspectContext.getEvaluationAspect() + ")!");
        }
    }

    protected boolean canEvaluateAspect(EvaluationAspect aspect, Dimension dimension) {
        return this.qualityAttribute.canEvaluateAspectForDimension(aspect, dimension);
    }

    protected PCMInstance getPCMInstance() {
        return new PCMInstance((PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition"));
    }

    @Override
    public List<Criterion> getCriterions() throws CoreException {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        criterions.addAll(this.criteriaList);
        return criterions;
    }

    @Override
    public boolean hasStatisticResultsFor() throws CoreException {
        return false;
    }
}

