/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.pcm.designdecision.Candidates;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.resourcetype.ResourcetypePackage;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;

public class EMFHelper {
    public static boolean checkIdentity(EObject i1, EObject i2) {
        if (i1 == null || i2 == null) {
            return false;
        }
        if (i1 instanceof Identifier && i2 instanceof Identifier) {
            return ((Identifier)i1).getId().equals(((Identifier)i2).getId());
        }
        return EcoreUtil.equals((EObject)i1, (EObject)i2);
    }

    public static boolean contains(Collection<? extends EObject> coll, EObject i) {
        for (EObject eObject : coll) {
            if (!EMFHelper.checkIdentity(eObject, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean retainAll(Collection<? extends Identifier> collection, Collection<? extends EObject> itemsToRetain) {
        boolean removedAny = false;
        Iterator<? extends Identifier> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = iterator.next();
            boolean identifierContainedInItemsToRetain = false;
            for (EObject eObject : itemsToRetain) {
                if (!EMFHelper.checkIdentity((EObject)identifier, eObject)) continue;
                identifierContainedInItemsToRetain = true;
            }
            if (identifierContainedInItemsToRetain) continue;
            iterator.remove();
            removedAny = true;
        }
        return removedAny;
    }

    public static void saveToXMIFile(EObject modelToSave, URI fileName) {
        EMFHelper.saveToXMIFile(modelToSave, fileName, true);
    }

    private static void saveToXMIFile(EObject modelToSave, URI myURI, boolean mayRetry) {
        Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
        logger.debug((Object)("Saving " + modelToSave.toString() + " to " + myURI));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(myURI);
        resource.getContents().add((Object)modelToSave);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (mayRetry && myURI.toFileString().length() > 250) {
                String lastSegment = myURI.segment(myURI.segmentCount() - 1);
                int lengthOfShortenedSegment = lastSegment.length() > 25 ? 25 : lastSegment.length() / 2;
                String lastSegmentShortened = lastSegment.substring(0, lengthOfShortenedSegment);
                URI myShorterURI = myURI.trimSegments(1);
                myShorterURI = myShorterURI.appendSegment(String.valueOf(lastSegmentShortened) + "-shortened-" + myURI.toString().hashCode());
                EMFHelper.saveToXMIFile(modelToSave, myShorterURI, false);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Caught IOException:" + e.getClass() + ": " + e.getMessage() + " when trying to save to file " + myURI.toString()));
        }
    }

    public static EObject loadFromXMIFile(URI fileName, EPackage ePackage) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EMFHelper.registerPackages((ResourceSet)resourceSet);
        return EMFHelper.loadFromXMIFile(fileName, (ResourceSet)resourceSet, ePackage);
    }

    public static EObject loadFromXMIFile(URI uri, ResourceSet resourceSet, EPackage ePackage) {
        Resource resource = null;
        try {
            resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
            resource = resourceSet.getResource(uri, true);
        }
        catch (Exception e) {
            Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore").error((Object)e.getMessage());
            return null;
        }
        EObject eObject = (EObject)resource.getContents().iterator().next();
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    private static void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/Allocation/5.2", (Object)AllocationPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/Parameter/5.2", (Object)ParameterPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/ResourceEnvironment/5.2", (Object)ResourceenvironmentPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/ResourceType/5.2", (Object)ResourcetypePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/Repository/5.2", (Object)RepositoryPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/SEFF/5.2", (Object)SeffPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/System/5.2", (Object)SystemPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/UsageModel/5.2", (Object)UsagemodelPackage.eINSTANCE);
    }

    public static Entity retrieveEntityByID(List<? extends EObject> entities, EObject object) {
        if (object instanceof Entity) {
            ArrayList<Entity> castedEntities = new ArrayList<Entity>();
            for (EObject eObject : entities) {
                if (!(eObject instanceof Entity)) continue;
                castedEntities.add((Entity)eObject);
            }
            return EMFHelper.retrieveEntityByID(castedEntities, ((Entity)object).getId());
        }
        return null;
    }

    public static Entity retrieveEntityByID(List<? extends Entity> entities, String id) {
        for (Entity entity : entities) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    public static int indexOfByID(List<? extends Entity> entities, String id) {
        Entity entity = EMFHelper.retrieveEntityByID(entities, id);
        return entities.indexOf(entity);
    }

    public static Candidates createEMFCandidates(Collection<DSEIndividual> individuals) {
        Candidates candidates = designdecisionFactory.eINSTANCE.createCandidates();
        candidates.setProblem(Opt4JStarter.getProblem().getEMFProblem());
        for (DSEIndividual dseIndividual : individuals) {
            candidates.getCandidate().add((Object)dseIndividual.getGenotype().getEMFCandidate());
        }
        return candidates;
    }

    public static List<PassiveResource> getPassiveResources(List<Repository> repositoryList) {
        ArrayList<PassiveResource> passiveResourceList = new ArrayList<PassiveResource>(repositoryList.size());
        for (Repository repository : repositoryList) {
            EList repoComponents = repository.getComponents__Repository();
            for (RepositoryComponent repositoryComponent : repoComponents) {
                if (!(repositoryComponent instanceof BasicComponent)) continue;
                BasicComponent basicComponent = (BasicComponent)repositoryComponent;
                EList passiveResourceOfComponentList = basicComponent.getPassiveResource_BasicComponent();
                for (PassiveResource passiveResource : passiveResourceOfComponentList) {
                    passiveResourceList.add(passiveResource);
                }
            }
        }
        return passiveResourceList;
    }

    public static List<AssemblyContext> getAllUsedAssemblyContexts(ComposedProvidingRequiringEntity composite) {
        LinkedList<AssemblyContext> resultList = new LinkedList<AssemblyContext>();
        EList currentAssemblyContexts = composite.getAssemblyContexts__ComposedStructure();
        resultList.addAll((Collection<AssemblyContext>)currentAssemblyContexts);
        for (AssemblyContext assemblyContext : currentAssemblyContexts) {
            RepositoryComponent innerComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
            if (!(innerComponent instanceof ComposedProvidingRequiringEntity)) continue;
            resultList.addAll(EMFHelper.getAllUsedAssemblyContexts((ComposedProvidingRequiringEntity)innerComponent));
        }
        return resultList;
    }

    public static List<AllocationContext> getAllUsedAllocationContexts(Allocation allocation) {
        return allocation.getAllocationContexts_Allocation();
    }

    public static EObject loadFromXMIFile(String fileName, EPackage ePackage) {
        URI locationToLoadFrom = URI.createURI((String)fileName);
        if (locationToLoadFrom == null || !locationToLoadFrom.isPlatform()) {
            locationToLoadFrom = URI.createFileURI((String)fileName);
        }
        return EMFHelper.loadFromXMIFile(locationToLoadFrom, ePackage);
    }
}

