/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEObjectives;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ProcessingResourceDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Criterion;
import org.opt4j.core.Objective;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public class UtilisationResultCacheAndHelper {
    private Collection<ResourceContainer> unusedAvailableResourceContainers;
    private Collection<ResourceContainer> availableResourceContainer;
    private Map<ResourceType, ProcessingResourceSpecificationResult> minProcResultMap = new HashMap<ResourceType, ProcessingResourceSpecificationResult>();
    private Map<ResourceType, ProcessingResourceSpecificationResult> maxProcResultMap = new HashMap<ResourceType, ProcessingResourceSpecificationResult>();
    private LinkingResourceResults maxLinkResult;
    private Set<ResourceType> resourceTypes;

    public Collection<ResourceContainer> getUnusedAvailableResourceContainers(DSEIndividual individual) {
        if (this.unusedAvailableResourceContainers == null) {
            this.unusedAvailableResourceContainers = this.determineUnusedAvailableResourceContainers(individual);
        }
        return this.unusedAvailableResourceContainers;
    }

    public Collection<ResourceContainer> getAvailableResourceContainers(DSEIndividual individual) {
        if (this.availableResourceContainer == null) {
            this.availableResourceContainer = this.determineAvailaibleResourceContainer(individual);
        }
        return this.availableResourceContainer;
    }

    private Collection<ResourceContainer> determineAvailaibleResourceContainer(DSEIndividual individual) {
        ArrayList<ResourceContainer> availableResourceContainers = new ArrayList<ResourceContainer>();
        DesignDecisionGenotype genotype = individual.getGenotype();
        Iterator<Choice> iterator = genotype.iterator();
        while (iterator.hasNext()) {
            ClassChoice ClassChoice2;
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice) || !((ClassChoice2 = (ClassChoice)choice).getDegreeOfFreedomInstance() instanceof AllocationDegree)) continue;
            AllocationDegree allocationDegree = (AllocationDegree)ClassChoice2.getDegreeOfFreedomInstance();
            for (EObject entity : allocationDegree.getClassDesignOptions()) {
                if (!(entity instanceof ResourceContainer)) continue;
                availableResourceContainers.add((ResourceContainer)entity);
            }
        }
        return availableResourceContainers;
    }

    private Collection<ResourceContainer> determineUnusedAvailableResourceContainers(DSEIndividual individual) {
        DesignDecisionGenotype genotype = individual.getGenotype();
        HashSet<ResourceContainer> unusedResourceContainers = new HashSet<ResourceContainer>();
        unusedResourceContainers.addAll(this.getAvailableResourceContainers(individual));
        Iterator<Choice> iterator = genotype.iterator();
        while (iterator.hasNext()) {
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice)) continue;
            ClassChoice classChoice = (ClassChoice)choice;
            unusedResourceContainers.remove(classChoice.getChosenValue());
        }
        return unusedResourceContainers;
    }

    public ProcessingResourceSpecificationResult getMinProcUtilisationResult(DSEIndividual individual) {
        return this.getMinProcUtilisationResult(individual, null);
    }

    public ProcessingResourceSpecificationResult getMinProcUtilisationResult(DSEIndividual individual, ResourceType resourceType) {
        ProcessingResourceSpecificationResult minProcResult = this.minProcResultMap.get(resourceType);
        if (minProcResult == null) {
            EList<UtilisationResult> utilisationResults = UtilisationResultCacheAndHelper.getUtilisationResult(individual);
            ProcessingResourceSpecificationResult minUtilisationResult = null;
            if (utilisationResults != null) {
                for (UtilisationResult currentUtilisationResult : utilisationResults) {
                    if (!(currentUtilisationResult instanceof ProcessingResourceSpecificationResult)) continue;
                    ProcessingResourceSpecificationResult procUtilisationResult = (ProcessingResourceSpecificationResult)currentUtilisationResult;
                    if (!EMFHelper.contains(this.getAvailableResourceContainers(individual), (EObject)procUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getResourceContainer_ProcessingResourceSpecification()) || EMFHelper.contains(this.getUnusedAvailableResourceContainers(individual), (EObject)procUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getResourceContainer_ProcessingResourceSpecification()) || !this.checkResourceType(procUtilisationResult, resourceType) || minUtilisationResult != null && !(minUtilisationResult.getResourceUtilisation() > procUtilisationResult.getResourceUtilisation())) continue;
                    minUtilisationResult = procUtilisationResult;
                }
                this.minProcResultMap.put(resourceType, minProcResult);
                minProcResult = minUtilisationResult;
            }
        }
        return minProcResult;
    }

    private boolean checkResourceType(ProcessingResourceSpecificationResult procUtilisationResult, ResourceType resourceType) {
        return resourceType != null ? EMFHelper.checkIdentity((EObject)procUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getActiveResourceType_ActiveResourceSpecification(), (EObject)resourceType) && !resourceType.getEntityName().equals("DELAY") : true;
    }

    public LinkingResourceResults getMaxLinkUtilisationResult(DSEIndividual individual) {
        if (this.maxLinkResult == null) {
            EList<UtilisationResult> utilisationResults = UtilisationResultCacheAndHelper.getUtilisationResult(individual);
            LinkingResourceResults maxUtilisationResult = null;
            if (utilisationResults != null) {
                for (UtilisationResult currentUtilisationResult : utilisationResults) {
                    LinkingResourceResults linkUtilisationResult;
                    if (!(currentUtilisationResult instanceof LinkingResourceResults) || !((linkUtilisationResult = (LinkingResourceResults)currentUtilisationResult).getResourceUtilisation() > 0.0) || maxUtilisationResult != null && !(maxUtilisationResult.getResourceUtilisation() < linkUtilisationResult.getResourceUtilisation())) continue;
                    maxUtilisationResult = linkUtilisationResult;
                }
                this.maxLinkResult = maxUtilisationResult;
            }
        }
        return this.maxLinkResult;
    }

    public ProcessingResourceSpecificationResult getMaxProcUtilisationResult(DSEIndividual individual) {
        return this.getMaxProcUtilisationResult(individual, null);
    }

    public ProcessingResourceSpecificationResult getMaxProcUtilisationResult(DSEIndividual individual, ResourceType resourceType) {
        ProcessingResourceSpecificationResult maxProcResult = this.maxProcResultMap.get(resourceType);
        if (maxProcResult == null) {
            EList<UtilisationResult> utilisationResults = UtilisationResultCacheAndHelper.getUtilisationResult(individual);
            ProcessingResourceSpecificationResult maxUtilisationResult = null;
            if (utilisationResults != null) {
                for (UtilisationResult currentUtilisationResult : utilisationResults) {
                    if (!(currentUtilisationResult instanceof ProcessingResourceSpecificationResult)) continue;
                    ProcessingResourceSpecificationResult procUtilisationResult = (ProcessingResourceSpecificationResult)currentUtilisationResult;
                    if (!EMFHelper.contains(this.getAvailableResourceContainers(individual), (EObject)procUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult().getResourceContainer_ProcessingResourceSpecification()) || !this.checkResourceType(procUtilisationResult, resourceType) || maxUtilisationResult != null && !(maxUtilisationResult.getResourceUtilisation() < procUtilisationResult.getResourceUtilisation())) continue;
                    maxUtilisationResult = procUtilisationResult;
                }
                this.maxProcResultMap.put(resourceType, maxUtilisationResult);
                maxProcResult = maxUtilisationResult;
            }
        }
        return maxProcResult;
    }

    private static EList<UtilisationResult> getUtilisationResult(DSEIndividual individual) {
        DSEObjectives objectives = individual.getObjectives();
        Objective resonseTimeObjective = null;
        for (Objective o : objectives.getKeys()) {
            if (!o.getName().contains("response time") && !o.getName().contains("performance") && !o.getName().contains("throughput")) continue;
            resonseTimeObjective = o;
        }
        ResultDecoratorRepository resultDecoratorRepository = objectives.getResultDecoratorFor((Criterion)resonseTimeObjective);
        if (resultDecoratorRepository != null) {
            return resultDecoratorRepository.getUtilisationResults_ResultDecoratorRepository();
        }
        return null;
    }

    public static List<ProcessingResourceSpecificationResult> getProcessingResourceUtilisationResults(DSEIndividual individual) {
        EList<UtilisationResult> utilisationResults = UtilisationResultCacheAndHelper.getUtilisationResult(individual);
        ArrayList<ProcessingResourceSpecificationResult> procUtils = new ArrayList<ProcessingResourceSpecificationResult>(utilisationResults.size());
        for (UtilisationResult utilisationResult : utilisationResults) {
            if (!(utilisationResult instanceof ProcessingResourceSpecificationResult)) continue;
            procUtils.add((ProcessingResourceSpecificationResult)utilisationResult);
        }
        return procUtils;
    }

    public Set<ResourceType> getResourceTypes(DSEIndividual individual) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new HashSet<ResourceType>();
            DecisionSpace problem = individual.getProblem();
            for (DegreeOfFreedomInstance dof : problem.getDegreesOfFreedom()) {
                if (dof instanceof AllocationDegree) {
                    EList entities = ((AllocationDegree)dof).getClassDesignOptions();
                    for (EObject entity : entities) {
                        if (!(entity instanceof ResourceContainer)) continue;
                        EList resources = ((ResourceContainer)entity).getActiveResourceSpecifications_ResourceContainer();
                        for (ProcessingResourceSpecification processingResourceSpecification : resources) {
                            this.resourceTypes.add((ResourceType)processingResourceSpecification.getActiveResourceType_ActiveResourceSpecification());
                        }
                    }
                    continue;
                }
                if (!(dof instanceof ProcessingResourceDegree)) continue;
                this.resourceTypes.add((ResourceType)((ProcessingResourceDegree)dof).getProcessingresourcetype());
            }
        }
        return this.resourceTypes;
    }

    public static class UtilisationComparator
    implements Comparator<UtilisationResult> {
        @Override
        public int compare(UtilisationResult o1, UtilisationResult o2) {
            double utilO1 = o1.getResourceUtilisation();
            double utilO2 = o2.getResourceUtilisation();
            return Double.compare(utilO1, utilO2);
        }
    }
}

