/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.AbstractProcessingRateTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsListDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public class DecreaseProcessingRateImpl
extends AbstractProcessingRateTactic {
    private double decreaseProcessingRateFactor;
    private double thresholdLowUtilisation;

    public DecreaseProcessingRateImpl(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_cost.qmlcontracttype"});
        this.setHeuristicWeight(configuration.getProcessingRateWeight());
        this.decreaseProcessingRateFactor = configuration.getProcessingRateDecreaseFactor();
        this.thresholdLowUtilisation = configuration.getProcessingRateThresholdLowUtilisation();
    }

    public boolean doesMatchPrecondition(DSEIndividual i, UtilisationResultCacheAndHelper resultsCache) {
        Set<ResourceType> resourceTypes = resultsCache.getResourceTypes(i);
        for (ResourceType resourceType : resourceTypes) {
            boolean matches = this.doesMatchLowUtilisation(i, resultsCache, resourceType);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual individual, UtilisationResultCacheAndHelper resultCache) {
        ArrayList<TacticsResultCandidate> candidates = new ArrayList<TacticsResultCandidate>();
        Set<ResourceType> resourceTypes = resultCache.getResourceTypes(individual);
        for (ResourceType resourceType : resourceTypes) {
            if (resourceType.getEntityName().equals("DELAY") || !this.doesMatchLowUtilisation(individual, resultCache, resourceType)) continue;
            this.addNewCandidateWithDecreasedProcessingRate(individual, candidates, resultCache, resourceType);
        }
        return candidates;
    }

    private boolean doesMatchLowUtilisation(DSEIndividual individual, UtilisationResultCacheAndHelper resultsCache, ResourceType resourceType) {
        ProcessingResourceSpecificationResult minUtilisationResult = resultsCache.getMinProcUtilisationResult(individual, resourceType);
        return minUtilisationResult != null && minUtilisationResult.getResourceUtilisation() <= this.thresholdLowUtilisation;
    }

    private double getDecreasedProcessingRate(ContinousRangeChoice continousRangeChoice, ContinuousProcessingRateDegree processingRateDegree) {
        return Math.max(continousRangeChoice.getChosenValue() * (1.0 - this.decreaseProcessingRateFactor), processingRateDegree.getFrom());
    }

    @Override
    protected double getUpdatedProcessingRate(ContinousRangeChoice continousRangeChoice, ContinuousProcessingRateDegree processingRateDegree) {
        return this.getDecreasedProcessingRate(continousRangeChoice, processingRateDegree);
    }

    private void addNewCandidateWithDecreasedProcessingRate(DSEIndividual individual, Collection<TacticsResultCandidate> candidates, UtilisationResultCacheAndHelper resultsCache, ResourceType resourceType) {
        ProcessingResourceSpecificationResult minUtilisationResult = resultsCache.getMinProcUtilisationResult(individual, resourceType);
        ProcessingResourceSpecification minUtilProcessingResource = minUtilisationResult.getProcessingResourceSpecification_ProcessingResourceSpecificationResult();
        this.addNewProcRateCandidate(individual, candidates, minUtilisationResult, minUtilProcessingResource);
    }

    @Override
    public double getCandidateWeight(UtilisationResult utilisationResult) {
        return this.getCandidateWeightForLowUtilisation(utilisationResult);
    }

    private double getCandidateWeightForLowUtilisation(UtilisationResult utilisationResult) {
        if (this.thresholdLowUtilisation <= 0.0) {
            return 0.0;
        }
        return Math.min(1.0, Math.max(this.thresholdLowUtilisation - utilisationResult.getResourceUtilisation() / this.thresholdLowUtilisation, 0.0));
    }

    @Override
    protected int getUpdatedNumberOfCores(DiscreteRangeChoice discreteChoice, NumberOfCoresDegree numberOfCoresDegree) {
        if (numberOfCoresDegree instanceof NumberOfCoresAsRangeDegree) {
            NumberOfCoresAsRangeDegree asRangeDegree = (NumberOfCoresAsRangeDegree)numberOfCoresDegree;
            return Math.max(discreteChoice.getChosenValue() - 1, asRangeDegree.isLowerBoundIncluded() ? asRangeDegree.getFrom() : asRangeDegree.getFrom() + 1);
        }
        if (numberOfCoresDegree instanceof NumberOfCoresAsListDegree) {
            NumberOfCoresAsListDegree asListDegree = (NumberOfCoresAsListDegree)numberOfCoresDegree;
            int nextSmallestInteger = Integer.MIN_VALUE;
            int currentValue = discreteChoice.getChosenValue();
            for (Integer value : asListDegree.getListOfIntegers()) {
                if (value >= currentValue || value < nextSmallestInteger) continue;
                nextSmallestInteger = value;
            }
            if (nextSmallestInteger != Integer.MIN_VALUE) {
                return nextSmallestInteger;
            }
            return currentValue;
        }
        throw new RuntimeException("Unknown degree of freedom " + numberOfCoresDegree.getClass().getName() + ", please adjust " + this.getClass().getName());
    }
}

