/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import de.uka.ipd.sdq.dsexplore.helper.ObjectiveAndEvaluator;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.ObjectiveAndEvaluatorListIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.opt4j.core.Objective;

class ObjectiveAndEvaluatorListDecorator
implements Collection<Objective> {
    private static final String NOT_MODIFIABLE_MSG = "Collection ObjectiveAndEvaluatorListDecorator is not modifiable.";
    private Collection<ObjectiveAndEvaluator> decoratedCollection;

    public ObjectiveAndEvaluatorListDecorator(Collection<ObjectiveAndEvaluator> decoratedCollection) {
        this.decoratedCollection = decoratedCollection;
    }

    @Override
    public int size() {
        return this.decoratedCollection.size();
    }

    @Override
    public boolean add(Objective e) {
        throw new UnsupportedOperationException(NOT_MODIFIABLE_MSG);
    }

    @Override
    public boolean addAll(Collection<? extends Objective> c) {
        throw new UnsupportedOperationException(NOT_MODIFIABLE_MSG);
    }

    @Override
    public void clear() {
        this.decoratedCollection.clear();
    }

    private ObjectiveAndEvaluator findObjective(Object o) {
        if (!(o instanceof Objective)) {
            return null;
        }
        for (ObjectiveAndEvaluator oe : this.decoratedCollection) {
            if (!oe.getObjective().equals(o)) continue;
            return oe;
        }
        return null;
    }

    @Override
    public boolean contains(Object o) {
        return this.findObjective(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.decoratedCollection.isEmpty();
    }

    @Override
    public Iterator<Objective> iterator() {
        return new ObjectiveAndEvaluatorListIterator(this.decoratedCollection.iterator());
    }

    @Override
    public boolean remove(Object o) {
        ObjectiveAndEvaluator foundOE = this.findObjective(o);
        if (foundOE == null) {
            return false;
        }
        return this.decoratedCollection.remove(foundOE);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removedAll = false;
        for (Object object : c) {
            boolean bl = removedAll = removedAll || this.remove(object);
        }
        return removedAll;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<ObjectiveAndEvaluator> it = this.decoratedCollection.iterator();
        while (it.hasNext()) {
            ObjectiveAndEvaluator oe = it.next();
            if (c.contains(oe) || c.contains(oe.getObjective())) continue;
            modified = true;
            it.remove();
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Objective[this.decoratedCollection.size()];
        int i = 0;
        for (ObjectiveAndEvaluator oe : this.decoratedCollection) {
            array[i++] = oe.getObjective();
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.decoratedCollection.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.decoratedCollection.size());
        }
        int i = 0;
        T[] result = a;
        for (ObjectiveAndEvaluator oe : this.decoratedCollection) {
            result[i++] = oe.getObjective();
        }
        if (a.length > this.decoratedCollection.size()) {
            int j = i;
            while (j < a.length) {
                result[j] = null;
                ++j;
            }
        }
        return a;
    }
}

