/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.featuremodel.impl;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import de.uka.ipd.sdq.featuremodel.Feature;
import de.uka.ipd.sdq.featuremodel.FeatureGroup;
import de.uka.ipd.sdq.featuremodel.featuremodelPackage;
import de.uka.ipd.sdq.featuremodel.util.featuremodelValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Feature Group</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.uka.ipd.sdq.featuremodel.impl.FeatureGroupImpl#getMin <em>Min</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.featuremodel.impl.FeatureGroupImpl#getMax <em>Max</em>}</li>
 *   <li>{@link de.uka.ipd.sdq.featuremodel.impl.FeatureGroupImpl#getChildren <em>Children</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FeatureGroupImpl extends ChildRelationImpl implements FeatureGroup {
	/**
     * The default value of the '{@link #getMin() <em>Min</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMin()
     * @generated
     * @ordered
     */
	protected static final int MIN_EDEFAULT = 1;

	/**
     * The cached value of the '{@link #getMin() <em>Min</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMin()
     * @generated
     * @ordered
     */
	protected int min = MIN_EDEFAULT;

	/**
     * The default value of the '{@link #getMax() <em>Max</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMax()
     * @generated
     * @ordered
     */
	protected static final int MAX_EDEFAULT = 1;

	/**
     * The cached value of the '{@link #getMax() <em>Max</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMax()
     * @generated
     * @ordered
     */
	protected int max = MAX_EDEFAULT;

	/**
     * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getChildren()
     * @generated
     * @ordered
     */
	protected EList<Feature> children;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FeatureGroupImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return featuremodelPackage.Literals.FEATURE_GROUP;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public int getMin() {
        return min;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setMin(int newMin) {
        int oldMin = min;
        min = newMin;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, featuremodelPackage.FEATURE_GROUP__MIN, oldMin, min));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public int getMax() {
        return max;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setMax(int newMax) {
        int oldMax = max;
        max = newMax;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, featuremodelPackage.FEATURE_GROUP__MAX, oldMax, max));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<Feature> getChildren() {
        if (children == null) {
            children = new EObjectContainmentWithInverseEList<Feature>(Feature.class, this, featuremodelPackage.FEATURE_GROUP__CHILDREN, featuremodelPackage.FEATURE__FEATUREGROUP);
        }
        return children;
    }

	/**
     * The cached OCL expression body for the '{@link #XORorORImpliesChildrenAreMandatory(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>XO Ror OR Implies Children Are Mandatory</em>}' operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #XORorORImpliesChildrenAreMandatory(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static final String XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "true "+
"--(self.groupType = GroupTypes::OR or self.groupType = GroupTypes::XOR) implies self.children->forAll(c|c.isMandatory)";

	/**
     * The cached OCL invariant for the '{@link #XORorORImpliesChildrenAreMandatory(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>XO Ror OR Implies Children Are Mandatory</em>}' invariant operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #XORorORImpliesChildrenAreMandatory(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static Constraint XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean XORorORImpliesChildrenAreMandatory(DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext(featuremodelPackage.Literals.FEATURE_GROUP);
            try {
                XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
            if (diagnostics != null) {
                diagnostics.add
                    (new BasicDiagnostic
                        (Diagnostic.ERROR,
                         featuremodelValidator.DIAGNOSTIC_SOURCE,
                         featuremodelValidator.FEATURE_GROUP__XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY,
                         EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "XORorORImpliesChildrenAreMandatory", EObjectValidator.getObjectLabel(this, context) }),
                         new Object [] { this }));
            }
            return false;
        }
        return true;
    }

	/**
     * The cached OCL expression body for the '{@link #ALLImpliesCardinalitiesToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>ALL Implies Cardinalities To Be Minus One</em>}' operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #ALLImpliesCardinalitiesToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static final String ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "true "+
" --self.groupType = GroupTypes::ALL implies (self.min = -1 and self.max = -1)";

	/**
     * The cached OCL invariant for the '{@link #ALLImpliesCardinalitiesToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>ALL Implies Cardinalities To Be Minus One</em>}' invariant operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #ALLImpliesCardinalitiesToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static Constraint ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean ALLImpliesCardinalitiesToBeMinusOne(DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext(featuremodelPackage.Literals.FEATURE_GROUP);
            try {
                ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
            if (diagnostics != null) {
                diagnostics.add
                    (new BasicDiagnostic
                        (Diagnostic.ERROR,
                         featuremodelValidator.DIAGNOSTIC_SOURCE,
                         featuremodelValidator.FEATURE_GROUP__ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE,
                         EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "ALLImpliesCardinalitiesToBeMinusOne", EObjectValidator.getObjectLabel(this, context) }),
                         new Object [] { this }));
            }
            return false;
        }
        return true;
    }

	/**
     * The cached OCL expression body for the '{@link #ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>OR Implies Cardinalities Min To Be One And Max To Be Minus One</em>}' operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static final String OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "true "+
"--self.groupType = GroupTypes::OR implies (self.min = 1  and self.max = -1)";

	/**
     * The cached OCL invariant for the '{@link #ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>OR Implies Cardinalities Min To Be One And Max To Be Minus One</em>}' invariant operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static Constraint OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext(featuremodelPackage.Literals.FEATURE_GROUP);
            try {
                OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
            if (diagnostics != null) {
                diagnostics.add
                    (new BasicDiagnostic
                        (Diagnostic.ERROR,
                         featuremodelValidator.DIAGNOSTIC_SOURCE,
                         featuremodelValidator.FEATURE_GROUP__OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE,
                         EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne", EObjectValidator.getObjectLabel(this, context) }),
                         new Object [] { this }));
            }
            return false;
        }
        return true;
    }

	/**
     * The cached OCL expression body for the '{@link #XORImpliesCardinalitiesToBeOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>XOR Implies Cardinalities To Be One</em>}' operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #XORImpliesCardinalitiesToBeOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static final String XOR_IMPLIES_CARDINALITIES_TO_BE_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "true "+
" --self.groupType = GroupTypes::XOR implies (self.min = 1 and self.max = 1)";

	/**
     * The cached OCL invariant for the '{@link #XORImpliesCardinalitiesToBeOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>XOR Implies Cardinalities To Be One</em>}' invariant operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #XORImpliesCardinalitiesToBeOne(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
     * @generated
     * @ordered
     */
	protected static Constraint XOR_IMPLIES_CARDINALITIES_TO_BE_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean XORImpliesCardinalitiesToBeOne(DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (XOR_IMPLIES_CARDINALITIES_TO_BE_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
            OCL.Helper helper = EOCL_ENV.createOCLHelper();
            helper.setContext(featuremodelPackage.Literals.FEATURE_GROUP);
            try {
                XOR_IMPLIES_CARDINALITIES_TO_BE_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(XOR_IMPLIES_CARDINALITIES_TO_BE_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
            }
            catch (ParserException pe) {
                throw new UnsupportedOperationException(pe.getLocalizedMessage());
            }
        }
        if (!EOCL_ENV.createQuery(XOR_IMPLIES_CARDINALITIES_TO_BE_ONE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
            if (diagnostics != null) {
                diagnostics.add
                    (new BasicDiagnostic
                        (Diagnostic.ERROR,
                         featuremodelValidator.DIAGNOSTIC_SOURCE,
                         featuremodelValidator.FEATURE_GROUP__XOR_IMPLIES_CARDINALITIES_TO_BE_ONE,
                         EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "XORImpliesCardinalitiesToBeOne", EObjectValidator.getObjectLabel(this, context) }),
                         new Object [] { this }));
            }
            return false;
        }
        return true;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case featuremodelPackage.FEATURE_GROUP__CHILDREN:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildren()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case featuremodelPackage.FEATURE_GROUP__CHILDREN:
                return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case featuremodelPackage.FEATURE_GROUP__MIN:
                return getMin();
            case featuremodelPackage.FEATURE_GROUP__MAX:
                return getMax();
            case featuremodelPackage.FEATURE_GROUP__CHILDREN:
                return getChildren();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case featuremodelPackage.FEATURE_GROUP__MIN:
                setMin((Integer)newValue);
                return;
            case featuremodelPackage.FEATURE_GROUP__MAX:
                setMax((Integer)newValue);
                return;
            case featuremodelPackage.FEATURE_GROUP__CHILDREN:
                getChildren().clear();
                getChildren().addAll((Collection<? extends Feature>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case featuremodelPackage.FEATURE_GROUP__MIN:
                setMin(MIN_EDEFAULT);
                return;
            case featuremodelPackage.FEATURE_GROUP__MAX:
                setMax(MAX_EDEFAULT);
                return;
            case featuremodelPackage.FEATURE_GROUP__CHILDREN:
                getChildren().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case featuremodelPackage.FEATURE_GROUP__MIN:
                return min != MIN_EDEFAULT;
            case featuremodelPackage.FEATURE_GROUP__MAX:
                return max != MAX_EDEFAULT;
            case featuremodelPackage.FEATURE_GROUP__CHILDREN:
                return children != null && !children.isEmpty();
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (min: ");
        result.append(min);
        result.append(", max: ");
        result.append(max);
        result.append(')');
        return result.toString();
    }

	/**
     * The cached environment for evaluating OCL expressions.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //FeatureGroupImpl
