package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.analyzer.completions.CompletionRepository;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.RepositoryComponent;

@SuppressWarnings("all")
public class CompletionsXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private RepositoryXpt _repositoryXpt;

  @Inject
  @Extension
  private ComposedStructureXpt _composedStructureXpt;

  @Inject
  @Extension
  private ProvidedPortsXpt _providedPortsXpt;

  @Inject
  @Extension
  private ContextPatternXpt _contextPatternXpt;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  public void root(final CompletionRepository repository) {
    final Consumer<Completion> _function = (Completion it) -> {
      this.completionRoot(it);
    };
    repository.getCompletions_CompletionRepository().forEach(_function);
  }

  public void expandCompletions(final org.palladiosimulator.pcm.system.System system) {
    final Consumer<Completion> _function = (Completion it) -> {
      this.completionRoot(it);
    };
    this._pCMext.getAllCompletions(system).forEach(_function);
  }

  public void completionRoot(final Completion completion) {
    final String fileName = this._javaNamesExt.getFileName(completion);
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _composedStructureStart = this._composedStructureXpt.composedStructureStart(completion);
    _builder.append(_composedStructureStart);
    _builder.newLineIfNotEmpty();
    CharSequence _providedPorts = this._providedPortsXpt.providedPorts(completion);
    _builder.append(_providedPorts);
    _builder.newLineIfNotEmpty();
    CharSequence _requiredInterfaces = this._contextPatternXpt.requiredInterfaces(completion);
    _builder.append(_requiredInterfaces);
    _builder.newLineIfNotEmpty();
    CharSequence _composedStructureEnd = this._composedStructureXpt.composedStructureEnd(completion);
    _builder.append(_composedStructureEnd);
    _builder.newLineIfNotEmpty();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
    final Function1<AssemblyContext, RepositoryComponent> _function = (AssemblyContext it) -> {
      return it.getEncapsulatedComponent__AssemblyContext();
    };
    final Consumer<RepositoryComponent> _function_1 = (RepositoryComponent it) -> {
      this.innerCompletionComponent(it);
    };
    ListExtensions.<AssemblyContext, RepositoryComponent>map(completion.getAssemblyContexts__ComposedStructure(), _function).forEach(_function_1);
  }

  protected CharSequence _innerCompletionComponent(final RepositoryComponent comp) {
    StringConcatenation _builder = new StringConcatenation();
    this._repositoryXpt.componentRoot(comp);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _innerCompletionComponent(final Completion comp) {
    StringConcatenation _builder = new StringConcatenation();
    this.completionRoot(comp);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence innerCompletionComponent(final RepositoryComponent comp) {
    if (comp instanceof Completion) {
      return _innerCompletionComponent((Completion)comp);
    } else if (comp != null) {
      return _innerCompletionComponent(comp);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(comp).toString());
    }
  }
}
