package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import java.util.Arrays;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;

@SuppressWarnings("all")
public abstract class ContextPatternXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  public CharSequence requiredInterfaces(final InterfaceRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    this.componentContextInterface(entity);
    _builder.newLineIfNotEmpty();
    this.componentContextImpl(entity);
    _builder.newLineIfNotEmpty();
    CharSequence _componentContextMemberVar = this.componentContextMemberVar(entity);
    _builder.append(_componentContextMemberVar);
    _builder.newLineIfNotEmpty();
    CharSequence _componentContextSetter = this.componentContextSetter(entity);
    _builder.append(_componentContextSetter);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  private void componentContextInterface(final InterfaceRequiringEntity entity) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnContextInterface(entity));
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnContextPackage = this._javaNamesExt.fqnContextPackage(entity);
    _builder.append(_fqnContextPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// Component context interface for ");
    String _javaName = this._javaNamesExt.javaName(entity);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    _builder.append("public interface ");
    String _contextInterfaceName = this._javaNamesExt.contextInterfaceName(entity);
    _builder.append(_contextInterfaceName);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    final Iterable<OperationRequiredRole> operationRequiredRoles = Iterables.<OperationRequiredRole>filter(entity.getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final Iterable<InfrastructureRequiredRole> infrastructureRequiredRoles = Iterables.<InfrastructureRequiredRole>filter(entity.getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final OperationRequiredRole role : operationRequiredRoles) {
        CharSequence _contextInterfaceGetterSignature = this.contextInterfaceGetterSignature(role);
        _builder.append(_contextInterfaceGetterSignature, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final InfrastructureRequiredRole role_1 : infrastructureRequiredRoles) {
        CharSequence _contextInterfaceGetterSignature_1 = this.contextInterfaceGetterSignature(role_1);
        _builder.append(_contextInterfaceGetterSignature_1, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final OperationRequiredRole role_2 : operationRequiredRoles) {
        CharSequence _contextInterfaceSetterSignature = this.contextInterfaceSetterSignature(role_2);
        _builder.append(_contextInterfaceSetterSignature, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final InfrastructureRequiredRole role_3 : infrastructureRequiredRoles) {
        CharSequence _contextInterfaceSetterSignature_1 = this.contextInterfaceSetterSignature(role_3);
        _builder.append(_contextInterfaceSetterSignature_1, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    Object _contextInterfaceAdditionsTM = this.contextInterfaceAdditionsTM(entity);
    _builder.append(_contextInterfaceAdditionsTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  private void componentContextImpl(final InterfaceRequiringEntity entity) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnContext(entity));
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnContextPackage = this._javaNamesExt.fqnContextPackage(entity);
    _builder.append(_fqnContextPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// Component context class for ");
    String _javaName = this._javaNamesExt.javaName(entity);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _contextClassName = this._javaNamesExt.contextClassName(entity);
    _builder.append(_contextClassName);
    _builder.append(" implements ");
    String _fqnContextInterface = this._javaNamesExt.fqnContextInterface(entity);
    _builder.append(_fqnContextInterface);
    _builder.append(", java.io.Serializable");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    final Iterable<OperationRequiredRole> operationRequiredRoles = Iterables.<OperationRequiredRole>filter(entity.getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final Iterable<InfrastructureRequiredRole> infrastructureRequiredRoles = Iterables.<InfrastructureRequiredRole>filter(entity.getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class);
    _builder.append("\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final OperationRequiredRole role : operationRequiredRoles) {
        CharSequence _contextInterfaceMemberVar = this.contextInterfaceMemberVar(role);
        _builder.append(_contextInterfaceMemberVar, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final InfrastructureRequiredRole role_1 : infrastructureRequiredRoles) {
        CharSequence _contextInterfaceMemberVar_1 = this.contextInterfaceMemberVar(role_1);
        _builder.append(_contextInterfaceMemberVar_1, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final OperationRequiredRole role_2 : operationRequiredRoles) {
        CharSequence _contextInterfaceGetter = this.contextInterfaceGetter(role_2);
        _builder.append(_contextInterfaceGetter, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final InfrastructureRequiredRole role_3 : infrastructureRequiredRoles) {
        CharSequence _contextInterfaceGetter_1 = this.contextInterfaceGetter(role_3);
        _builder.append(_contextInterfaceGetter_1, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final OperationRequiredRole role_4 : operationRequiredRoles) {
        CharSequence _contextInterfaceSetter = this.contextInterfaceSetter(role_4);
        _builder.append(_contextInterfaceSetter, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      for(final InfrastructureRequiredRole role_5 : infrastructureRequiredRoles) {
        CharSequence _contextInterfaceSetter_1 = this.contextInterfaceSetter(role_5);
        _builder.append(_contextInterfaceSetter_1, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _contextClassName_1 = this._javaNamesExt.contextClassName(entity);
    _builder.append(_contextClassName_1, "\t");
    _builder.append(" () {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      int _size = entity.getRequiredRoles_InterfaceRequiringEntity().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t");
        _builder.append("public ");
        String _contextClassName_2 = this._javaNamesExt.contextClassName(entity);
        _builder.append(_contextClassName_2, "\t");
        _builder.append(" (");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        {
          boolean _hasElements = false;
          for(final OperationRequiredRole role_6 : operationRequiredRoles) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "\t\t");
            }
            CharSequence _contextInterfaceVar = this.contextInterfaceVar(role_6);
            _builder.append(_contextInterfaceVar, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        {
          int _size_1 = IterableExtensions.size(infrastructureRequiredRoles);
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append("\t");
            {
              int _size_2 = IterableExtensions.size(operationRequiredRoles);
              boolean _greaterThan_2 = (_size_2 > 0);
              if (_greaterThan_2) {
                _builder.append(", ");
              }
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            {
              boolean _hasElements_1 = false;
              for(final InfrastructureRequiredRole role_7 : infrastructureRequiredRoles) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder.appendImmediate(",", "\t\t");
                }
                CharSequence _contextInterfaceVar_1 = this.contextInterfaceVar(role_7);
                _builder.append(_contextInterfaceVar_1, "\t\t");
              }
            }
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append(") {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        {
          for(final OperationRequiredRole role_8 : operationRequiredRoles) {
            CharSequence _contextInterfaceInitialisation = this.contextInterfaceInitialisation(role_8);
            _builder.append(_contextInterfaceInitialisation, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        {
          for(final InfrastructureRequiredRole role_9 : infrastructureRequiredRoles) {
            CharSequence _contextInterfaceInitialisation_1 = this.contextInterfaceInitialisation(role_9);
            _builder.append(_contextInterfaceInitialisation_1, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    Object _componentContextImplAdditionsTM = this.componentContextImplAdditionsTM(entity);
    _builder.append(_componentContextImplAdditionsTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  private CharSequence componentContextMemberVar(final InterfaceRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqnContextInterface = this._javaNamesExt.fqnContextInterface(entity);
    _builder.append(_fqnContextInterface);
    _builder.append(" myContext = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  private CharSequence componentContextSetter(final InterfaceRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void setContext(");
    String _fqnContextInterface = this._javaNamesExt.fqnContextInterface(entity);
    _builder.append(_fqnContextInterface);
    _builder.append(" myContext) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.myContext = myContext;");
    _builder.newLine();
    {
      if ((entity instanceof ComposedStructure)) {
        _builder.append("\t");
        _builder.append("initInnerComponents();");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence componentContextSetterDefinition(final InterfaceRequiringEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void setContext(");
    String _fqnContextInterface = this._javaNamesExt.fqnContextInterface(entity);
    _builder.append(_fqnContextInterface);
    _builder.append(" myContext);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceVar(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceVar(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceInitialisation(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower);
    _builder.append(" = ");
    String _firstLower_1 = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceInitialisation(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower);
    _builder.append(" = ");
    String _firstLower_1 = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceMemberVar(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower);
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceMemberVar(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" ");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower);
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceGetter(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" getRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower, "\t");
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("throw new RuntimeException(\"Attempt to retrieve unbounded port. Check your architecture! \"+");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("\"Role ");
    String _entityName = role.getEntityName();
    _builder.append(_entityName, "\t\t\t");
    _builder.append(" <");
    String _id = role.getId();
    _builder.append(_id, "\t\t\t");
    _builder.append("> RequiringEntity ");
    String _entityName_1 = role.getRequiringEntity_RequiredRole().getEntityName();
    _builder.append(_entityName_1, "\t\t\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _firstLower_1 = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower_1, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _contextInterfaceGetter(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" getRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower, "\t");
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("throw new RuntimeException(\"Attempt to retrieve unbounded port. Check your architecture! \"+");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("\"Role ");
    String _entityName = role.getEntityName();
    _builder.append(_entityName, "\t\t\t");
    _builder.append(" <");
    String _id = role.getId();
    _builder.append(_id, "\t\t\t");
    _builder.append("> RequiringEntity ");
    String _entityName_1 = role.getRequiringEntity_RequiredRole().getEntityName();
    _builder.append(_entityName_1, "\t\t\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _firstLower_1 = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower_1, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _contextInterfaceSetter(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void setRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("(");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" newValue) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower, "\t");
    _builder.append(" = newValue;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _contextInterfaceSetter(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void setRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("(");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" newValue) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(role));
    _builder.append(_firstLower, "\t");
    _builder.append(" = newValue;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _contextInterfaceGetterSignature(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" getRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceGetterSignature(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" getRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceSetterSignature(final OperationRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void setRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("(");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__OperationRequiredRole());
    _builder.append(_fqn);
    _builder.append(" newValue);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contextInterfaceSetterSignature(final InfrastructureRequiredRole role) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void setRole");
    String _javaName = this._javaNamesExt.javaName(role);
    _builder.append(_javaName);
    _builder.append("(");
    String _fqn = this._javaNamesExt.fqn(role.getRequiredInterface__InfrastructureRequiredRole());
    _builder.append(_fqn);
    _builder.append(" newValue);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public Object contextInterfaceAdditionsTM(final InterfaceRequiringEntity entity) {
    return null;
  }

  public Object componentContextImplAdditionsTM(final InterfaceRequiringEntity entity) {
    return null;
  }

  public CharSequence contextInterfaceVar(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceVar((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceVar((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextInterfaceInitialisation(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceInitialisation((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceInitialisation((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextInterfaceMemberVar(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceMemberVar((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceMemberVar((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextInterfaceGetter(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceGetter((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceGetter((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextInterfaceSetter(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceSetter((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceSetter((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextInterfaceGetterSignature(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceGetterSignature((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceGetterSignature((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }

  public CharSequence contextInterfaceSetterSignature(final RequiredRole role) {
    if (role instanceof InfrastructureRequiredRole) {
      return _contextInterfaceSetterSignature((InfrastructureRequiredRole)role);
    } else if (role instanceof OperationRequiredRole) {
      return _contextInterfaceSetterSignature((OperationRequiredRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }
}
