package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.AllocationXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.analyzer.completions.NetworkComponentAllocationContext;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.subsystem.SubSystem;

@SuppressWarnings("all")
public class SimAllocationXpt extends AllocationXpt {
  @Inject
  @Extension
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private SimResourcesXpt _simResourcesXpt;

  public void allocation(final Allocation a) {
    this._simResourcesXpt.resourceEnvironmentRoot(a.getTargetResourceEnvironment_Allocation());
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnAllocationContext(a));
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _fqnAllocationContextPackage = this._javaNamesExt.fqnAllocationContextPackage(a);
    _builder.append(_fqnAllocationContextPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;");
    _builder.newLine();
    _builder.append("import de.uka.ipd.sdq.simucomframework.model.SimuComModel;");
    _builder.newLine();
    _builder.append("import de.uka.ipd.sdq.simucomframework.SimuComContext;");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("public class ");
    String _fqnAllocationContextClass = this._javaNamesExt.fqnAllocationContextClass(a);
    _builder.append(_fqnAllocationContextClass);
    _builder.append(" extends SimuComContext {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _fqnAllocationContextClass_1 = this._javaNamesExt.fqnAllocationContextClass(a);
    _builder.append(_fqnAllocationContextClass_1, "\t");
    _builder.append("(SimuComModel myModel, IResourceTableManager resourceTableManager) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(myModel, resourceTableManager);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected void initialiseAssemblyContextLookup() {");
    _builder.newLine();
    {
      EList<AllocationContext> _allocationContexts_Allocation = a.getAllocationContexts_Allocation();
      for(final AllocationContext context : _allocationContexts_Allocation) {
        _builder.append("\t\t");
        CharSequence _assemblyContextLink = this.assemblyContextLink(context, a.getSystem_Allocation());
        _builder.append(_assemblyContextLink, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence assemblyContextLink(final AllocationContext context, final org.palladiosimulator.pcm.system.System system) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    String _xifexpression = null;
    if (((context.getAssemblyContext_AllocationContext().getParentStructure__AssemblyContext() instanceof SubSystem) || (context.getAssemblyContext_AllocationContext().getParentStructure__AssemblyContext() instanceof Completion))) {
      String _id = context.getAssemblyContext_AllocationContext().getId();
      ComposedStructure _parentStructure__AssemblyContext = context.getAssemblyContext_AllocationContext().getParentStructure__AssemblyContext();
      String _parentSubsystemsIdConcatenationFor = this._pCMext.getParentSubsystemsIdConcatenationFor(system, 
        ((ComposedProvidingRequiringEntity) _parentStructure__AssemblyContext));
      _xifexpression = (_id + _parentSubsystemsIdConcatenationFor);
    } else {
      _xifexpression = context.getAssemblyContext_AllocationContext().getId();
    }
    final String fullAssemblyContextID = _xifexpression;
    _builder.newLineIfNotEmpty();
    {
      if ((context instanceof NetworkComponentAllocationContext)) {
        _builder.append("linkAssemblyContextAndResourceContainer(\"");
        _builder.append(fullAssemblyContextID);
        _builder.append("\",\"");
        String _id_1 = ((NetworkComponentAllocationContext)context).getLinkingResource().getId();
        _builder.append(_id_1);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("linkAssemblyContextAndResourceContainer(\"");
        _builder.append(fullAssemblyContextID);
        _builder.append("\",\"");
        String _id_2 = context.getResourceContainer_AllocationContext().getId();
        _builder.append(_id_2);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.newLine();
    {
      if ((((context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext() instanceof CompositeComponent) || (context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext() instanceof SubSystem)) || (context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext() instanceof Completion))) {
        {
          RepositoryComponent _encapsulatedComponent__AssemblyContext = context.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext();
          EList<AssemblyContext> _assemblyContexts__ComposedStructure = ((ComposedStructure) _encapsulatedComponent__AssemblyContext).getAssemblyContexts__ComposedStructure();
          for(final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
            String _compositeAllocation = this.compositeAllocation(assemblyContext, context, fullAssemblyContextID, system);
            _builder.append(_compositeAllocation);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  public String compositeAllocation(final AssemblyContext context, final AllocationContext allocCxt, final String parentid, final org.palladiosimulator.pcm.system.System system) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("linkAssemblyContextAndResourceContainer(\"");
    String _id = context.getId();
    _builder.append(_id);
    _builder.append("\"+\"");
    _builder.append(parentid);
    _builder.append("\",\"");
    String _id_1 = allocCxt.getResourceContainer_AllocationContext().getId();
    _builder.append(_id_1);
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    {
      if ((((context.getEncapsulatedComponent__AssemblyContext() instanceof CompositeComponent) || (context.getEncapsulatedComponent__AssemblyContext() instanceof SubSystem)) || (context.getEncapsulatedComponent__AssemblyContext() instanceof Completion))) {
        {
          RepositoryComponent _encapsulatedComponent__AssemblyContext = context.getEncapsulatedComponent__AssemblyContext();
          EList<AssemblyContext> _assemblyContexts__ComposedStructure = ((ComposedStructure) _encapsulatedComponent__AssemblyContext).getAssemblyContexts__ComposedStructure();
          for(final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
            String _id_2 = context.getId();
            String _plus = (_id_2 + parentid);
            String _compositeAllocation = this.compositeAllocation(assemblyContext, allocCxt, _plus, system);
            _builder.append(_compositeAllocation);
            _builder.newLineIfNotEmpty();
          }
        }
        {
          RepositoryComponent _encapsulatedComponent__AssemblyContext_1 = context.getEncapsulatedComponent__AssemblyContext();
          EList<AssemblyContext> _assemblyContexts__ComposedStructure_1 = ((ComposedStructure) _encapsulatedComponent__AssemblyContext_1).getAssemblyContexts__ComposedStructure();
          for(final AssemblyContext assemblyContext_1 : _assemblyContexts__ComposedStructure_1) {
            String _compositeAllocation_1 = this.compositeAllocation(assemblyContext_1, allocCxt, context.getId(), system);
            _builder.append(_compositeAllocation_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder.toString();
  }

  @Override
  public String allocationTM(final Allocation allocation) {
    String _xblockexpression = null;
    {
      this.allocation(allocation);
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
}
