package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.ResourcesXpt;
import de.uka.ipd.sdq.pcm.transformations.Helper;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.analyzer.completions.NetworkDemandParametricResourceDemand;
import org.palladiosimulator.pcm.PCMBaseClass;
import org.palladiosimulator.pcm.core.entity.ResourceProvidedRole;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;

@SuppressWarnings("all")
public class SimResourcesXpt extends ResourcesXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private SimMeasuringPointExt _simMeasuringPointExt;

  @Inject
  private M2TFileSystemAccess fsa;

  protected CharSequence _resourceDemand(final ParametricResourceDemand prd) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("double demand = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(prd.getSpecification_ParametericResourceDemand().getSpecification());
    _builder.append(_specificationString, "  ");
    _builder.append("\",Double.class));");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("ctx.findResource(this.completeAssemblyContextID).loadActiveResource(ctx.getThread(),\"");
    String _id = prd.getRequiredResource_ParametricResourceDemand().getId();
    _builder.append(_id, "  ");
    _builder.append("\",demand);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _resourceDemand(final NetworkDemandParametricResourceDemand ndprd) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("double demand = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(ndprd.getSpecification_ParametericResourceDemand().getSpecification());
    _builder.append(_specificationString, "  ");
    _builder.append("\",Double.class));");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("ctx.findResource(this.completeAssemblyContextID).loadActiveResource(ctx.getThread(),\"");
    String _id = ndprd.getRequiredCommunicationLinkResource_ParametricResourceDemand().getId();
    _builder.append(_id, "  ");
    _builder.append("\",demand);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _resourceDemand(final ResourceCall rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("           ");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("java.util.HashMap<String, java.io.Serializable> parameterMap = new java.util.HashMap<>();");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("String typeString;");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("String specificationString;");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("java.io.Serializable solvedSpecification;");
    _builder.newLine();
    _builder.append("     ");
    _builder.newLine();
    _builder.append("  \t \t\t\t");
    _builder.newLine();
    {
      EList<Parameter> _parameter__ResourceSignature = rc.getSignature__ResourceCall().getParameter__ResourceSignature();
      for(final Parameter parm : _parameter__ResourceSignature) {
        {
          EList<VariableUsage> _inputVariableUsages__CallAction = rc.getInputVariableUsages__CallAction();
          for(final VariableUsage spec : _inputVariableUsages__CallAction) {
            _builder.append("  \t \t");
            _builder.append("if(\"");
            String _javaString = this._javaNamesExt.javaString(spec.getNamedReference__VariableUsage().getReferenceName());
            _builder.append(_javaString, "  \t \t");
            _builder.append("\".equals(\"");
            String _javaString_1 = this._javaNamesExt.javaString(parm.getParameterName());
            _builder.append(_javaString_1, "  \t \t");
            _builder.append("\")){       ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t \t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("//remove Brackets [] from specification String\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("specificationString = (String)\"");
            String _specificationString = this._javaNamesExt.specificationString(rc.getNumberOfCalls__ResourceCall().getVariableCharacterisation_Specification().getSpecification_VariableCharacterisation().getSpecification());
            _builder.append(_specificationString, "  \t \t");
            _builder.append("\".subSequence(1, \"");
            String _specificationString_1 = this._javaNamesExt.specificationString(rc.getNumberOfCalls__ResourceCall().getVariableCharacterisation_Specification().getSpecification_VariableCharacterisation().getSpecification());
            _builder.append(_specificationString_1, "  \t \t");
            _builder.append("\".length() - 1);");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t \t");
            _builder.append("typeString = \"");
            String _string = parm.getDataType__Parameter().toString();
            _builder.append(_string, "  \t \t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t \t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = null;     \t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("if(typeString.contains(\"INT\")){          \t\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,Integer.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("}else if(typeString.contains(\"STRING\")){                \t\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,String.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("} else if(typeString.contains(\"BOOL\")){      \t\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,Boolean.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("} else if(typeString.contains(\"DOUBLE\")){        \t\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,Double.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("} else if(typeString.contains(\"CHAR\")){        \t\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,Character.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("} else if(typeString.contains(\"BYTE\")){\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,Byte.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("} else if(typeString.contains(\"LONG\")){                  \t\t\t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("solvedSpecification = ctx.evaluate(specificationString,Long.class);");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("throw new RuntimeException(\"Just Primitive Data Types are supported.\");");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.append("parameterMap.put(\"");
            String _javaString_2 = this._javaNamesExt.javaString(spec.getNamedReference__VariableUsage().getReferenceName());
            _builder.append(_javaString_2, "  \t \t");
            _builder.append("\", solvedSpecification);            ");
            _builder.newLineIfNotEmpty();
            _builder.append("  \t \t");
            _builder.append("}  \t  \t");
            _builder.newLine();
            _builder.append("  \t \t");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("  \t \t");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("double demand = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"");
    String _specificationString_2 = this._javaNamesExt.specificationString(rc.getNumberOfCalls__ResourceCall().getSpecification());
    _builder.append(_specificationString_2, "     ");
    _builder.append("\",Double.class));");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.append("if(parameterMap.size()>=1){");
    _builder.newLine();
    _builder.append("     \t");
    _builder.append("ctx.findResource(this.assemblyContext.getId()).loadActiveResource(ctx.getThread(),\"");
    String _javaString_3 = this._javaNamesExt.javaString(rc.getResourceRequiredRole__ResourceCall().getRequiredResourceInterface__ResourceRequiredRole().getEntityName());
    _builder.append(_javaString_3, "     \t");
    _builder.append("\",");
    int _resourceServiceId = rc.getSignature__ResourceCall().getResourceServiceId();
    _builder.append(_resourceServiceId, "     \t");
    _builder.append(", parameterMap, demand);     \t");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.append("}else{");
    _builder.newLine();
    _builder.append("     \t");
    _builder.append("ctx.findResource(this.assemblyContext.getId()).loadActiveResource(ctx.getThread(),\"");
    String _javaString_4 = this._javaNamesExt.javaString(rc.getResourceRequiredRole__ResourceCall().getRequiredResourceInterface__ResourceRequiredRole().getEntityName());
    _builder.append(_javaString_4, "     \t");
    _builder.append("\",");
    int _resourceServiceId_1 = rc.getSignature__ResourceCall().getResourceServiceId();
    _builder.append(_resourceServiceId_1, "     \t");
    _builder.append(",demand);     \t");
    _builder.newLineIfNotEmpty();
    _builder.append("     ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }

  public void resourceEnvironmentRoot(final ResourceEnvironment re) {
    final String fileName = "main/ResourceEnvironment.java";
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package main;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public class ResourceEnvironment implements de.uka.ipd.sdq.simucomframework.resources.IResourceContainerFactory {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("private static final ResourceEnvironment instance = new ResourceEnvironment();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("public static ResourceEnvironment getInstance() {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return instance;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t   ");
    CharSequence _resourceContainerInit = this.resourceContainerInit(re);
    _builder.append(_resourceContainerInit, "\t\t\t   ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence resourceContainerInit(final ResourceEnvironment re) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("public String[] getResourceContainerIDList() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.List<String> resourceContainerIds = new java.util.ArrayList<String>();");
    _builder.newLine();
    _builder.append("\t\t");
    {
      EList<ResourceContainer> _resourceContainer_ResourceEnvironment = re.getResourceContainer_ResourceEnvironment();
      for(final ResourceContainer rc : _resourceContainer_ResourceEnvironment) {
        String _resourceContainerAdd = this.resourceContainerAdd(rc);
        _builder.append(_resourceContainerAdd, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return resourceContainerIds.toArray(new String[]{});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String[] getLinkingResourceContainerIDList() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new String[] { ");
    _builder.newLine();
    {
      EList<LinkingResource> _linkingResources__ResourceEnvironment = re.getLinkingResources__ResourceEnvironment();
      boolean _hasElements = false;
      for(final LinkingResource rc_1 : _linkingResources__ResourceEnvironment) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t\t\t");
        }
        _builder.append("\t\t\t");
        _builder.append("\"");
        String _id = rc_1.getId();
        _builder.append(_id, "\t\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public java.util.ArrayList<String> getFromResourceContainerID(String linkingResourceContainerID) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.ArrayList<String> resultList = new java.util.ArrayList<String>();");
    _builder.newLine();
    {
      EList<LinkingResource> _linkingResources__ResourceEnvironment_1 = re.getLinkingResources__ResourceEnvironment();
      for(final LinkingResource rc_2 : _linkingResources__ResourceEnvironment_1) {
        _builder.append("\t\t");
        _builder.append("if(linkingResourceContainerID.equals(\"");
        String _id_1 = rc_2.getId();
        _builder.append(_id_1, "\t\t");
        _builder.append("\")) {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<ResourceContainer, String> _function = (ResourceContainer it) -> {
            return it.getId();
          };
          List<String> _map = ListExtensions.<ResourceContainer, String>map(rc_2.getConnectedResourceContainers_LinkingResource(), _function);
          for(final String id : _map) {
            _builder.append("\t\t");
            _builder.append("resultList.add(\"");
            _builder.append(id, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("return resultList;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public java.util.ArrayList<String> getToResourceContainerID(String linkingResourceContainerID) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.ArrayList<String> resultList = new java.util.ArrayList<String>();");
    _builder.newLine();
    {
      EList<LinkingResource> _linkingResources__ResourceEnvironment_2 = re.getLinkingResources__ResourceEnvironment();
      for(final LinkingResource rc_3 : _linkingResources__ResourceEnvironment_2) {
        _builder.append("\t\t");
        _builder.append("if (linkingResourceContainerID.equals(\"");
        String _id_2 = rc_3.getId();
        _builder.append(_id_2, "\t\t");
        _builder.append("\")) {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<ResourceContainer, String> _function_1 = (ResourceContainer it) -> {
            return it.getId();
          };
          List<String> _map_1 = ListExtensions.<ResourceContainer, String>map(rc_3.getConnectedResourceContainers_LinkingResource(), _function_1);
          for(final String id_1 : _map_1) {
            _builder.append("\t\t");
            _builder.append("resultList.add(\"");
            _builder.append(id_1, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("return resultList;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getLinkingResourceContainerID(String fromResourceContainerID, String toResourceContainerID) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (String id: getLinkingResourceContainerIDList()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (getFromResourceContainerID(id).contains(fromResourceContainerID) && getToResourceContainerID(id).contains(toResourceContainerID)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return id;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void fillResourceContainerWithResources(de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer rc) {");
    _builder.newLine();
    _builder.append("\t\t");
    {
      EList<ResourceContainer> _resourceContainer_ResourceEnvironment_1 = re.getResourceContainer_ResourceEnvironment();
      for(final ResourceContainer rc_4 : _resourceContainer_ResourceEnvironment_1) {
        String _resourceContainerCaseResources = this.resourceContainerCaseResources(rc_4);
        _builder.append(_resourceContainerCaseResources, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("throw new RuntimeException(\"Unknown resource container should be initialised. This should never happen\");\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void fillResourceContainerWithNestedResourceContainers(de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer rc) {");
    _builder.newLine();
    _builder.append("\t\t");
    {
      EList<ResourceContainer> _resourceContainer_ResourceEnvironment_2 = re.getResourceContainer_ResourceEnvironment();
      for(final ResourceContainer rc_5 : _resourceContainer_ResourceEnvironment_2) {
        String _resourceContainerCaseResourceContainers = this.resourceContainerCaseResourceContainers(rc_5);
        _builder.append(_resourceContainerCaseResourceContainers, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("throw new RuntimeException(\"Unknown resource container should be initialised. This should never happen\");\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void fillLinkingResourceContainer(de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer rc) {");
    _builder.newLine();
    _builder.append("\t\t");
    {
      EList<LinkingResource> _linkingResources__ResourceEnvironment_3 = re.getLinkingResources__ResourceEnvironment();
      boolean _hasElements_1 = false;
      for(final LinkingResource lr : _linkingResources__ResourceEnvironment_3) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder.appendImmediate(" else ", "\t\t");
        }
        CharSequence _linkingResourceCase = this.linkingResourceCase(lr);
        _builder.append(_linkingResourceCase, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      int _size = re.getLinkingResources__ResourceEnvironment().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("throw new RuntimeException(\"Unknown resource container should be initialised. This should never happen\");");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public String resourceContainerAdd(final ResourceContainer rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("resourceContainerIds.add(\"");
    String _id = rc.getId();
    _builder.append(_id);
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    {
      EList<ResourceContainer> _nestedResourceContainers__ResourceContainer = rc.getNestedResourceContainers__ResourceContainer();
      for(final ResourceContainer nrc : _nestedResourceContainers__ResourceContainer) {
        String _resourceContainerAdd = this.resourceContainerAdd(nrc);
        _builder.append(_resourceContainerAdd);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  public String resourceContainerCaseResources(final ResourceContainer rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (rc.getResourceContainerID().equals(\"");
    String _id = rc.getId();
    _builder.append(_id);
    _builder.append("\")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      EList<ProcessingResourceSpecification> _activeResourceSpecifications_ResourceContainer = rc.getActiveResourceSpecifications_ResourceContainer();
      for(final ProcessingResourceSpecification ars : _activeResourceSpecifications_ResourceContainer) {
        CharSequence _activeResourceAdd = this.activeResourceAdd(ars);
        _builder.append(_activeResourceAdd, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("} else ");
    _builder.newLine();
    {
      EList<ResourceContainer> _nestedResourceContainers__ResourceContainer = rc.getNestedResourceContainers__ResourceContainer();
      for(final ResourceContainer nrc : _nestedResourceContainers__ResourceContainer) {
        String _resourceContainerCaseResources = this.resourceContainerCaseResources(nrc);
        _builder.append(_resourceContainerCaseResources);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  public String resourceContainerCaseResourceContainers(final ResourceContainer rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (rc.getResourceContainerID().equals(\"");
    String _id = rc.getId();
    _builder.append(_id);
    _builder.append("\")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      EList<ResourceContainer> _nestedResourceContainers__ResourceContainer = rc.getNestedResourceContainers__ResourceContainer();
      for(final ResourceContainer nrc : _nestedResourceContainers__ResourceContainer) {
        CharSequence _nestedResourceContainerAdd = this.nestedResourceContainerAdd(nrc);
        _builder.append(_nestedResourceContainerAdd, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      ResourceContainer _parentResourceContainer__ResourceContainer = rc.getParentResourceContainer__ResourceContainer();
      boolean _notEquals = (!Objects.equal(_parentResourceContainer__ResourceContainer, null));
      if (_notEquals) {
        _builder.append("\t");
        CharSequence _parentResourceContainerAdd = this.parentResourceContainerAdd(rc.getParentResourceContainer__ResourceContainer());
        _builder.append(_parentResourceContainerAdd, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("} else ");
    _builder.newLine();
    {
      EList<ResourceContainer> _nestedResourceContainers__ResourceContainer_1 = rc.getNestedResourceContainers__ResourceContainer();
      for(final ResourceContainer nrc_1 : _nestedResourceContainers__ResourceContainer_1) {
        String _resourceContainerCaseResourceContainers = this.resourceContainerCaseResourceContainers(nrc_1);
        _builder.append(_resourceContainerCaseResourceContainers);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  public CharSequence linkingResourceCase(final LinkingResource lr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (rc.getResourceContainerID().equals(\"");
    String _id = lr.getId();
    _builder.append(_id);
    _builder.append("\")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _linkingResourceAdd = this.linkingResourceAdd(lr.getCommunicationLinkResourceSpecifications_LinkingResource());
    _builder.append(_linkingResourceAdd, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence linkingResourceAdd(final CommunicationLinkResourceSpecification clrs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("rc.addActiveResource(");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("(org.palladiosimulator.pcm.resourceenvironment.LinkingResource) org.palladiosimulator.commons.emfutils.EMFLoadHelper.loadAndResolveEObject(\"");
    String _resourceURI = this._simMeasuringPointExt.getResourceURI(clrs.getLinkingResource_CommunicationLinkResourceSpecification());
    _builder.append(_resourceURI, "     ");
    _builder.append("\"),");
    _builder.newLineIfNotEmpty();
    _builder.append("rc.getResourceContainerID());");
    _builder.newLine();
    return _builder;
  }

  public CharSequence nestedResourceContainerAdd(final ResourceContainer rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("rc.addNestedResourceContainer(\"");
    String _id = rc.getId();
    _builder.append(_id);
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence parentResourceContainerAdd(final ResourceContainer rc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("rc.setParentResourceContainer(\"");
    String _id = rc.getId();
    _builder.append(_id);
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence activeResourceAdd(final ProcessingResourceSpecification prs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("String[] ");
    String _javaVariableName = this._javaNamesExt.javaVariableName(prs.getActiveResourceType_ActiveResourceSpecification().getId());
    _builder.append(_javaVariableName);
    _builder.append("_provInterfaces = null;");
    _builder.newLineIfNotEmpty();
    {
      boolean _isEmpty = prs.getActiveResourceType_ActiveResourceSpecification().getResourceProvidedRoles__ResourceInterfaceProvidingEntity().isEmpty();
      if (_isEmpty) {
      } else {
        String _javaVariableName_1 = this._javaNamesExt.javaVariableName(prs.getActiveResourceType_ActiveResourceSpecification().getId());
        _builder.append(_javaVariableName_1);
        _builder.append("_provInterfaces = new String[");
        int _size = prs.getActiveResourceType_ActiveResourceSpecification().getResourceProvidedRoles__ResourceInterfaceProvidingEntity().size();
        _builder.append(_size);
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        int counter0 = 0;
        _builder.newLineIfNotEmpty();
        {
          EList<ResourceProvidedRole> _resourceProvidedRoles__ResourceInterfaceProvidingEntity = prs.getActiveResourceType_ActiveResourceSpecification().getResourceProvidedRoles__ResourceInterfaceProvidingEntity();
          for(final ResourceProvidedRole resProvRole : _resourceProvidedRoles__ResourceInterfaceProvidingEntity) {
            String _javaVariableName_2 = this._javaNamesExt.javaVariableName(prs.getActiveResourceType_ActiveResourceSpecification().getId());
            _builder.append(_javaVariableName_2);
            _builder.append("_provInterfaces[");
            _builder.append(counter0);
            _builder.append("] = \"");
            String _javaString = this._javaNamesExt.javaString(resProvRole.getProvidedResourceInterface__ResourceProvidedRole().getEntityName());
            _builder.append(_javaString);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            String _emptyString = Helper.toEmptyString(Integer.valueOf(counter0 = (counter0 + 1)));
            _builder.append(_emptyString);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("rc.addActiveResource(");
    _builder.newLine();
    _builder.append("(org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification) org.palladiosimulator.commons.emfutils.EMFLoadHelper.loadAndResolveEObject(\"");
    String _resourceURI = this._simMeasuringPointExt.getResourceURI(prs);
    _builder.append(_resourceURI);
    _builder.append("\"),");
    _builder.newLineIfNotEmpty();
    String _javaVariableName_3 = this._javaNamesExt.javaVariableName(prs.getActiveResourceType_ActiveResourceSpecification().getId());
    _builder.append(_javaVariableName_3);
    _builder.append("_provInterfaces,");
    _builder.newLineIfNotEmpty();
    _builder.append("rc.getResourceContainerID(),");
    _builder.newLine();
    _builder.append("\t");
    EObject _eContainer = prs.eContainer();
    CharSequence _schedulingStrategy = this.schedulingStrategy(prs, ((ResourceContainer) _eContainer));
    _builder.append(_schedulingStrategy, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(");");
    _builder.newLine();
    return _builder;
  }

  public CharSequence schedulingStrategy(final ProcessingResourceSpecification prs, final ResourceContainer container) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((prs.getSchedulingPolicy().getId().equals("FCFS") || prs.getSchedulingPolicy().getId().equals("ProcessorSharing")) || prs.getSchedulingPolicy().getId().equals("Delay"))) {
        {
          boolean _equals = prs.getSchedulingPolicy().getId().equals("FCFS");
          if (_equals) {
            _builder.append("de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy.FCFS");
            _builder.newLine();
          }
        }
        {
          boolean _equals_1 = prs.getSchedulingPolicy().getId().equals("ProcessorSharing");
          if (_equals_1) {
            _builder.append("de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy.PROCESSOR_SHARING");
            _builder.newLine();
          }
        }
        {
          boolean _equals_2 = prs.getSchedulingPolicy().getId().equals("Delay");
          if (_equals_2) {
            _builder.append("de.uka.ipd.sdq.simucomframework.resources.SchedulingStrategy.DELAY");
            _builder.newLine();
          }
        }
      } else {
        _builder.append("\"");
        String _id = prs.getSchedulingPolicy().getId();
        _builder.append(_id);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Override
  public CharSequence resourceDemandTM(final ParametricResourceDemand rc) {
    return this.resourceDemand(rc);
  }

  @Override
  public CharSequence resourceDemandTM(final ResourceCall rc) {
    return this.resourceDemand(rc);
  }

  @Override
  public CharSequence passiveResourceInitTM(final PassiveResource pr) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence resourceDemand(final PCMBaseClass rc) {
    if (rc instanceof ResourceCall) {
      return _resourceDemand((ResourceCall)rc);
    } else if (rc instanceof NetworkDemandParametricResourceDemand) {
      return _resourceDemand((NetworkDemandParametricResourceDemand)rc);
    } else if (rc instanceof ParametricResourceDemand) {
      return _resourceDemand((ParametricResourceDemand)rc);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(rc).toString());
    }
  }
}
