package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;

@SuppressWarnings("all")
public abstract class CallsXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private JavaCoreXpt _javaCoreXpt;

  public CharSequence call(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages, final List<VariableUsage> outParameterUsages) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _preCallTM = this.preCallTM(signature, call, prefix, parameterUsages);
    _builder.append(_preCallTM);
    _builder.newLineIfNotEmpty();
    _builder.append(prefix);
    String _javaSignature = this._javaNamesExt.javaSignature(signature);
    _builder.append(_javaSignature);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("(");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(signature);
    _builder.append(_parameterUsageListTM, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _postCallTM = this.postCallTM(signature, call, prefix, outParameterUsages);
    _builder.append(_postCallTM);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence call(final InfrastructureCall infraCall, final Entity call) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("{ //CALL SCOPE: this scope is needed if the same service is called multiple times in one SEFF. Otherwise there is a duplicate local variable definition.");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("long numberOfCalls = ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(infraCall.getNumberOfCalls__InfrastructureCall().getSpecification());
    _builder.append(_specificationString, "   ");
    _builder.append("\",Double.class).longValue();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (long callNumber = 0; callNumber < numberOfCalls; callNumber++) {");
    _builder.newLine();
    _builder.append("\t");
    String _javaName = this._javaNamesExt.javaName(infraCall.getRequiredRole__InfrastructureCall());
    String _plus = ("myContext.getRole" + _javaName);
    final String prefix = (_plus + "().");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _preCallTM = this.preCallTM(infraCall.getSignature__InfrastructureCall(), call, prefix, infraCall.getInputVariableUsages__CallAction());
    _builder.append(_preCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t  \t");
    _builder.append(prefix, "\t  \t");
    String _javaSignature = this._javaNamesExt.javaSignature(infraCall.getSignature__InfrastructureCall());
    _builder.append(_javaSignature, "\t  \t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t  \t\t");
    _builder.append("(");
    CharSequence _parameterUsageListTM = this._javaCoreXpt.parameterUsageListTM(infraCall.getSignature__InfrastructureCall());
    _builder.append(_parameterUsageListTM, "\t  \t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _postCallTM = this.postCallTM(infraCall.getSignature__InfrastructureCall(), call, prefix);
    _builder.append(_postCallTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("} // END CALL SCOPE");
    _builder.newLine();
    return _builder;
  }

  public abstract CharSequence preCallTM(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages);

  public abstract CharSequence preCallTM(final InfrastructureSignature signature, final Entity call, final String prefix, final List<VariableUsage> parameterUsages);

  public abstract CharSequence postCallTM(final OperationSignature signature, final Entity call, final String prefix, final List<VariableUsage> outParameterUsages);

  public abstract CharSequence postCallTM(final InfrastructureSignature signature, final Entity call, final String prefix);
}
